"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const joi_1 = __importDefault(require("joi"));
const utils_1 = require("../../lib/v8/utils");
const pgMaintenanceConfigFileSchema = joi_1.default.object({
    ...utils_1.baseConfigJoi,
    ...{
        PGAPPNAME: joi_1.default.custom((value) => {
            process.env.PGAPPNAME = value;
            return value;
        }).default(() => {
            process.env.PGAPPNAME = "pg_maintenance";
            return process.env.PGAPPNAME;
        }),
    },
});
class PgMaintenanceConfig {
    constructor() {
        (0, utils_1.validatePgPassFile)(process.env.PGPASSFILE);
        const validation = pgMaintenanceConfigFileSchema.validate(process.env, {
            allowUnknown: true,
        });
        if (validation.error) {
            throw validation.error;
        }
        const data = validation.value;
        Object.assign(this, data);
    }
}
const pgMaintenanceConfig = new PgMaintenanceConfig();
exports.default = pgMaintenanceConfig;
