"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyMonitorServiceEmailReceivers = void 0;
const nodemailer_1 = __importDefault(require("nodemailer"));
const monitor_config_1 = __importDefault(require("../monitor.config"));
async function notifyMonitorServiceEmailReceivers(content) {
    const transporter = nodemailer_1.default.createTransport({
        tls: {
            rejectUnauthorized: false,
        },
        auth: {
            user: monitor_config_1.default.SMTP_API_KEY ?? monitor_config_1.default.SMTP_AUTH_USER,
            pass: monitor_config_1.default.SMTP_API_SECRET ?? monitor_config_1.default.SMTP_AUTH_PASS,
        },
        host: monitor_config_1.default.SMTP_HOST ?? "in-v3.mailjet.com",
        port: monitor_config_1.default.SMTP_PORT ?? 25,
        debug: false,
        logger: false,
        secure: false,
        requireTLS: true,
    });
    const mailOptions = {
        from: monitor_config_1.default.SMTP_FROM,
        to: monitor_config_1.default.EMAIL_RECEIVERS,
        ...content,
    };
    await transporter.sendMail(mailOptions);
    transporter.close();
}
exports.notifyMonitorServiceEmailReceivers = notifyMonitorServiceEmailReceivers;
