"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const elastic_apm_node_1 = __importDefault(require("elastic-apm-node"));
if (process.env.ELASTIC_APM_SERVER_URL &&
    process.env.ELASTIC_APM_SECRET_TOKEN &&
    process.env.ELASTIC_APM_PREFIX &&
    ((process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "true" && process.env.ELASTIC_APM_SERVER_CA_CERT_FILE) || process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "false")) {
    elastic_apm_node_1.default.start({
        serviceName: `${process.env.ELASTIC_APM_PREFIX}-monitor`,
        serverUrl: process.env.ELASTIC_APM_SERVER_URL,
        secretToken: process.env.ELASTIC_APM_SECRET_TOKEN,
        environment: "production",
        serverCaCertFile: process.env.ELASTIC_APM_SERVER_CA_CERT_FILE ?? null,
        verifyServerCert: process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "true",
    });
}
else {
    console.warn(`Elastic APM is not enabled. Please set ELASTIC_APM_SERVER_URL, ELASTIC_APM_SECRET_TOKEN, ELASTIC_APM_PREFIX, ELASTIC_APM_VERIFY_SERVER_CERT, and ELASTIC_APM_SERVER_CA_CERT_FILE environment variables.`);
}
const pg_1 = require("pg");
const app_logs_1 = require("../../app.logs");
const monitor_config_1 = __importDefault(require("./monitor.config"));
const deadLetter_1 = require("./services/deadLetter");
const pool = new pg_1.Pool({
    user: monitor_config_1.default.PGUSER,
    application_name: "monitor_" + process.env.HOSTNAME,
    max: 100,
    keepAlive: true,
});
const appTag = "[app.monitor]";
async function start() {
    app_logs_1.logger.info("%sMonitoring service is starting...", appTag);
    try {
        app_logs_1.logger.debug("%sEnvironmantal veriables is loading...", appTag);
        app_logs_1.appLogger.init(monitor_config_1.default.LOG_DIRECTORY);
        app_logs_1.logger.debug("%sDead letter check service is starting...", appTag);
        await (0, deadLetter_1.startDeadLetterQueueCheckService)(pool);
        app_logs_1.logger.debug("%sDefault partition entry check service is starting...", appTag);
        await (0, deadLetter_1.startDefaultPartitionEntryCheckService)(pool);
        app_logs_1.logger.info("%sMonitor service is started!", appTag);
    }
    catch (error) {
        app_logs_1.logger.error(error || error.message);
        process.exit(1);
    }
}
start();
