"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationBasic = exports.IntegrationEntityType = exports.OperationStatus = void 0;
const app_logs_1 = require("../../../app.logs");
const api_identity_1 = require("../httpServer/identity/api.identity");
const api_organizationUnit_1 = require("../httpServer/organizationUnit/api.organizationUnit");
const api_leave_1 = __importDefault(require("../httpServer/leave/api.leave"));
const api_workplan_1 = __importDefault(require("../httpServer/workplan/api.workplan"));
const api_credential_1 = __importDefault(require("../httpServer/credential/api.credential"));
var OperationStatus;
(function (OperationStatus) {
    OperationStatus[OperationStatus["Pending"] = 1] = "Pending";
    OperationStatus[OperationStatus["InProgress"] = 2] = "InProgress";
    OperationStatus[OperationStatus["Success"] = 3] = "Success";
    OperationStatus[OperationStatus["Partial"] = 4] = "Partial";
    OperationStatus[OperationStatus["Failure"] = 5] = "Failure";
})(OperationStatus = exports.OperationStatus || (exports.OperationStatus = {}));
var IntegrationEntityType;
(function (IntegrationEntityType) {
    IntegrationEntityType[IntegrationEntityType["User"] = 1] = "User";
    IntegrationEntityType[IntegrationEntityType["OrganizationUnit"] = 2] = "OrganizationUnit";
})(IntegrationEntityType = exports.IntegrationEntityType || (exports.IntegrationEntityType = {}));
class IntegrationBasic {
    constructor(pool, apiToken, taskFactory) {
        this.pool = pool;
        this.apiToken = apiToken;
        this.taskFactory = taskFactory;
    }
    async initialize(router) {
        const existingRoutes = [];
        router._router.stack.forEach(this.print.bind(this, existingRoutes, []));
        const organizationUnitAPI = new api_organizationUnit_1.OrganizationUnitAPI(this.pool, this.apiToken, this.taskFactory);
        const identityAPI = new api_identity_1.IdentityAPI(this.pool, this.apiToken, this.taskFactory);
        const leaveAPI = new api_leave_1.default(this.pool, this.apiToken, this.taskFactory);
        const workPlanAPI = new api_workplan_1.default(this.pool, this.apiToken, this.taskFactory);
        const credentialAPI = new api_credential_1.default(this.pool, this.apiToken, this.taskFactory);
        if (!existingRoutes.includes(`POST:/integration/:oid/user/upsert`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/user/upsert`);
            router.post(`/integration/:oid/user/upsert`, identityAPI.upsertIdentity.bind(identityAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/user/upsert/queued`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/user/upsert/queued`);
            router.post(`/integration/:oid/user/upsert/queued`, identityAPI.upsertUserQueued.bind(identityAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/organizationUnit/upsert`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/organizationUnit/upsert`);
            router.post(`/integration/:oid/organizationUnit/upsert`, organizationUnitAPI.upsertUnit.bind(organizationUnitAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/organizationUnit/upsert/queued`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/organizationUnit/upsert/queued`);
            router.post(`/integration/:oid/organizationUnit/upsert/queued`, organizationUnitAPI.upsertUnitQueued.bind(organizationUnitAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/leave/apply`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/leave/apply`);
            router.post(`/integration/:oid/leave/apply`, leaveAPI.insertLeave.bind(leaveAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/leave/apply/queued`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/leave/apply/queued`);
            router.post(`/integration/:oid/leave/apply/queued`, leaveAPI.insertLeaveQueued.bind(leaveAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/leave/list`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/leave/list`);
            router.post(`/integration/:oid/leave/list`, leaveAPI.listLeaves.bind(leaveAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/workplan/apply`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/workplan/apply`);
            router.post(`/integration/:oid/workplan/apply`, workPlanAPI.insertWorkPlan.bind(workPlanAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/workplan/apply/queued`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/workplan/apply/queued`);
            router.post(`/integration/:oid/workplan/apply/queued`, workPlanAPI.insertWorkPlanQueued.bind(workPlanAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/workplan/list`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/workplan/list`);
            router.post(`/integration/:oid/workplan/list`, workPlanAPI.listWorkPlans.bind(workPlanAPI));
        }
        if (!existingRoutes.includes(`POST:/integration/:oid/credential/ask`)) {
            app_logs_1.logger.info(`Registering default handler for POST:/integration/:oid/credential/ask`);
            router.post(`/integration/:oid/credential/ask`, credentialAPI.searchCredential.bind(credentialAPI));
        }
    }
    print(result, path, layer) {
        if (layer.route) {
            layer.route.stack.forEach(this.print.bind(this, result, path.concat(this.split(layer.route.path))));
        }
        else if (layer.name === "router" && layer.handle.stack) {
            layer.handle.stack.forEach(this.print.bind(this, result, path.concat(this.split(layer.regexp))));
        }
        else if (layer.method) {
            result.push(layer.method.toUpperCase() + ":/" + path.concat(this.split(layer.regexp)).filter(Boolean).join("/"));
        }
    }
    split(thing) {
        if (typeof thing === "string") {
            return thing.split("/");
        }
        else if (thing.fast_slash) {
            return "";
        }
        else {
            var match = thing
                .toString()
                .replace("\\/?", "")
                .replace("(?=\\/|$)", "$")
                .match(/^\/\^((?:\\[.*+?^${}()|[\]\\\/]|[^.*+?^${}()|[\]\\\/])*)\$\//);
            return match ? match[1].replace(/\\(.)/g, "$1").split("/") : "<complex:" + thing.toString() + ">";
        }
    }
}
exports.IntegrationBasic = IntegrationBasic;
