"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const api_validatorhelper_1 = require("../../../api/api.validatorhelper");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const integration_config_1 = __importDefault(require("../integration.config"));
const crypto = __importStar(require("crypto"));
class MKEOrg {
    constructor(_pool, apiToken, taskFactory) {
        this.pool = _pool;
    }
    async initialize(router) {
        const orgPrivateKey = (await this.pool.query(`SELECT "privateKey" FROM "${MKEOrg.orgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizations}"
			`)).rows[0].privateKey;
        this.ecdh = crypto.createECDH("prime256v1");
        this.ecdh.setPrivateKey(orgPrivateKey, "base64");
        app_logs_1.logger.info(`Registering custom handler for /integration/${MKEOrg.orgId}/device/qr`);
        router.post(`/integration/${MKEOrg.orgId}/device/qr`, this.generateQR.bind(this));
    }
    async generateQR(req, res) {
        try {
            const validator = new api_validatorhelper_1.ValidatorHelper();
            validator.validateString({ field: `uniqueId`, optional: false, input: req.body.uniqueId, maxLength: 255 });
            validator.finalize();
        }
        catch (error) {
            return res.status(400).send(error);
        }
        try {
            const data = await this.generateQrDataAsHex(req.body.uniqueId);
            res.json({
                data: data,
            });
        }
        catch (error) {
            app_logs_1.logger.error("Error while generating Qr:");
            app_logs_1.logger.error(error);
            res.status(app_enums_1.enums.HttpStatusCode.NOT_FOUND).send();
        }
    }
    async generateQrDataAsHex(uniqueId) {
        let userId = (await this.pool.query(`SELECT "userId" FROM "${MKEOrg.orgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" WHERE "uniqueId" = $1`, [uniqueId])).rows[0]
            ?.userId;
        if (!userId) {
            throw new Error("USERNOTFOUND");
        }
        userId = userId.replace(/-/g, "");
        const data = new Uint8Array(21);
        data[0] = 0x02;
        const epoch = new Date().getTime() / 1000;
        for (let i = 0; i < 4; i++) {
            data[4 - i] = (epoch >> (i * 8)) & 0xff;
        }
        const userIdBuffer = Buffer.from(userId, "hex");
        for (let i = 0; i < 16; i++) {
            data[5 + i] = userIdBuffer[i];
        }
        let sharedSecret = this.ecdh.computeSecret(MKEOrg.apiQRPublicKey, "base64");
        let signature = crypto.createHmac("sha512", sharedSecret).update(data).digest("hex");
        let finalData = Array.from(data, (b) => b.toString(16).padStart(2, "0")).join("") + signature;
        return finalData;
    }
}
MKEOrg.orgId = integration_config_1.default.INTEGRATION_ORGANIZATION;
MKEOrg.apiQRPublicKey = "BO2F13ejjH3dZqBc84nDgCAoyifU665Rt+ByL3QXHl1UnPDylFFcGgRzemhNOAq91m0twJRKHxe9QX7V2Y2uM1g=";
exports.default = MKEOrg;
