"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const app_logs_1 = require("../../../app.logs");
const integration_config_1 = __importDefault(require("../integration.config"));
const log_1 = require("./tk_holding/log");
class TKEtOrg {
    constructor(_pool, apiToken, taskFactory) {
        this.pool = _pool;
        this.apiToken = apiToken;
        this.taskFactory = taskFactory;
    }
    async initialize(router) {
        app_logs_1.logger.info(`Registering custom handler for /integration/${TKEtOrg.orgId}/log`);
        router.post(`/integration/${TKEtOrg.orgId}/log`, this.log.bind(this));
    }
    async log(req, res) {
        const log = new log_1.Log();
        return await log.log(req, res, this.pool, TKEtOrg.orgId, this.apiToken);
    }
}
TKEtOrg.orgId = integration_config_1.default.INTEGRATION_ORGANIZATION;
exports.default = TKEtOrg;
