"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultLeaveTask = void 0;
const luxon_1 = require("luxon");
const app_logs_1 = require("../../../../app.logs");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const integration_config_1 = __importDefault(require("../../integration.config"));
const integration_base_1 = require("../../integrations/integration.base");
class DefaultLeaveTask {
    static create() {
        return new DefaultLeaveTask();
    }
    async execute(trx, token, taskId, leaveData) {
        app_logs_1.logger.info("Executing task for these ids: " + leaveData.ids);
        const taskdata = {
            uniqueId: leaveData.leaveId,
            taskid: taskId,
        };
        const users = (await trx.query(`SELECT uop."userId", uop."uniqueId"
				FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" uop
				WHERE uop."uniqueId" =ANY($1::varchar[])`, [leaveData.ids])).rows;
        const reqBody = {
            ppermissionTypeId: leaveData.leaveId,
            dateRange: {
                startDateTime: leaveData.startUtc,
                endDateTime: leaveData.endUtc,
            },
            userAndDeputyList: leaveData.ids.map((id) => {
                return { userId: users.find((user) => user.uniqueId === id)?.userId ?? null };
            }),
            performValidations: false,
        };
        let response;
        try {
            response = await token.httpRequest(taskdata, "POST", `/p/v1/${integration_config_1.default.INTEGRATION_ORGANIZATION}/ppermission/upsertwithusers`, reqBody);
        }
        catch (error) {
            app_logs_1.logger.error("Could not apply leave: " + error.status + " - " + error.message);
            throw error;
        }
        if (response?.status === 200) {
            app_logs_1.logger.info(`leave successfully applied for given users`);
        }
        return integration_base_1.OperationStatus.Success;
    }
    isMidnight(isoString) {
        const dateTime = luxon_1.DateTime.fromISO(isoString);
        return dateTime.hour === 0 && dateTime.minute === 0 && dateTime.second === 0;
    }
    isMidDay(isoString) {
        const dateTime = luxon_1.DateTime.fromISO(isoString);
        return dateTime.hour === 12 && dateTime.minute === 0 && dateTime.second === 0;
    }
}
exports.DefaultLeaveTask = DefaultLeaveTask;
DefaultLeaveTask.id = "e2c03f2b-88b6-4486-a8b5-092aa7675f64";
