"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateUserProfiles = void 0;
const app_logs_1 = require("../../../../app.logs");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const sharp_1 = __importDefault(require("sharp"));
const updateUserProfiles = async (client) => {
    try {
        const users = await client.query(`
			SELECT DISTINCT ON (data->'id') data->'name' as name, data->'id' as id, data->'photo' as photo
			FROM "cf1a899a-bb3f-4379-9b25-4c6d7a89a80f"."integration_tasks"
			WHERE data->>'photo' != ''
			ORDER BY data->'id', "createdAt" DESC;`);
        for (let row of users.rows) {
            let avatar = "";
            if (row.photo) {
                const base64Data = new Buffer(row.photo.replace(/^data:image\/\w+;base64,/, ""), "base64");
                avatar = (await (0, sharp_1.default)(base64Data, { failOnError: false }).resize(256, 256).jpeg({ quality: 90 }).toFormat("jpeg").toBuffer()).toString("base64");
                avatar = "data:image/jpeg;base64," + avatar;
            }
            await client.query(`
				UPDATE "cf1a899a-bb3f-4379-9b25-4c6d7a89a80f"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}"
				SET "thumbnail" = $1
				WHERE "uniqueId" = $2`, [avatar, row.id]);
        }
        app_logs_1.logger.debug(`Profile photos updated for "cf1a899a-bb3f-4379-9b25-4c6d7a89a80f". ${users.rowCount} users photos are updated.`);
    }
    catch (e) {
        app_logs_1.logger.debug(e);
    }
};
exports.updateUserProfiles = updateUserProfiles;
