"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.scaffoldDb = exports.dropAndCreateDbAgain = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const cli_config_1 = __importDefault(require("../../cli.config"));
const app_logs_1 = require("../../../../app.logs");
async function dropAndCreateDbAgain(trx, dbuser, dbsuperuser) {
    try {
        const schemaNames = (await trx.query(`
			SELECT schema_name FROM information_schema.schemata 
			WHERE schema_name NOT ILIKE 'pg_%' 
			AND schema_name != 'information_schema';
		`)).rows;
        for (const sn of schemaNames.map((s) => s.schema_name)) {
            await trx.query(`DROP SCHEMA IF EXISTS "${sn}" CASCADE;`);
        }
        await scaffoldDb(trx, dbuser, dbsuperuser);
    }
    catch (error) {
        app_logs_1.logger.error(error);
        throw error;
    }
}
exports.dropAndCreateDbAgain = dropAndCreateDbAgain;
async function scaffoldDb(trx, dbuser, dbsuperuser) {
    try {
        let assetsDirectory = null;
        if (cli_config_1.default.NODE_ENV == "development") {
            assetsDirectory = path_1.default.join(__dirname, "..", "..", "..", "..", "..", "assets", "db");
        }
        else {
            assetsDirectory = path_1.default.join(__dirname, "..", "..", "..", "..", "assets", "db");
        }
        await trx.query(fs_1.default.readFileSync(path_1.default.resolve(assetsDirectory, "scaffold-armon-db-out.sql"), "utf-8"));
        await trx.query(`		
			GRANT TEMPORARY ON DATABASE armon TO ${dbuser};
			ALTER DEFAULT PRIVILEGES FOR ROLE ${dbsuperuser} GRANT USAGE ON SCHEMAS TO ${dbuser};
			ALTER DEFAULT PRIVILEGES FOR ROLE ${dbsuperuser} GRANT SELECT, UPDATE, USAGE ON SEQUENCES TO ${dbuser};
			ALTER DEFAULT PRIVILEGES FOR ROLE ${dbsuperuser} GRANT EXECUTE ON FUNCTIONS TO ${dbuser};
			ALTER DEFAULT PRIVILEGES FOR ROLE ${dbsuperuser} GRANT SELECT, INSERT, UPDATE, DELETE ON TABLES TO ${dbuser};
		`);
    }
    catch (error) {
        app_logs_1.logger.error(error);
        throw error;
    }
}
exports.scaffoldDb = scaffoldDb;
