"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const dal_manager_1 = require("../../dal/dal.manager");
const app_config_1 = require("../../app.config");
const app_constants_1 = require("../../app.constants");
const dal_constants_1 = require("../../dal/dal.constants");
const business_hooks_1 = require("../../business/business.hooks");
const app_logs_1 = require("../../app.logs");
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const organizationId = "cf1a899a-bb3f-4379-9b25-4c6d7a89a80f";
async function startSyncOperations() {
    const args = process.argv;
    app_config_1.appConfig.init(app_constants_1.ServiceNames.Custom);
    business_hooks_1.armonHookManager.init();
    await dal_manager_1.dbManager.init({
        main: app_config_1.appConfig.db.main,
        log: app_config_1.appConfig.db.log,
        environment: app_config_1.appConfig.nodeEnv,
        logDirectory: app_config_1.appConfig.dbLogDirectory,
        redis: app_config_1.appConfig.db.redis,
    }, false, false, false, false);
    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const hook = business_hooks_1.armonHookManager.getAfterIdentityUpsertHook(organizationId);
        if (!hook) {
            app_logs_1.logger.error(`No hook for organization with id ${organizationId}. Aborting sync process...`);
            return;
        }
        if (fs_1.default.existsSync(args[2])) {
            const uniqueIds = fs_1.default.readFileSync(args[2], "utf8").split(/\r?\n/);
            const pathParams = args[2].split(path_1.default.sep);
            pathParams[pathParams.length - 1] = "out.txt";
            for (const uid of uniqueIds) {
                app_logs_1.logger.warn(`=========================================================================================`);
                app_logs_1.logger.warn(`Processing user with unique id [${uid}]`);
                try {
                    const userId = await dal_manager_1.dbManager.accessUser.getUserIdFromUniqueId(organizationId, uid);
                    const identity = await dal_manager_1.dbManager.accessIdentity.getIdentityDetailed(organizationId, dal_constants_1.DalConstants.SystemUserId, {
                        userId,
                        hasIdentityFullWrite: true,
                        hasOrganizationWideRight: true,
                        hasOrganizationWideRightToSeePassiveUsers: true,
                        permittedUnitIds: null,
                        trx,
                    });
                    const res = await hook(identity, identity);
                    if (res) {
                        fs_1.default.writeFileSync(pathParams.join(path_1.default.sep), `[${new Date().toISOString()}]User with unique id [${uid}] is successfully synchronized with KeyCloak\n`, { flag: "a+" });
                        app_logs_1.logger.info(`User with unique id [${uid}] is successfully synchronized with KeyCloak`);
                    }
                    else {
                        fs_1.default.writeFileSync(pathParams.join(path_1.default.sep), `[${new Date().toISOString()}]User with unique id [${uid}] failed to synchronize with KeyCloak. Please check logs near timestamp\n`, { flag: "a+" });
                        app_logs_1.logger.error(`User with unique id [${uid}] failed to synchronize with KeyCloak. Please check above logs`);
                    }
                }
                catch (err) {
                    app_logs_1.logger.error(`Error while processing user with unique id [${uid}]`);
                    app_logs_1.logger.error(err);
                }
                const delay = new Promise((resolve) => {
                    setTimeout(resolve, 30000);
                });
                await delay;
            }
        }
        else {
            app_logs_1.logger.error(`File with user unique ids ${args[2]} does not exists on filesystem!`);
        }
    });
    process.exit(0);
}
startSyncOperations();
