"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.arventoAccessLogsSync = exports.arventoRegionDataSync = exports.terminateVisitsByActivatedViaExcel = exports.registerVisitorsPreregisteredViaExcel = exports.webRtcTwilioIceServerRefresher = exports.pacsMissingDayEntryFinder = exports.ppermissionSignatureReminder = exports.dailyExpiredReportRemover = exports.visitTerminator = exports.pacsSelfOverworkedEmployeeNotifier = exports.pacsSelfAbsentEmployeeNotifier = exports.pacsSelfMissedWorkNotifier = exports.expiredSessionCleaner = exports.employmentEndDisabler = exports.visitorGdprAnonymization = void 0;
const moment = require("moment");
const fs = __importStar(require("fs"));
const i18n_1 = __importDefault(require("i18n"));
const path = __importStar(require("path"));
const twilio_1 = __importDefault(require("twilio"));
const app_config_1 = require("../../app.config");
const app_enums_1 = require("../../app.enums");
const app_httpserver_1 = require("../../app.httpserver");
const app_logs_1 = require("../../app.logs");
const dal_memcache_1 = require("../../dal/access/dal.memcache");
const dal_constants_1 = require("../../dal/dal.constants");
const dal_manager_1 = require("../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../dal/db/armon/dal.db.armon.schema");
const messageBroker_server_to_pacs_pub_1 = require("../../messageBroker/messageBroker.server-to-pacs.pub");
const api_arvento_1 = require("../../business/arvento/api.arvento");
const business_visitor_1 = require("../visitor/business.visitor");
const dal_utils_1 = require("../../dal/dal.utils");
async function visitorGdprAnonymization(trx) {
    const date = new Date();
    const organizationIds = await dal_manager_1.dbManager.accessOrganization.listOrganizationPg(trx);
    for (const organizationId of organizationIds) {
        const visitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(organizationId);
        if (visitorModuleSettings.gdprEnabled) {
            const lookUpDate = moment(date).add(-visitorModuleSettings.gdprSettings.anonymizationDuration, "day");
            await dal_manager_1.dbManager.accessVisitor.updateExpiredVisitorProfilesAsAnonym({ organizationId, date: lookUpDate.toDate(), trx });
        }
    }
}
exports.visitorGdprAnonymization = visitorGdprAnonymization;
async function employmentEndDisabler(trx) {
    const date = new Date();
    const organizationIds = await dal_manager_1.dbManager.accessOrganization.listOrganizationPg(trx);
    for (const organizationId of organizationIds) {
        const { rows } = await trx.query(`
                SELECT uo."userId", uop."name", uop."surname" FROM "${organizationId}"."userOrganizations" uo
                INNER JOIN "${organizationId}"."userOrganizationProfiles" uop ON uop."userOrganizationId" = uo.id
                WHERE uo."isDisabled" = false AND uop."employmentEndUtc" < now() AND uop."deletedAt" IS NULL AND uo."deletedAt" IS NULL
                `);
        const userIds = rows.map((r) => r.userId);
        const identityOptions = {
            hasOrganizationWideRight: true,
            hasIdentityFullWrite: true,
            permittedUnitIds: null,
            hasOrganizationWideRightToSeePassiveUsers: true,
        };
        const oldIdentities = [];
        for (const userId of userIds) {
            const oldIdentity = await dal_manager_1.dbManager.accessIdentity.getIdentityDetailed(organizationId, dal_constants_1.DalConstants.SystemUserId, {
                ...identityOptions,
                userId,
                trx,
            });
            oldIdentities.push(oldIdentity);
        }
        await dal_manager_1.dbManager.accessIdentity.disableUsers(organizationId, userIds, trx, true);
        const newIdentities = [];
        for (const userId of userIds) {
            const newIdentity = await dal_manager_1.dbManager.accessIdentity.getIdentityDetailed(organizationId, dal_constants_1.DalConstants.SystemUserId, {
                ...identityOptions,
                userId,
                trx,
            });
            newIdentities.push(newIdentity);
        }
        for (let i = 0; i < userIds.length; i++) {
            await dal_manager_1.dbManager.accessIdentity.logProfileUpdate(organizationId, dal_constants_1.DalConstants.SystemUserId, oldIdentities[i], newIdentities[i]);
        }
    }
}
exports.employmentEndDisabler = employmentEndDisabler;
async function expiredSessionCleaner(trx) {
    const date = new Date();
    const organizationIds = await dal_manager_1.dbManager.accessOrganization.listOrganizationPg(trx);
    for (const organizationId of organizationIds) {
        const deletedSessionCount = await dal_manager_1.dbManager.accessUser.deleteExpiredSessions({ organizationId, controlDateUTC: date, trx });
        app_logs_1.logger.info("deleted session count : " + deletedSessionCount + " at date : " + date.toDateString());
        const deletedExpectedVisitCount = await dal_manager_1.dbManager.accessVisitor.deletePastExpectedVisits({ organizationId, date, trx });
        app_logs_1.logger.info("expected visits not realised are deleted count : " + deletedExpectedVisitCount);
        const deletedStates = await dal_manager_1.dbManager.accessVisitor.deleteRemovedVisitorStates({ organizationId, trx });
        app_logs_1.logger.info("deleted visitor states: " + deletedStates);
    }
}
exports.expiredSessionCleaner = expiredSessionCleaner;
const refreshUsersSummaryForToday = async function (params) {
    return new Promise(async (resolve, reject) => {
        await (0, messageBroker_server_to_pacs_pub_1.sendToPacsRpcQueue)({
            message: {
                i: "",
                v: "1",
                n: app_enums_1.enums.AmqpMessageCode.RelcalculateFilteredPACSEmployees,
                o: params.organizationId,
                a: 0,
                d: {
                    r: params.requesterUserId,
                    a: params.applyOrganizationUnitFilterHierarchically,
                    g: params.userGroupIds,
                    o: params.organizationId,
                    n: params.organizationUnitIds,
                    s: params.userOrganizationStatus,
                    u: params.userIds,
                    p: params.requiredOrganizationWidePermissions,
                    pu: params.requiredOrganizationUnitWidePermissions,
                },
            },
            expiration: 10000,
            callback: () => resolve(),
        });
    });
};
async function pacsSelfMissedWorkNotifier(organizationId, scheduledJob, trx) {
    const pacsSettings = await dal_manager_1.dbManager.accessSystem.getPACSNotificationScheduledJob({
        id: scheduledJob.id,
        organizationId,
        trx,
    });
    const bindingKeys = [];
    const filteredUserIds = (await trx.query((0, dal_utils_1.generateUserFilterQuery)(organizationId, pacsSettings.userFilter.id, bindingKeys), bindingKeys)).rows.map((r) => r.userId);
    const endDate = new Date();
    const startDate = new Date(new Date().setHours(0, 0, 0, 0));
    await refreshUsersSummaryForToday({
        requesterUserId: dal_constants_1.DalConstants.SystemUserId,
        applyOrganizationUnitFilterHierarchically: false,
        organizationId: organizationId,
        userIds: filteredUserIds,
        requiredOrganizationWidePermissions: [],
        requiredOrganizationUnitWidePermissions: [],
    });
    const missingWorkUsers = await dal_manager_1.dbManager.accessPacs2.getDailyMissingWorkUserIds({
        organizationId,
        userIds: filteredUserIds,
        trx,
    });
    const notificationEvents = [];
    for (const missingWorkUser of missingWorkUsers) {
        const instanceData = {
            d: missingWorkUser.missingWork,
            e: endDate,
            s: startDate,
            u: missingWorkUser.userId,
            receiverUserIds: [missingWorkUser.userId],
        };
        const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId: scheduledJob.notificationId,
            organizationId,
            instanceData,
            trx,
        });
        notificationEvents.push({
            v: "1",
            n: app_enums_1.enums.AmqpMessageCode.Empty,
            a: 0,
            i: notificationEventId,
            o: organizationId,
            d: instanceData,
        });
    }
    return notificationEvents;
}
exports.pacsSelfMissedWorkNotifier = pacsSelfMissedWorkNotifier;
async function pacsSelfAbsentEmployeeNotifier(organizationId, scheduledJob, trx) {
    const pacsSettings = await dal_manager_1.dbManager.accessSystem.getPACSNotificationScheduledJob({
        id: scheduledJob.id,
        organizationId,
        trx,
    });
    const bindingKeys = [];
    const filteredUserIds = (await trx.query((0, dal_utils_1.generateUserFilterQuery)(organizationId, pacsSettings.userFilter.id, bindingKeys), bindingKeys)).rows.map((r) => r.userId);
    const endDate = new Date();
    const startDate = new Date(new Date().setHours(0, 0, 0, 0));
    await refreshUsersSummaryForToday({
        requesterUserId: dal_constants_1.DalConstants.SystemUserId,
        applyOrganizationUnitFilterHierarchically: false,
        organizationId: organizationId,
        userIds: filteredUserIds,
        requiredOrganizationWidePermissions: [],
        requiredOrganizationUnitWidePermissions: [],
    });
    const absentUserIds = await dal_manager_1.dbManager.accessPacs2.getAbsentUserIds({
        organizationId,
        userIds: filteredUserIds,
        trx,
    });
    const notificationEvents = [];
    for (const absentUserId of absentUserIds) {
        const instanceData = {
            d: null,
            e: endDate,
            s: startDate,
            u: absentUserId,
            receiverUserIds: [absentUserId],
        };
        const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId: scheduledJob.notificationId,
            organizationId,
            trx,
            instanceData,
        });
        notificationEvents.push({
            v: "1",
            n: app_enums_1.enums.AmqpMessageCode.Empty,
            a: 0,
            i: notificationEventId,
            o: organizationId,
            d: instanceData,
        });
    }
    return notificationEvents;
}
exports.pacsSelfAbsentEmployeeNotifier = pacsSelfAbsentEmployeeNotifier;
async function pacsSelfOverworkedEmployeeNotifier(organizationId, scheduledJob, trx) {
    const pacsSettings = await dal_manager_1.dbManager.accessSystem.getPACSNotificationScheduledJob({
        id: scheduledJob.id,
        organizationId,
        trx,
    });
    const bindingKeys = [];
    const filteredUserIds = (await trx.query((0, dal_utils_1.generateUserFilterQuery)(organizationId, pacsSettings.userFilter.id, bindingKeys), bindingKeys)).rows.map((r) => r.userId);
    const endDate = new Date();
    const startDate = new Date(new Date().setHours(0, 0, 0, 0));
    await refreshUsersSummaryForToday({
        requesterUserId: dal_constants_1.DalConstants.SystemUserId,
        applyOrganizationUnitFilterHierarchically: false,
        organizationId: organizationId,
        userIds: filteredUserIds,
        requiredOrganizationWidePermissions: [],
        requiredOrganizationUnitWidePermissions: [],
    });
    const overworkedUserIds = await dal_manager_1.dbManager.accessPacs2.getOverworkedUserIds({
        organizationId,
        userIds: filteredUserIds,
        trx,
    });
    const notificationEvents = [];
    for (const overworkedUserId of overworkedUserIds) {
        const instanceData = {
            d: null,
            e: endDate,
            s: startDate,
            u: overworkedUserId,
            receiverUserIds: [overworkedUserId],
        };
        const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId: scheduledJob.notificationId,
            organizationId,
            trx,
            instanceData,
        });
        notificationEvents.push({
            v: "1",
            n: app_enums_1.enums.AmqpMessageCode.Empty,
            a: 0,
            i: notificationEventId,
            o: organizationId,
            d: instanceData,
        });
    }
    return notificationEvents;
}
exports.pacsSelfOverworkedEmployeeNotifier = pacsSelfOverworkedEmployeeNotifier;
async function visitTerminator(organizationId, trx) {
    const MAX_VISIT_TERMINATE_COUNT = 10000;
    const organizationVisitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(organizationId);
    const organizationVisitorRegistrationPoints = await dal_manager_1.dbManager.accessVisitor.listRegistrationPointsDetailed(organizationId);
    for (const rp of organizationVisitorRegistrationPoints) {
        if (rp.id) {
            const unterminatedVisitsOfOrganization = await dal_manager_1.dbManager.accessVisitor.listUnterminatedVisits(organizationId, {
                take: MAX_VISIT_TERMINATE_COUNT,
                skip: 0,
                filter: {
                    profileFields: [],
                    state: dal_constants_1.DalConstants.UnterminatedVisitState.Active,
                    visitFields: [],
                },
                visitorRegistrationPointId: rp.id,
            }, organizationVisitorModuleSettings);
            for (const visit of unterminatedVisitsOfOrganization.items) {
                let expectedEnd = visit.visitFields.expectedDate.endDate;
                if (!expectedEnd || Date.now() > new Date(expectedEnd).valueOf()) {
                    await dal_manager_1.dbManager.accessVisitor.terminateVisit(organizationId, visit.visitId, organizationVisitorModuleSettings, dal_constants_1.DalConstants.SystemUserId);
                }
            }
            app_httpserver_1.httpServer.sendVisitorListChangedNotification(organizationId);
        }
    }
    app_logs_1.logger.debug("Expired Visits are Terminated by Terminator");
}
exports.visitTerminator = visitTerminator;
async function dailyExpiredReportRemover(trx) {
    const organizationIds = await dal_manager_1.dbManager.accessOrganization.listOrganizationPg(trx);
    for (const organizationId of organizationIds) {
        const expiredReportIds = await dal_manager_1.dbManager.accessReport.getExpiredPreparedReportList({ organizationId, trx });
        for (const expiredReportId of expiredReportIds) {
            if (fs.existsSync(path.join(app_config_1.appConfig.preparedReportDirectory + expiredReportId))) {
                fs.unlinkSync(path.join(app_config_1.appConfig.preparedReportDirectory + expiredReportId));
            }
        }
    }
}
exports.dailyExpiredReportRemover = dailyExpiredReportRemover;
async function ppermissionSignatureReminder(organizationId, trx) {
    const unsignedPastPPermissionsUserList = await dal_manager_1.dbManager.accessPacs.listUsersWithUnsignedPastPPermissions(organizationId, new Date());
    const notificationEvents = [];
    for (let user of unsignedPastPPermissionsUserList) {
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.PPermissionWaitForSignatureReminder, trx);
        const instanceData = {
            p: user.ppermissionId,
            receiverUserIds: [user.userId],
        };
        const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            instanceData,
            trx,
        });
        notificationEvents.push({
            v: "1",
            n: app_enums_1.enums.AmqpMessageCode.Empty,
            a: 0,
            i: notificationEventId,
            o: organizationId,
            d: instanceData,
        });
    }
    return notificationEvents;
}
exports.ppermissionSignatureReminder = ppermissionSignatureReminder;
async function pacsMissingDayEntryFinder(trx) {
    let startDate = moment().subtract(3, "day").format("YYYY-MM-DD");
    let endDate = moment().subtract(1, "day").format("YYYY-MM-DD");
    const organizationIds = await dal_manager_1.dbManager.accessOrganization.listOrganizationPg(trx);
    for (const organizationId of organizationIds) {
        let missing = await trx.query(`
		INSERT INTO "${organizationId}"."recalculateWorkQueue"
		("id", "userId", "organizationId", "reason", "startDate")
		SELECT uuid_generate_v4(), uwp."userId", '${organizationId}', 128, MIN(range.date)
		FROM "${organizationId}"."userWorkPlans" uwp
		INNER JOIN (
			SELECT dttt.sdt, dttt.sdt + interval '24 hour' as edt, dttt.sdt::date as date FROM
			(
				SELECT generate_series('${startDate}'::timestamp with time zone, '${endDate}', '1 day') AS sdt
			) dttt
		) range
		ON tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange(range.sdt, range.edt)
		INNER JOIN "${organizationId}"."workPlans" wp
		ON wp.id = uwp."workPlanId" AND wp."deletedAt" IS NULL
		INNER JOIN "${organizationId}"."vW_WorkPlanPeriodTstzrange" wpp
		ON wpp."workPlanId" = wp.id AND wpp.range && tstzrange(range.sdt, range.edt)
		INNER JOIN "${organizationId}"."userOrganizationProfiles" uop
		ON uop."userId" = uwp."userId" AND uop."deletedAt" IS NULL
		INNER JOIN "${organizationId}"."userOrganizations" uo
		ON uo."userId" = uwp."userId" AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
		LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeDays}" ed
		ON uwp."userId" = ed."userId" AND ed.date = range.date
		WHERE ed.id IS NULL
		GROUP BY uwp."userId"
		RETURNING "userId", "startDate";
		`);
        for (const row of missing.rows) {
            app_logs_1.logger.info("Created recalculation entry: " + organizationId + " - " + row.userId + " - " + moment(row.startDate).format("YYYY-MM-DD"));
        }
    }
}
exports.pacsMissingDayEntryFinder = pacsMissingDayEntryFinder;
async function webRtcTwilioIceServerRefresher(trx) {
    app_logs_1.logger.debug("WebRtc - Twilio token refresher scheduled job is working...");
    const organizations = await dal_manager_1.dbManager.accessOrganization.listOrganizationPg(trx);
    for (const organizationId of organizations) {
        const organizationSettings = await dal_manager_1.dbManager.accessOrganization.getOrganizationSettings({ organizationId, trx });
        if (organizationSettings.webRtc.twilio.accountSid && organizationSettings.webRtc.twilio.authToken && organizationSettings.webRtc.twilio.enabled) {
            const client = (0, twilio_1.default)(organizationSettings.webRtc.twilio.accountSid, organizationSettings.webRtc.twilio.authToken);
            const newToken = await client.tokens.create();
            const iceServers = newToken.iceServers.map((iceServer) => {
                const { url, ...rest } = iceServer;
                return rest;
            });
            await dal_manager_1.dbManager.accessOrganization.setOrganizationSettings({
                organizationId,
                settings: {
                    webRtc: {
                        twilio: organizationSettings.webRtc.twilio,
                        iceServers,
                    },
                },
                trx,
            });
        }
    }
    app_logs_1.logger.debug("WebRtc - Twilio token refresher scheduled job have finished.");
}
exports.webRtcTwilioIceServerRefresher = webRtcTwilioIceServerRefresher;
async function registerVisitorsPreregisteredViaExcel(scheduledJob, trx) {
    app_logs_1.logger.info(`organization [${scheduledJob.organizationId}] scheduledJob [${scheduledJob.id}] Visitor registration scheduled job is started`);
    const visits = await dal_manager_1.dbManager.accessVisitor.listScheduledVisitsByExcel(scheduledJob.organizationId, scheduledJob.id, dal_constants_1.DalConstants.OrganizationVisitorStates.Expected, trx);
    const organizationVisitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(scheduledJob.organizationId);
    const { l: locale } = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: scheduledJob.organizationId, userId: scheduledJob.createdByUserId, trx });
    let failedVisits = [];
    let knexTrx = await dal_manager_1.dbManager.transaction();
    for (let index = 0; index < visits.length; index += 1) {
        try {
            let visit = {
                visitFields: scheduledJob.data.visitFormFields,
                accessControlPointIds: scheduledJob.data.accessControlPointIds,
                processTime: scheduledJob.data.processTime,
                force: scheduledJob.data.force,
                visitorRegistrationPointId: scheduledJob.data.visitorRegistrationPointId,
                visitId: visits[index].id,
                visitorProfileId: visits[index].visitorProfileId,
                credentials: [],
            };
            await business_visitor_1.BusinessVisitor.newVisit(scheduledJob.organizationId, scheduledJob.createdByUserId, visit, organizationVisitorModuleSettings, knexTrx, locale);
        }
        catch (error) {
            failedVisits.push({
                index: index,
                error: i18n_1.default.__({ phrase: error.phrase, locale: locale }),
            });
        }
    }
    knexTrx.commit();
    app_httpserver_1.httpServer.sendVisitorListChangedNotification(scheduledJob.organizationId);
    app_logs_1.logger.info(`organization [${scheduledJob.organizationId}] scheduledJob [${scheduledJob.id}] Visitor registration scheduled job is completed.`);
    const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(scheduledJob.organizationId, app_enums_1.enums.NotificationType.VisitorExcelImportResultNotification, trx);
    const notificationInstanceData = {
        receiverUserIds: [scheduledJob.createdByUserId],
        s: failedVisits.length ? false : true,
        en: scheduledJob.data.eventName,
        sc: visits.length - failedVisits.length,
        t: scheduledJob.createdT.toString(),
        tc: scheduledJob.data.visitCount,
        fc: failedVisits.length,
        fv: failedVisits.map((v) => {
            return {
                vpi: visits[v.index].visitorProfileId,
                r: v.error,
            };
        }),
    };
    const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
        createdT: new Date(),
        notificationId,
        organizationId: scheduledJob.organizationId,
        instanceData: notificationInstanceData,
        trx,
    });
    const notificationEvents = [];
    notificationEvents.push({
        v: "1",
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        a: 0,
        i: notificationEventId,
        o: scheduledJob.organizationId,
        d: notificationInstanceData,
    });
    return notificationEvents;
}
exports.registerVisitorsPreregisteredViaExcel = registerVisitorsPreregisteredViaExcel;
async function terminateVisitsByActivatedViaExcel(scheduledJob, trx) {
    app_logs_1.logger.info(`organization [${scheduledJob.organizationId}] scheduledJob [${scheduledJob.id}] scheduled job for terminating visits registered by excel is started`);
    const visits = await dal_manager_1.dbManager.accessVisitor.listScheduledVisitsByExcel(scheduledJob.organizationId, scheduledJob.id, dal_constants_1.DalConstants.OrganizationVisitorStates.Active, trx);
    const organizationVisitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(scheduledJob.organizationId);
    for (const visit of visits) {
        await dal_manager_1.dbManager.accessVisitor.terminateVisit(scheduledJob.organizationId, visit.id, organizationVisitorModuleSettings, dal_constants_1.DalConstants.SystemUserId);
    }
    app_httpserver_1.httpServer.sendVisitorListChangedNotification(scheduledJob.organizationId);
    app_logs_1.logger.info(`organization [${scheduledJob.organizationId}] scheduledJob [${scheduledJob.id}] scheduled job for terminating visits registered by excel is started`);
}
exports.terminateVisitsByActivatedViaExcel = terminateVisitsByActivatedViaExcel;
async function arventoRegionDataSync(organizationId, trx) {
    try {
        const result = await (0, api_arvento_1.synchronizeArventoAccessLogsRegion)(organizationId, trx);
        if (result) {
            app_logs_1.logger.info(`Arvento Region Data scheduled job completed successfully: Organization ID = ${organizationId}`);
        }
        else {
            app_logs_1.logger.warn(`Arvento Region Data scheduled job returned no data: Organization ID = ${organizationId}`);
        }
    }
    catch (error) {
        app_logs_1.logger.error(`Error in Arvento Region Data scheduled job: Organization ID = ${organizationId}, Error = ${error}`);
    }
}
exports.arventoRegionDataSync = arventoRegionDataSync;
async function arventoAccessLogsSync(organizationId, trx) {
    try {
        const result = await (0, api_arvento_1.synchronizeArventoAccessLogs)(organizationId, trx);
        if (result) {
            app_logs_1.logger.info(`Arvento Access Log scheduled job completed successfully: Organization ID = ${organizationId}`);
        }
        else {
            app_logs_1.logger.warn(`Arvento Access Log scheduled job returned no data: Organization ID = ${organizationId}`);
        }
    }
    catch (error) {
        app_logs_1.logger.error(`Error in Arvento Access Log scheduled job: Organization ID = ${organizationId}, Error = ${error}`);
    }
}
exports.arventoAccessLogsSync = arventoAccessLogsSync;
