"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDailySummaryReport = void 0;
const moment_1 = __importDefault(require("moment"));
const dal_manager_1 = require("../../dal/dal.manager");
const lodash_1 = __importDefault(require("lodash"));
async function getDailySummaryReport(organizationId, filter, requestUserId, hasOrganizationWide, permittedUnitIds) {
    let result = {
        pagination: {
            take: filter.pagination.take || 100,
            skip: filter.pagination.skip || 0,
            total: 0,
        },
        items: [],
        workPlans: [],
    };
    if (!hasOrganizationWide) {
        if (lodash_1.default.isEmpty(filter.organizationUnitIds) && lodash_1.default.isEmpty(filter.userGroupIds) && lodash_1.default.isEmpty(filter.userIds)) {
            if (permittedUnitIds && permittedUnitIds.length > 0) {
                filter.organizationUnitIds = permittedUnitIds;
            }
            else {
                filter.organizationUnitIds = await dal_manager_1.dbManager.accessOrganizationUnit.listOrganizationUnitsOfUser(organizationId, requestUserId);
            }
        }
        let filterUsers = await dal_manager_1.dbManager.accessFunctions.dbFuncCollectUsersForAccessReportFilter({
            organizationId: organizationId,
            userIds: filter.userIds,
            organizationUnitIds: filter.organizationUnitIds,
            userGroupIds: filter.userGroupIds,
            filterOrganizationUnitMembersHierarchically: true,
        });
        filter.userIds = (filterUsers && filterUsers.length) > 0 ? filterUsers.map((f) => f.userId) : [];
    }
    let dbResult = await dal_manager_1.dbManager.accessPacs2.getDailyFirstInLastOutReportForUsers(organizationId, {
        date: new Date(filter.date),
        organizationUnitIds: filter.organizationUnitIds,
        organizationUnitHierarchically: filter.applyOrganizationUnitFilterHierarchically,
        userGroupIds: filter.userGroupIds,
        userIds: filter.userIds,
        workPlanIds: filter.workPlanIds,
        status: filter.status,
        sortingMethod: filter.sortingMethod,
        workStatusFilter: filter.workStatusFilter,
        take: filter.pagination.take,
        skip: filter.pagination.skip,
    });
    result.pagination = dbResult.pagination;
    result.workPlans = dbResult.workPlans;
    result.items = dbResult.items.map((r) => {
        let workPlan = dbResult.workPlans.find((m) => m.id == r.workPlan?.id);
        return {
            user: r.user,
            userCaptions: r.userCaptions,
            entranceDateTime: r.firstIn && r.firstIn.actionUtc ? (0, moment_1.default)(r.firstIn.actionUtc).format() : null,
            entranceAccessLogId: r.firstIn && r.firstIn.accessLogId ? r.firstIn.accessLogId : undefined,
            entrancePenaltyTimeInSeconds: r.entrancePenaltyTimeInSeconds,
            entranceTolerance: r.entranceTolerance,
            exitDateTime: r.lastOut && r.lastOut.actionUtc ? (0, moment_1.default)(r.lastOut.actionUtc).format() : null,
            exitAccessLogId: r.lastOut && r.lastOut.accessLogId ? r.lastOut.accessLogId : undefined,
            exitPenaltyTimeInSeconds: r.exitPenaltyTimeInSeconds,
            exitTolerance: r.exitTolerance,
            firstEntranceAccessControlPointName: null,
            lastExitAccessControlPointName: null,
            ppermissions: r.ppermissions.map((d) => {
                return {
                    endUtc: d.endUtc,
                    ppermissionTypeName: d.ppermissionType,
                    startUtc: d.startUtc,
                    ppermissionTypeId: d.ppermissionTypeId,
                    status: d.status
                };
            }),
            warnings: [],
            extraWorkInMinutes: r.extraWorkInMinutes,
            missingWorkInMinutes: r.missingWorkInMinutes,
            workPlan: {
                id: workPlan ? r.workPlan.id : undefined,
                name: workPlan ? r.workPlan.name : undefined,
                type: workPlan ? r.workPlan.type : undefined,
                startOfWorkUtc: workPlan ? workPlan.startOfWorkUtc : null,
                endOfWorkUtc: workPlan ? workPlan.endOfWorkUtc : null,
            },
            expectedWorkingRanges: r.expectedWorkingRanges,
            holidays: r.holidays,
        };
    });
    return Promise.resolve(result);
}
exports.getDailySummaryReport = getDailySummaryReport;
