"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.errorCodeDescriptionMatcher = exports.NotificationError = void 0;
const app_enums_1 = require("../../../app.enums");
const dal_constants_1 = require("../../../dal/dal.constants");
const i18n_1 = __importDefault(require("i18n"));
class NotificationError extends Error {
    constructor(code, msg) {
        super(msg);
        this._code = code;
    }
    get code() {
        return this._code;
    }
}
exports.NotificationError = NotificationError;
const errorCodeDescriptionMatcher = (errorCode) => {
    const locale = "tr";
    switch (errorCode) {
        case app_enums_1.enums.ErrorCode.InCorrectMembershipInfoOrMessageContainsNonEnglishCharacterInSms:
            return i18n_1.default.__({ phrase: "ERRORS.INCORRECT_MEMBERSHIP_INFO_OR_MESSAGE_CONTAINS_NONENGLISH_CHARACTER_IN_SMS", locale });
        case app_enums_1.enums.ErrorCode.SameSmsTriedToSendAgain:
            return i18n_1.default.__({ phrase: "ERRORS.SAME_SMS_TRIED_TO_SEND_AGAIN", locale });
        case app_enums_1.enums.ErrorCode.InsufficientSmsBalance:
            return i18n_1.default.__({ phrase: "ERRORS.INSUFFICIENT_SMS_BALANCE", locale });
        case app_enums_1.enums.ErrorCode.InvalidReceiverOnSms:
            return i18n_1.default.__({ phrase: "ERRORS.INVALID_RECEIVER", locale });
        case app_enums_1.enums.ErrorCode.EmptyText:
            return i18n_1.default.__({ phrase: "ERRORS.EMPTY_TEXT", locale });
        case app_enums_1.enums.ErrorCode.MessageSizeExceeded:
            return i18n_1.default.__({ phrase: "ERRORS.MESSAGE_SIZE_EXCEEDED", locale });
        case app_enums_1.enums.ErrorCode.SmsServerTemporaryInAvailable:
            return i18n_1.default.__({ phrase: "ERRORS.SMS_SERVER_TEMPORARY_INAVAILABLE", locale });
        case app_enums_1.enums.ErrorCode.ConnectionError:
            return i18n_1.default.__({ phrase: "ERRORS.CONNECTION_ERROR", locale });
        case app_enums_1.enums.ErrorCode.InvalidReceiver:
            return i18n_1.default.__({ phrase: "ERRORS.INVALID_RECEIVER", locale });
        case app_enums_1.enums.ErrorCode.MissingReceiver:
            return i18n_1.default.__({ phrase: "ERRORS.MISSING_RECEIVER", locale });
        case app_enums_1.enums.ErrorCode.InvalidMediumToSend:
            return i18n_1.default.__({ phrase: "ERRORS.INVALID_MEDIUM_TO_SEND", locale });
        case app_enums_1.enums.ErrorCode.Unknown:
            return i18n_1.default.__({ phrase: "ERRORS.UNKNOWN", locale });
        case dal_constants_1.DalConstants.NotificationErrorCode.DataNotFoundInMediumSmsTable:
            return i18n_1.default.__({ phrase: "ERRORS.DATANOTFOUNDINTABLE", locale });
        case dal_constants_1.DalConstants.NotificationErrorCode.DataNotFoundInMediumSmtpTable:
            return i18n_1.default.__({ phrase: "ERRORS.DATANOTFOUNDINTABLE", locale });
        case dal_constants_1.DalConstants.NotificationErrorCode.DataNotFoundInNotificationTable:
            return i18n_1.default.__({ phrase: "ERRORS.DATANOTFOUNDINTABLE", locale });
        case dal_constants_1.DalConstants.NotificationErrorCode.DataNotFoundInQueueTable:
            return i18n_1.default.__({ phrase: "ERRORS.DATANOTFOUNDINTABLE", locale });
        case dal_constants_1.DalConstants.NotificationErrorCode.DataNotFoundInTemplatesTable:
            return i18n_1.default.__({ phrase: "ERRORS.DATANOTFOUNDINTABLE", locale });
        case dal_constants_1.DalConstants.NotificationCancelReason.MaxAttemptCountReached:
            return i18n_1.default.__({ phrase: "ERRORS.MAX_ATTEMPT_COUNT_RECEIVED", locale });
        default:
            return i18n_1.default.__({ phrase: "ERRORS.UNKNOWN", locale });
    }
};
exports.errorCodeDescriptionMatcher = errorCodeDescriptionMatcher;
