"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.firebasePush = exports.initializeFirebase = exports.firebaseMessagingErrorCodes = void 0;
const firebase_admin_1 = __importDefault(require("firebase-admin"));
const app_config_1 = require("../../app.config");
const app_logs_1 = require("../../app.logs");
exports.firebaseMessagingErrorCodes = {
    MissingRecevier: "messaging/registration-token-not-registered",
    InvalidReceiver: "messaging/invalid-registration-token",
    ServerUnavailable: "messaging/server-unavailable",
};
const firebaseConfig = {
    projectId: app_config_1.appConfig.firebaseProjectId || "",
    clientEmail: app_config_1.appConfig.firebaseClientEmail || "",
    privateKey: app_config_1.appConfig.firebasePrivateKey?.replace(/\\n/g, "\n") || "",
};
const initializeFirebase = () => {
    if (!firebase_admin_1.default.apps.length) {
        try {
            firebase_admin_1.default.initializeApp({
                credential: firebase_admin_1.default.credential.cert({
                    projectId: firebaseConfig.projectId,
                    clientEmail: firebaseConfig.clientEmail,
                    privateKey: firebaseConfig.privateKey.replace(/\\n/g, "\n"),
                }),
            });
            app_logs_1.logger.info("Firebase app initialized successfully.");
        }
        catch (error) {
            app_logs_1.logger.error("Error initializing Firebase app:", { error: error.message });
        }
    }
    else {
        app_logs_1.logger.info("Firebase app has already been initialized.");
    }
};
exports.initializeFirebase = initializeFirebase;
const firebasePush = async (pushNotificationData) => {
    if (!firebase_admin_1.default.apps.length) {
        (0, exports.initializeFirebase)();
    }
    const message = {
        notification: {
            title: pushNotificationData.notification.title,
            body: pushNotificationData.notification.body,
        },
        data: pushNotificationData.data,
        token: pushNotificationData.notificationToken,
    };
    try {
        const response = await firebase_admin_1.default.messaging().send(message);
        app_logs_1.logger.info("Successfully sent Firebase push notification:", response);
    }
    catch (error) {
        app_logs_1.logger.error("Error sending Firebase push notification:", error);
        throw {
            code: error.code,
            message: error.message,
        };
    }
};
exports.firebasePush = firebasePush;
