"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultTemplates = void 0;
const app_enums_1 = require("../app.enums");
var DefaultTemplates;
(function (DefaultTemplates) {
    function getDefaultVisitorTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: {
                        showLogo: false,
                        showRegistrationPoint: true,
                        showVisitUtc: true,
                        visitFields: [],
                        visitorFields: ["name"]
                    },
                    subjectTemplate: "Ziyaretçiniz var",
                    organizationId: "",
                    bodyTemplate: `<div>
                       <p>Sayın {{user}}</p>
                      </div>
          <p>
          <div class="intro">
            <p>Aşağıda bilgileri verilen ziyaretçiniz gelmiştir</p>
          </div>
          <div>
                <table  border="0" cellpadding="0" cellspacing="0" style="border-collapse:collapse;width:50%" >
              <tbody> 
                  {{#visitorInfo}} 
                  <tr> 
                      <td>{{caption}}</td> 
                      <td>{{value}}</td> 
                  
                  </tr> 
                  {{/visitorInfo}} 
              </tbody> 
          </table>
          </div>
          `,
                    type: app_enums_1.enums.EmailTemplateType.Visitor
                };
            case 'en': return {
                id: "",
                configuration: {
                    showLogo: false,
                    showRegistrationPoint: true,
                    showVisitUtc: true,
                    visitFields: [],
                    visitorFields: ["name"]
                },
                subjectTemplate: "You have visitor",
                organizationId: "",
                bodyTemplate: `<div>
                   <p>Dear {{user}}</p>
                  </div>
                <p>
                 <div class="intro">
                    <p>Your visitor has arrived</p>
                 </div>
                <div>
                <table  border="0" cellpadding="0" cellspacing="0" style="border-collapse:collapse;width:50%" >
                <tbody> 
                    {{#visitorInfo}} 
                <tr> 
                  <td>{{caption}}: </td> 
                  <td>{{value}}</td>               
                </tr> 
                {{/visitorInfo}} 
                </tbody> 
                </table></div>                `,
                type: app_enums_1.enums.EmailTemplateType.Visitor
            };
        }
        return null;
    }
    DefaultTemplates.getDefaultVisitorTemplate = getDefaultVisitorTemplate;
    let feedbackCss = `
    <head>
    <style type="text/css">
       
        table {
            margin: 10px;
            border-collapse: separate;
            border-spacing: 0px;
            width: 75%;
        }
        th,
        td {
            padding: 2px;
            border: 1px solid #ddd;
            font-size: 96%;
        }
        th {
            background: #ccc;
        }
        .caption {
            width:25%;
            background-color:#f2f2f2;
        }
        tr:nth-child(odd) {
            background: #f2f2f2;            
        }
    </style>
    </head>
    `;
    function getDefultFeedbackTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
                   
                    <body>
                    <div>
                       <p>Sayın {{user}},</p>
                      </div>
                    <p>
                 <div class="intro">
                    <p>Sisteme yeni geri bildirim eklenmiştir.</p>
                </div>
                <div>
                <table >
                <tbody> 
                  {{#feedbackInfo}} 
                  <tr> 
                      <td class="caption">{{caption}}</td> 
                      <td>{{value}}</td> 
                  
                  </tr> 
                  {{/feedbackInfo}} 
                </tbody> 
                </table>
                </div>
                </body>
                `,
                    type: app_enums_1.enums.EmailTemplateType.Feedback
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
                   
                <body>
                <div>
                   <p>Dear {{user}},</p>
                  </div>
                <p>
                 <div class="intro">
                    <p>New feedback has arrived.</p>
                 </div>
                <div>
                <table  border="0" cellpadding="0" cellspacing="0" style="border-collapse:collapse">
                <tbody> 
                    {{#feedbackInfo}} 
                <tr> 
                <td class="caption">{{caption}}</td> 
                  <td>{{value}}</td>               
                </tr> 
                {{/feedbackInfo}} 
                </tbody> 
                </table></div>            
                </body>    `,
                type: app_enums_1.enums.EmailTemplateType.Feedback
            };
        }
        return null;
    }
    DefaultTemplates.getDefultFeedbackTemplate = getDefultFeedbackTemplate;
    function getDefultFeedbackUpdateTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
                   
                    <body>
                    <div>
                       <p>Sayın {{user}},</p>
                      </div>
                    <p>
                 <div class="intro">
                    <p>Yapmış olduğunuz geri bildirim için güncelleme yapılmıştır.</p>
                </div>
                <div>
                <table >
                <tbody> 
                  {{#feedbackInfo}} 
                  <tr> 
                      <td class="caption">{{caption}}</td> 
                      <td>{{value}}</td> 
                  
                  </tr> 
                  {{/feedbackInfo}} 
                </tbody> 
                </table>
                </div>
                </body>
                `,
                    type: app_enums_1.enums.EmailTemplateType.FeedbackUpdate
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
                   
                <body>
                <div>
                   <p>Dear {{user}},</p>
                  </div>
                <p>
                 <div class="intro">
                    <p>Your feedback is updated.</p>
                 </div>
                <div>
                <table  border="0" cellpadding="0" cellspacing="0" style="border-collapse:collapse">
                <tbody> 
                    {{#feedbackInfo}} 
                <tr> 
                <td class="caption">{{caption}}</td> 
                  <td>{{value}}</td>               
                </tr> 
                {{/feedbackInfo}} 
                </tbody> 
                </table></div>            
                </body>    `,
                type: app_enums_1.enums.EmailTemplateType.FeedbackUpdate
            };
        }
        return null;
    }
    DefaultTemplates.getDefultFeedbackUpdateTemplate = getDefultFeedbackUpdateTemplate;
    function getDefultSelfMissingWorkTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
                   
                    <body>
                    <div>
                       <p>Sayın {{user}},</p>
                      </div>
                    <p>
                 <div class="intro">
                    <p>{{startDate}} - {{endDate}} tarihleri arasında {{missingWorkDuration}} Dk. eksik mesainiz var.</p>
                </div>                
                </body>
                `,
                    type: app_enums_1.enums.EmailTemplateType.SelfMissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
                   
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>Between {{startDate}} - {{endDate}}  you have  {{missingWorkDuration}} minutes missing work duration.</p>
            </div>                
            </body> `,
                type: app_enums_1.enums.EmailTemplateType.SelfMissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultSelfMissingWorkTemplate = getDefultSelfMissingWorkTemplate;
    function getDefultMissingWorkTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
                   
                    <body>
                    <div>
                       <p>Sayın {{user}},</p>
                      </div>
                    <p>
                 <div class="intro">
                    <p>{{startDate}} - {{endDate}} tarihleri arasında, "{{targetUser}}"'ın {{missingWorkDuration}} Dk. eksik mesaisi var.</p>
                </div>                
                </body>
                `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
                   
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>Between {{startDate}} - {{endDate}}  {{targetUser}} have  {{missingWorkDuration}} minutes missing work duration.</p>
            </div>                
            </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultMissingWorkTemplate = getDefultMissingWorkTemplate;
    function getDefultSelfEarlyLeaveTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında {{earlyleaveduration}} dk. erken çıkış yaptınız.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.SelfMissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  you have  {{earlyleaveduration}} minutes early left.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.SelfMissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultSelfEarlyLeaveTemplate = getDefultSelfEarlyLeaveTemplate;
    function getDefultEarlyLeaveTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, "{{targetUser}}" {{earlyleaveduration}} dk. erken çıkış yaptı.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  {{targetUser}} have  {{earlyleaveduration}} minutes early left.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultEarlyLeaveTemplate = getDefultEarlyLeaveTemplate;
    function getDefultSelfLateEntranceTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında {{lateentranceduration}} dk. geç geldiniz.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.SelfMissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  you have  {{lateentranceduration}} minutes late for work.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.SelfMissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultSelfLateEntranceTemplate = getDefultSelfLateEntranceTemplate;
    function getDefultLateEntranceTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, "{{targetUser}}" {{lateentranceduration}} Dk. geç geldi.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  {{targetUser}} have  {{lateentranceduration}} minutes late for work.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultLateEntranceTemplate = getDefultLateEntranceTemplate;
    function getDefultSelfEarlyEntranceTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, {{earlyentranceduration}} Dk. erken geldiniz.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Dear {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}} you came to work {{earlyentranceduration}} minutes early.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultSelfEarlyEntranceTemplate = getDefultSelfEarlyEntranceTemplate;
    function getDefultEarlyEntranceTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, "{{targetUser}}" {{earlyentranceduration}} Dk. erken geldi.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  {{targetUser}} came to work {{earlyentranceduration}} minutes early.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultEarlyEntranceTemplate = getDefultEarlyEntranceTemplate;
    function getDefultLateLeaveTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, "{{targetUser}}" {{lateentranceduration}} Dk. geç çıktı.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  {{targetUser}} has {{lateentranceduration}} minutes late leave for work.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultLateLeaveTemplate = getDefultLateLeaveTemplate;
    function getDefultSelfLateLeaveTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, {{lateentranceduration}} Dk. geç çıktınız.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}} you have {{lateentranceduration}} minutes late leave for work.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultSelfLateLeaveTemplate = getDefultSelfLateLeaveTemplate;
    function getDefultOutOfWorkplanAccessTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, "{{targetUser}}" Mesai saatleri dışında erişim yaptı.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  {{targetUser}} accessed outside working hours.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultOutOfWorkplanAccessTemplate = getDefultOutOfWorkplanAccessTemplate;
    function getDefultSelfOutOfWorkplanAccessTemplate(locale) {
        switch (locale) {
            case 'tr':
                return {
                    id: "",
                    configuration: null,
                    subjectTemplate: "",
                    organizationId: "",
                    bodyTemplate: feedbackCss + `
               
                <body>
                <div>
                   <p>Sayın {{user}},</p>
                  </div>
                <p>
             <div class="intro">
                <p>{{startDate}} - {{endDate}} tarihleri arasında, Mesai saatleri dışında erişim yaptınız.</p>
            </div>                
            </body>
            `,
                    type: app_enums_1.enums.EmailTemplateType.MissingWork
                };
            case 'en': return {
                id: "",
                configuration: null,
                subjectTemplate: "",
                organizationId: "",
                bodyTemplate: feedbackCss + `
               
            <body>
            <div>
               <p>Sayın {{user}},</p>
              </div>
            <p>
         <div class="intro">
            <p>Between {{startDate}} - {{endDate}}  you have accessed outside working hours.</p>
        </div>                
        </body> `,
                type: app_enums_1.enums.EmailTemplateType.MissingWork
            };
        }
        return null;
    }
    DefaultTemplates.getDefultSelfOutOfWorkplanAccessTemplate = getDefultSelfOutOfWorkplanAccessTemplate;
})(DefaultTemplates = exports.DefaultTemplates || (exports.DefaultTemplates = {}));
