"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendAssaAbloyBatteryStatusChangedNotification = exports.sendAccountCreatedNotification = exports.sendOrganizationModuleLicenseLimitReachedNotification = exports.sendDeviceNotInformedNotification = exports.handleTerminalEmergencyNotifications = exports.handDoorOpenedByForceNotifications = exports.handleTerminalConnectionNotifications = exports.handleSMSBalanceNotifications = exports.handleRegionEmergencyNotifications = exports.sendReportErrorNotification = exports.sendReportNotification = void 0;
const app_constants_1 = require("../app.constants");
const app_enums_1 = require("../app.enums");
const app_httpserver_1 = require("../app.httpserver");
const dal_memcache_1 = require("../dal/access/dal.memcache");
const dal_manager_1 = require("../dal/dal.manager");
const dal_db_armon_schema_1 = require("../dal/db/armon/dal.db.armon.schema");
const predefined_roles_1 = require("../dal/db/predefined/predefined.roles");
const restapi_1 = require("../lib/es/models/restapi");
const messageBroker_notification_pub_1 = require("../messageBroker/messageBroker.notification.pub");
async function sendReportNotification(params) {
    const notificationEvent = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        let notificationEvent;
        let notificationId;
        await dal_manager_1.dbManager.accessReport.insertPreparedReport({
            trx,
            organizationId: params.organizationId,
            expirationDt: new Date(new Date().getTime() + app_constants_1.reportExpireTime),
            reportId: params.reportResponse.preparedReportId,
            format: params.request.format,
            userFilterId: params.receiverUserFilterId,
        });
        if (params.reportResponse.notificationType === app_enums_1.enums.NotificationType.ScheduledReport) {
            notificationId = params.notificationId;
            const instanceData = {
                t: params.reportResponse.reportType,
                a: params.reportResponse.sendFileInAttachments,
                c: params.reportResponse.customReportName ?? undefined,
                i: params.reportResponse.preparedReportId,
                r: !params.request.sendWhenEmpty && params.reportResponse.reportContainsEmptyData ? restapi_1.ReportServiceResult.NotGeneratedBecauseOfEmptyReport : restapi_1.ReportServiceResult.Success,
            };
            const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
                createdT: new Date(),
                notificationId,
                organizationId: params.organizationId,
                receiverFilterId: params.receiverUserFilterId,
                trx,
                instanceData,
            });
            notificationEvent = {
                v: "1",
                n: 1,
                a: 0,
                i: notificationEventId,
                o: params.organizationId,
                d: instanceData,
            };
            return notificationEvent;
        }
        else {
            const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, app_enums_1.enums.NotificationType.HugeReport, trx);
            const instanceData = {
                t: params.reportResponse.reportType,
                a: params.reportResponse.sendFileInAttachments,
                c: params.reportResponse.customReportName ?? undefined,
                i: params.reportResponse.preparedReportId,
                r: restapi_1.ReportServiceResult.Success,
                receiverUserIds: params.receiverUserIds,
            };
            const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
                createdT: new Date(),
                notificationId,
                organizationId: params.request.organizationId,
                trx,
                instanceData,
            });
            notificationEvent = {
                v: "1",
                n: 1,
                a: 0,
                i: notificationEventId,
                o: params.organizationId,
                d: instanceData,
            };
            return notificationEvent;
        }
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)(notificationEvent);
}
exports.sendReportNotification = sendReportNotification;
async function sendReportErrorNotification(params) {
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, app_enums_1.enums.NotificationType.ReportServiceError, trx);
        const instanceData = {
            t: params.reportResponse?.reportType,
            r: restapi_1.ReportServiceResult.UnhandledException,
            receiverUserIds: params.receiverUserIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: params.organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        v: "1",
        n: 1,
        a: 0,
        i: eventId,
        o: params.organizationId,
        d: instanceData,
    });
}
exports.sendReportErrorNotification = sendReportErrorNotification;
async function handleRegionEmergencyNotifications(params) {
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const receiverUserIds = await dal_manager_1.dbManager.accessUser.getUserIdOfUsersWhoInRegionDuringTheEmergency({
            organizationId: params.organizationId,
            regionId: params.regionId,
        });
        const regionEmergencyNotificationType = params.state === app_enums_1.enums.EmergencyState.Emergency ? app_enums_1.enums.NotificationType.RegionEmergencyStart : app_enums_1.enums.NotificationType.RegionEmergencyStopped;
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, regionEmergencyNotificationType, trx);
        await app_httpserver_1.httpServer.sendRegionEmergencyNotification({
            ...params,
            receiverUserIds,
        });
        const instanceData = {
            receiverUserIds,
            r: params.regionId,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: params.organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: params.organizationId,
        v: "1",
        d: instanceData,
    });
}
exports.handleRegionEmergencyNotifications = handleRegionEmergencyNotifications;
async function handleSMSBalanceNotifications(params) {
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const receiverUserIds = await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(params.organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id);
        const notificationType = restapi_1.NotificationType.SMSBalance;
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, notificationType, trx);
        const instanceData = {
            t: params.threshold,
            receiverUserIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: params.organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: params.organizationId,
        v: "1",
        d: instanceData,
    });
}
exports.handleSMSBalanceNotifications = handleSMSBalanceNotifications;
async function handleTerminalConnectionNotifications(params) {
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const systemAdmins = [];
        const terminalAdministrators = await dal_manager_1.dbManager.accessDevice.getTerminalAdministrators(params.organizationId, params.terminalId);
        const notifableTerminalAdmins = terminalAdministrators.items.filter((admin) => admin.userRights.notify).map((admin) => admin.userId);
        if (terminalAdministrators.items.length === 0) {
            systemAdmins.push(...(await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(params.organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id)));
        }
        const receiverUserIds = [...new Set([...notifableTerminalAdmins, ...systemAdmins])];
        const notificationType = params.isConnected ? restapi_1.NotificationType.TerminalConnected : restapi_1.NotificationType.TerminalDisconnected;
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, notificationType, trx);
        const instanceData = {
            t: params.terminalId,
            receiverUserIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: params.organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: params.organizationId,
        v: "1",
        d: instanceData,
    });
}
exports.handleTerminalConnectionNotifications = handleTerminalConnectionNotifications;
async function handDoorOpenedByForceNotifications(params) {
    const systemAdminIds = [];
    const terminalAdministrators = await dal_manager_1.dbManager.accessDevice.getTerminalAdministrators(params.organizationId, params.terminalId);
    const notifableTerminalAdminIds = terminalAdministrators.items.filter((admin) => admin.userRights.notify).map((admin) => admin.userId);
    if (terminalAdministrators.items.length === 0) {
        systemAdminIds.push(...(await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(params.organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id)));
    }
    const receiverUserIds = [...new Set([...notifableTerminalAdminIds, ...systemAdminIds])];
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, restapi_1.NotificationType.DoorOpenedByForce, trx);
        const instanceData = {
            l: params.logId,
            a: params.accessPointId,
            t: params.dateTime,
            r: params.reason,
            receiverUserIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: params.organizationId,
            instanceData,
            trx,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: params.organizationId,
        v: "1",
        d: instanceData,
    });
}
exports.handDoorOpenedByForceNotifications = handDoorOpenedByForceNotifications;
async function handleTerminalEmergencyNotifications(params) {
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const systemAdmins = [];
        const terminalAdministrators = await dal_manager_1.dbManager.accessDevice.getTerminalAdministrators(params.organizationId, params.terminalId);
        const terminalAdminIds = terminalAdministrators.items.filter((admin) => admin.userRights.notify).map((admin) => admin.userId);
        if (terminalAdminIds.length === 0) {
            systemAdmins.push(...(await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(params.organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id)));
        }
        const receiverUserIds = [...new Set([...terminalAdminIds, ...systemAdmins])];
        await app_httpserver_1.httpServer.sendTerminalEmergencyNotification({
            organizationId: params.organizationId,
            deviceId: params.terminalId,
            deviceName: params.terminalName,
            state: params.state,
            receiverUserIds,
        });
        const terminalEmergencyNotificationType = params.state === app_enums_1.enums.EmergencyState.Emergency ? app_enums_1.enums.NotificationType.TerminalEmergencyStarted : app_enums_1.enums.NotificationType.TerminalEmergencyStopped;
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(params.organizationId, terminalEmergencyNotificationType, trx);
        const instanceData = {
            t: params.terminalId,
            rn: params.regionName,
            receiverUserIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: params.organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: params.organizationId,
        v: "1",
        d: instanceData,
    });
}
exports.handleTerminalEmergencyNotifications = handleTerminalEmergencyNotifications;
const sendDeviceNotInformedNotification = async (params) => {
    const { organizationId, receiverUserId } = params;
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.DeviceWasNotInformed, trx);
        const instanceData = {
            t: params.offlineTerminals,
            receiverUserIds: [receiverUserId],
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            instanceData,
            trx,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: organizationId,
        v: "1",
        d: instanceData,
    });
};
exports.sendDeviceNotInformedNotification = sendDeviceNotInformedNotification;
const sendOrganizationModuleLicenseLimitReachedNotification = async (params) => {
    const { organizationId, applicationModule } = params;
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.LicenseLimitReached, trx);
        const sysAdminIds = await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(params.organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id);
        const instanceData = {
            t: applicationModule,
            receiverUserIds: sysAdminIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: organizationId,
        v: "1",
        d: instanceData,
    });
};
exports.sendOrganizationModuleLicenseLimitReachedNotification = sendOrganizationModuleLicenseLimitReachedNotification;
const sendAccountCreatedNotification = async (organizationId, params) => {
    const { username, password, accountOwnerUserId } = params;
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.AccountCreated, trx);
        const instanceData = {
            u: username,
            p: password,
            receiverUserIds: [accountOwnerUserId],
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            instanceData,
            trx,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: organizationId,
        v: "1",
        d: instanceData,
    });
};
exports.sendAccountCreatedNotification = sendAccountCreatedNotification;
const sendAssaAbloyBatteryStatusChangedNotification = async (organizationId, params) => {
    const systemAdmins = [];
    const terminalAdminIds = [];
    if (params.hubDeviceId) {
        const terminalAdministrators = await dal_manager_1.dbManager.accessDevice.getTerminalAdministrators(organizationId, params.hubDeviceId);
        terminalAdminIds.push(...terminalAdministrators.items.filter((admin) => admin.userRights.notify).map((admin) => admin.userId));
    }
    if (terminalAdminIds.length === 0) {
        systemAdmins.push(...(await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id)));
    }
    const receiverUserIds = [...new Set([...terminalAdminIds, ...systemAdmins])];
    const { eventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const { rows: notificationInstanceDataRows, rowCount: notificationInstanceDataRowCount } = await trx.query(`
				SELECT d.id AS "deviceId", acp.id AS "accessControlPointId", acp.name AS "accessControlPointName"
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" AS d
				INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays}" AS dr
					ON dr."deviceId" = d.id AND dr."deletedAt" IS NULL
				LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp
					ON acp."id" = dr."accessControlPointId" AND acp."deletedAt" IS NULL 
				WHERE d.id = $1 AND d."deletedAt" IS NULL
				GROUP BY d.id, d."location", acp.id, acp.name 
			`, [params.lockDeviceId]);
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.AssaAbloyDeviceBatteryStatusChanged, trx);
        const instanceData = {
            di: params.lockDeviceId,
            dn: params.deviceName,
            s: params.state,
            a: notificationInstanceDataRowCount ? notificationInstanceDataRows[0].accessControlPointId : null,
            an: notificationInstanceDataRowCount ? notificationInstanceDataRows[0].accessControlPointName : null,
            t: params.timestamp,
            receiverUserIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId: organizationId,
            instanceData,
            trx,
        });
        return { eventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: organizationId,
        v: "1",
        d: instanceData,
    });
};
exports.sendAssaAbloyBatteryStatusChangedNotification = sendAssaAbloyBatteryStatusChangedNotification;
