"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCommon = exports.secondsInDay = void 0;
const moment_1 = __importDefault(require("moment"));
const app_enums_1 = require("../app.enums");
const ajv_1 = __importDefault(require("ajv"));
const dal_manager_1 = require("../dal/dal.manager");
let dayNamesInTurkish = {};
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Sunday] = "Pazar";
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Saturday] = "Cumartesi";
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Friday] = "Cuma";
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Thursday] = "Perşembe";
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Wednesday] = "Çarşamba";
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Tuesday] = "Salı";
dayNamesInTurkish[app_enums_1.enums.DayOfWeek.Monday] = "Pazartesi";
dayNamesInTurkish[app_enums_1.enums.DayOfWeekForWorking.Sunday] = "Pazar";
exports.secondsInDay = 86400;
class BusinessCommon {
    static GetWeekDayName(weekday) {
        return dayNamesInTurkish[weekday];
    }
    static regexIndexOf(str, regex, startpos) {
        var indexOf = str.substring(startpos || 0).search(regex);
        return indexOf >= 0 ? indexOf + (startpos || 0) : indexOf;
    }
    static convertStringArrayToBoolean(input) {
        if (!input || input === "" || input.length < 5) {
            return [];
        }
        let result = [];
        let tokens = input.replace(/[&\/\\#+()$~%.'":*?<>{}]/g, "").split(",");
        for (let token of tokens) {
            result.push(token.toLowerCase() === "true");
        }
        return result;
    }
    static convertTimeToMoment(date, timeString) {
        return (0, moment_1.default)(date)
            .hour(Number.parseInt(timeString.split(":")[0]))
            .minute(Number.parseInt(timeString.split(":")[1]))
            .utc();
    }
    static mustBeZeroOrPositive(val) {
        return val > 0 ? val : 0;
    }
    static roundHalf(num) {
        return Math.round(num * 2) / 2;
    }
    static async validateDynamicForm(args) {
        const ajv = new ajv_1.default({ allErrors: true });
        require("ajv-errors")(ajv);
        let errors;
        if (args.dynamicFormId && args.dynamicFormData) {
            const form = await dal_manager_1.dbManager.accessSystem.getDynamicForm({ organizationId: args.organizationId, dynamicFormId: args.dynamicFormId });
            const schema = form.dataSchema;
            const validate = ajv.compile(schema);
            const valid = validate(args.dynamicFormData);
            if (!valid) {
                errors = validate.errors;
            }
        }
        return errors;
    }
}
exports.BusinessCommon = BusinessCommon;
