"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendArventoRequest = exports.ArventoServiceType = void 0;
const axios_1 = __importDefault(require("axios"));
const restapi_1 = require("../../lib/es/models/restapi");
const access_token_1 = require("./access.token");
const app_logs_1 = require("../../app.logs");
const ACCESS_REQUEST_DEFAULT_TIMEOUT_VALUE = 5000;
var ArventoServiceType;
(function (ArventoServiceType) {
    ArventoServiceType["Login"] = "login";
    ArventoServiceType["Report"] = "report";
    ArventoServiceType["DriverQr"] = "driver-qr-scan";
    ArventoServiceType["DeleteDriver"] = "delete-driver";
    ArventoServiceType["Region"] = "region";
})(ArventoServiceType = exports.ArventoServiceType || (exports.ArventoServiceType = {}));
async function sendArventoRequest(options) {
    const headers = {
        ...(options.headers || {}),
    };
    if (options.proxyConfig?.type === restapi_1.ArventoProxyType.Enerjisa) {
        if (options.serviceType === ArventoServiceType.DriverQr && headers["X-API-KEY"]) {
            headers["X_API_KEY"] = headers["X-API-KEY"];
            delete headers["X-API-KEY"];
        }
        if (options.serviceType === ArventoServiceType.Report && headers["Authorization"]) {
            headers["session_id"] = headers["Authorization"];
            delete headers["Authorization"];
        }
        const token = await (0, access_token_1.getAccessToken)(options.proxyConfig);
        if (token) {
            headers["Authorization"] = token;
        }
    }
    try {
        const response = await (0, axios_1.default)({
            method: options.method,
            url: options.url,
            headers,
            data: options.data,
            timeout: options.timeout ?? ACCESS_REQUEST_DEFAULT_TIMEOUT_VALUE,
        });
        return response;
    }
    catch (error) {
        app_logs_1.logger.error(`[Arvento] Request failed: ${error}`);
        throw error;
    }
}
exports.sendArventoRequest = sendArventoRequest;
