"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAccessToken = void 0;
const restapi_1 = require("../../lib/es/models/restapi");
const dal_manager_1 = require("../../dal/dal.manager");
const axios_1 = __importDefault(require("axios"));
const app_logs_1 = require("../../app.logs");
const ACCESS_TOKEN_DEFAULT_EXPIRE_VALUE = 3600;
async function getAccessToken(proxyConfig) {
    switch (proxyConfig.type) {
        case restapi_1.ArventoProxyType.Enerjisa:
            return await getEnerjisaToken(proxyConfig);
        default:
            app_logs_1.logger.error(`Unknown proxy type: ${proxyConfig.type}`);
            return null;
    }
}
exports.getAccessToken = getAccessToken;
async function getEnerjisaToken(config) {
    let accessToken = await dal_manager_1.dbManager.accessRedisCache.getValue(config.clientId);
    if (!accessToken) {
        const { host, clientId, clientSecret, grantType, scope } = config;
        try {
            const params = new URLSearchParams();
            params.append("grant_type", grantType);
            params.append("scope", scope);
            const response = await axios_1.default.post(host, params, {
                auth: {
                    username: clientId,
                    password: clientSecret,
                },
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                },
            });
            const tokenResponse = response.data;
            const accessTokenValue = "Bearer " + tokenResponse.access_token;
            const secondsToExpire = tokenResponse.expires_in ?? ACCESS_TOKEN_DEFAULT_EXPIRE_VALUE;
            await dal_manager_1.dbManager.accessRedisCache.setExpireValue(config.clientId, accessTokenValue, secondsToExpire);
            accessToken = accessTokenValue;
        }
        catch (error) {
            app_logs_1.logger.error(`Error while getting Enerjisa token: ${error}`);
            return null;
        }
    }
    return accessToken;
}
