"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstPermissions = void 0;
exports.ConstPermissions = {
    identity: {
        name: "identity",
        code: "i",
        description: "",
        getFull: function () { return 'i:*'; },
        getReadDetailed: function () { return 'i:r,b'; },
        getWrite: function () { return 'i:w'; },
        getReadBasic: function () { return 'i:b'; }
    },
    report: {
        name: "report",
        code: "r",
        description: "",
        getFull: function () { return 'r:*'; },
        getAccessReport: function () { return 'r:a'; },
    },
    topology: {
        name: "topology",
        code: "t",
        description: "",
        getFull: function () { return 't:*'; },
        getRead: function () { return 't:r'; },
        getWrite: function () { return 't:w'; }
    },
    unit: {
        name: "unit",
        code: "u",
        description: "",
        getFull: function () { return 'u:*'; },
        getRead: function () { return 'u:r'; },
        getWrite: function () { return 'u:w'; }
    },
    dashboard: {
        name: "dashboard",
        code: "d",
        description: "",
        getFull: function () { return 'd:*'; },
        getViewCards: function () { return 'd:v'; }
    },
    remoteaccess: {
        name: "remoteaccess",
        code: "a",
        description: "",
        getGrant: function () { return 'a:r'; }
    },
    getForItem: function (permission, itemId) {
        return permission + ":" + itemId;
    },
    getForItems: function (permission, itemIds) {
        return permission + ":" + itemIds.join(",");
    }
};
