"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sleepForMs = exports.sendHttpsGetRequest = exports.sendHttpsPostRequest = exports.isPhoneNumberFromTurkey = exports.appwebEmergencyCodeToDeviceEmergencyCode = exports.deviceEmergencyCodeToAppwebEmergencyCode = exports.convertToEnglishCharString = exports.isTypedEnum = exports.validateEnum = exports.mkDirSyncRecursively = exports.undefinedToNull = exports.renderHtml = exports.json2HtmlTable = exports.getFirstMondayMidnightTimeAfter = exports.areLocalDatesEqual = exports.getUTCDayOfWeekForWorkingFromDate = exports.utcTimeToLocalTimeIndexFormat = exports.utcDateTimeToLocalTimeIndexFormat = exports.localDateTimeExToLocalTimeIndexFormat = exports.localDateTimeToLocalTimeIndexFormat = exports.localDateToLocalTimeIndexFormat = exports.localDateTimeToEpochTimeInMs = exports.dateToEpochTimeInSecs = exports.localDateToEpochTimeInSecs = exports.localDateToUtcDate = exports.localDateToUtcTime = exports.compareLocalDates = exports.timezoneStringToMs = exports.timezoneOffsetToString = exports.getISOStringOfNow = exports.areUtcDateTimesInSameDate = exports.MILLISECONDS_IN_A_WEEK = exports.MILLISECONDS_IN_A_DAY = exports.MILLISECONDS_IN_A_HOUR = exports.MILLISECONDS_IN_A_MINUTE = exports.SECONDS_IN_A_DAY = exports.MINUTES_IN_A_DAY = exports.getUtcStartOfDay = exports.saltHashPassword = exports.hashPasswordWithSalt = exports.genRandomString = exports.uint8ArrayToHexEncoding = exports.hexEncodingToUint8Array = exports.stringFormat = exports.CommonConstants = exports.flatten = void 0;
const enums_1 = require("./lib/access-model/v2/enums");
const crypto_1 = __importDefault(require("crypto"));
const fs_1 = __importDefault(require("fs"));
const https_1 = __importDefault(require("https"));
const path_1 = __importDefault(require("path"));
const util_1 = require("util");
const app_enums_1 = require("./app.enums");
const app_logs_1 = require("./app.logs");
const flatten = (arr) => arr.reduce((a, b) => a.concat(Array.isArray(b) ? (0, exports.flatten)(b) : b), []);
exports.flatten = flatten;
var CommonConstants;
(function (CommonConstants) {
    CommonConstants.maxDate = new Date(2099, 1, 1);
    CommonConstants.minDate = new Date(1970, 1, 1);
})(CommonConstants = exports.CommonConstants || (exports.CommonConstants = {}));
function stringFormat(str, args) {
    let formatted = str;
    for (let index = 0; index < args.length; index++) {
        var regexp = new RegExp("\\{" + index + "\\}", "gi");
        formatted = formatted.replace(regexp, args[index]);
    }
    return formatted;
}
exports.stringFormat = stringFormat;
function hexEncodingToUint8Array(hex) {
    if (!hex) {
        return new Uint8Array(0);
    }
    let size = hex.length / 2;
    let result = new Uint8Array(size);
    for (let i = 0; i < size; i++) {
        result[i] = parseInt(hex[i * 2] + hex[i * 2 + 1], 16);
    }
    return result;
}
exports.hexEncodingToUint8Array = hexEncodingToUint8Array;
function uint8ArrayToHexEncoding(arr) {
    let result = "";
    for (let i = 0; i < arr.length; i++) {
        result += (arr[i] < 16 ? "0" : "") + arr[i].toString(16);
    }
    return result;
}
exports.uint8ArrayToHexEncoding = uint8ArrayToHexEncoding;
function genRandomString(length) {
    return crypto_1.default
        .randomBytes(Math.ceil(length / 2))
        .toString("hex")
        .slice(0, length);
}
exports.genRandomString = genRandomString;
function hashPasswordWithSalt(password, salt) {
    let hash = crypto_1.default.createHmac("sha512", salt);
    hash.update(password);
    let value = hash.digest("hex");
    return {
        salt: salt,
        passwordHash: value,
    };
}
exports.hashPasswordWithSalt = hashPasswordWithSalt;
function saltHashPassword(userpassword) {
    return hashPasswordWithSalt(userpassword, genRandomString(32));
}
exports.saltHashPassword = saltHashPassword;
function getUtcStartOfDay(date) {
    return new Date(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
}
exports.getUtcStartOfDay = getUtcStartOfDay;
exports.MINUTES_IN_A_DAY = 24 * 60;
exports.SECONDS_IN_A_DAY = exports.MINUTES_IN_A_DAY * 60;
exports.MILLISECONDS_IN_A_MINUTE = 60 * 1000;
exports.MILLISECONDS_IN_A_HOUR = 60 * exports.MILLISECONDS_IN_A_MINUTE;
exports.MILLISECONDS_IN_A_DAY = exports.SECONDS_IN_A_DAY * 1000;
exports.MILLISECONDS_IN_A_WEEK = exports.MILLISECONDS_IN_A_DAY * 7;
function areUtcDateTimesInSameDate(d1, d2) {
    return Math.floor(d1.getTime() / exports.MILLISECONDS_IN_A_DAY) == Math.floor(d2.getTime() / exports.MILLISECONDS_IN_A_DAY);
}
exports.areUtcDateTimesInSameDate = areUtcDateTimesInSameDate;
function getISOStringOfNow() {
    let now = new Date();
    let timezoneOffset = now.getTimezoneOffset();
    now.setMinutes(now.getMinutes() - timezoneOffset);
    let iso = now.toISOString();
    return iso.substr(0, iso.length - 1) + timezoneOffsetToString(timezoneOffset);
}
exports.getISOStringOfNow = getISOStringOfNow;
function timezoneOffsetToString(offset) {
    let abs = Math.abs(offset);
    return (offset > 0 ? "-" : "+") + Math.floor(abs / 600) + (Math.floor(abs / 60) % 10) + ":" + Math.floor((abs % 60) / 10) + ((abs % 60) % 10);
}
exports.timezoneOffsetToString = timezoneOffsetToString;
function timezoneStringToMs(tz) {
    let s = tz.split(":");
    let h = parseInt(s[0]);
    return (h * 60 + parseInt(s[1]) * (h < 0 ? -1 : 1)) * exports.MILLISECONDS_IN_A_MINUTE;
}
exports.timezoneStringToMs = timezoneStringToMs;
function compareLocalDates(d1, d2) {
    return d1.year < d2.year ? -1 : d1.year > d2.year ? 1 : d1.month < d2.month ? -1 : d1.month > d2.month ? 1 : d1.day < d2.day ? -1 : d1.day > d2.day ? 1 : 0;
}
exports.compareLocalDates = compareLocalDates;
function localDateToUtcTime(d) {
    return localDateToUtcDate(d).getTime();
}
exports.localDateToUtcTime = localDateToUtcTime;
function localDateToUtcDate(d) {
    return new Date(`${localDateToISOString(d)}Z`);
}
exports.localDateToUtcDate = localDateToUtcDate;
function localDateToEpochTimeInSecs(d) {
    return localDateToUtcDate(d).getTime() / 1000;
}
exports.localDateToEpochTimeInSecs = localDateToEpochTimeInSecs;
function dateToEpochTimeInSecs(d) {
    return d.getTime() / 1000;
}
exports.dateToEpochTimeInSecs = dateToEpochTimeInSecs;
function localDateToISOString(d) {
    return `${d.year}-${d.month > 9 ? d.month : "0" + d.month}-${d.day > 9 ? d.day : "0" + d.day}`;
}
function localDateTimeToEpochTimeInMs(d, hours, minutes, seconds) {
    return new Date(`${localDateToISOString(d)}T${hours > 9 ? hours : "0" + hours}:${minutes > 9 ? minutes : "0" + minutes}:${seconds > 9 ? seconds : "0" + seconds}Z`).getTime();
}
exports.localDateTimeToEpochTimeInMs = localDateTimeToEpochTimeInMs;
function localDateToLocalTimeIndexFormat(d) {
    return (d.year * 10000 + d.month * 100 + d.day) * 1000000;
}
exports.localDateToLocalTimeIndexFormat = localDateToLocalTimeIndexFormat;
function localDateTimeToLocalTimeIndexFormat(d, hours, minutes, seconds) {
    return d.year * 10000000000 + d.month * 100000000 + d.day * 1000000 + hours * 10000 + minutes * 100 + seconds;
}
exports.localDateTimeToLocalTimeIndexFormat = localDateTimeToLocalTimeIndexFormat;
function localDateTimeExToLocalTimeIndexFormat(year, month, day, hours, minutes, seconds) {
    return year * 10000000000 + month * 100000000 + day * 1000000 + hours * 10000 + minutes * 100 + seconds;
}
exports.localDateTimeExToLocalTimeIndexFormat = localDateTimeExToLocalTimeIndexFormat;
function utcDateTimeToLocalTimeIndexFormat(utcDate, hours, minutes, seconds) {
    return utcDate.getUTCFullYear() * 10000000000 + (utcDate.getUTCMonth() + 1) * 100000000 + utcDate.getUTCDate() * 1000000 + hours * 10000 + minutes * 100 + seconds;
}
exports.utcDateTimeToLocalTimeIndexFormat = utcDateTimeToLocalTimeIndexFormat;
function utcTimeToLocalTimeIndexFormat(time) {
    let date = new Date(time);
    return (date.getUTCFullYear() * 10000000000 +
        (date.getUTCMonth() + 1) * 100000000 +
        date.getUTCDate() * 1000000 +
        date.getUTCHours() * 10000 +
        date.getUTCMinutes() * 100 +
        date.getUTCSeconds());
}
exports.utcTimeToLocalTimeIndexFormat = utcTimeToLocalTimeIndexFormat;
function getUTCDayOfWeekForWorkingFromDate(d) {
    let day = d.getUTCDay();
    return day === 0 ? 7 : day;
}
exports.getUTCDayOfWeekForWorkingFromDate = getUTCDayOfWeekForWorkingFromDate;
function areLocalDatesEqual(d1, d2) {
    return d1.day === d2.day && d1.month === d2.month && d1.year === d2.year;
}
exports.areLocalDatesEqual = areLocalDatesEqual;
function getFirstMondayMidnightTimeAfter(d) {
    let dutc = localDateToUtcDate(d);
    let isAlreadyMonday = dutc.getUTCDay() === app_enums_1.enums.DayOfWeek.Monday;
    if (!isAlreadyMonday) {
        while (dutc.getUTCDay() !== app_enums_1.enums.DayOfWeek.Monday) {
            dutc = new Date(dutc.setDate(dutc.getDate() + 1));
        }
    }
    return {
        isAlreadyMonday: isAlreadyMonday,
        midNightTime: dutc.getTime(),
    };
}
exports.getFirstMondayMidnightTimeAfter = getFirstMondayMidnightTimeAfter;
const urlRegExp = new RegExp(/(\b(https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/gi);
const javascriptRegExp = new RegExp(/(^javascript:[\s\S]*;$)/gi);
function json2HtmlTable(model, data) {
    return `
        <table border="1" cellpadding="1" cellspacing="1">
            ${generateHeader(model)}
            ${generateBody(model, data)}      
        </table>    
    `;
}
exports.json2HtmlTable = json2HtmlTable;
function generateHeader(model) {
    let columns = "";
    for (let i = 0; i < model.columns.length; i++) {
        columns += `<th>${model.columns[i].th}</th>`;
    }
    return `
        <thead>${columns}</thead>
    `;
}
function generateBody(model, data) {
    if (data.length === 0) {
        return "";
    }
    let rows = "";
    for (let i = 0; i < data.length; i++) {
        let dataRow = data[i];
        let row = "";
        for (let k = 0; k < model.columns.length; k++) {
            let column = model.columns[k];
            let keyPath = column.contextKey.split(".");
            let value = dataRow;
            for (let contextKeyIndex = 0; contextKeyIndex < keyPath.length; contextKeyIndex++) {
                let contextKeyItem = keyPath[contextKeyIndex];
                value = value[contextKeyItem];
                if (!value) {
                    value = "";
                    break;
                }
            }
            if (column.fn) {
                value = column.fn(value);
            }
            let isUrl = urlRegExp.test(value) || javascriptRegExp.test(value);
            if (isUrl) {
                row += `<td><a href="${value}">${value}</a></td>`;
            }
            else {
                row += `<td>${value}</td>`;
            }
        }
        rows += `<tr ${i % 2 === 0 ? 'class="alt"' : ""}>${row}</tr>`;
    }
    return `
        <tbody>${rows}</tbody>
    `;
}
function renderHtml(template, data) {
    let keys = Object.keys(data);
    for (let index = 0; index < keys.length; index++) {
        let key = keys[index];
        let regex = new RegExp("{{" + key + "}}", "ig");
        template = template.replace(regex, data[key]);
    }
    return template;
}
exports.renderHtml = renderHtml;
function undefinedToNull(obj) {
    let key;
    for (key in obj) {
        let value = obj[key];
        if (value === undefined) {
            obj[key] = null;
        }
        else if ((0, util_1.isObject)(value)) {
            obj[key] = undefinedToNull(value);
        }
    }
    return obj;
}
exports.undefinedToNull = undefinedToNull;
function mkDirSyncRecursively(_path) {
    _path.split(path_1.default.sep).reduce((_path, folder) => {
        _path += folder + path_1.default.sep;
        if (!fs_1.default.existsSync(_path)) {
            fs_1.default.mkdirSync(_path);
        }
        return _path;
    }, "");
}
exports.mkDirSyncRecursively = mkDirSyncRecursively;
function validateEnum(val, type) {
    if (!Number.isInteger(val) || !type[val])
        throw new Error("invalid enum of type " + typeof type + " value: " + val);
    return parseInt(val);
}
exports.validateEnum = validateEnum;
function isTypedEnum(val, type) {
    if (!Number.isInteger(val) || !type[val])
        return false;
    return true;
}
exports.isTypedEnum = isTypedEnum;
function convertToEnglishCharString(text) {
    text = text.replace(/ö/g, "o");
    text = text.replace(/ç/g, "c");
    text = text.replace(/ş/g, "s");
    text = text.replace(/ı/g, "i");
    text = text.replace(/ğ/g, "g");
    text = text.replace(/ü/g, "u");
    text = text.replace(/Ö/g, "O");
    text = text.replace(/Ç/g, "C");
    text = text.replace(/Ş/g, "S");
    text = text.replace(/İ/g, "I");
    text = text.replace(/Ğ/g, "G");
    text = text.replace(/Ü/g, "U");
    text = text.replace(/^\s+|\s+$/g, "");
    return text;
}
exports.convertToEnglishCharString = convertToEnglishCharString;
function deviceEmergencyCodeToAppwebEmergencyCode(emergencyState) {
    switch (emergencyState) {
        case enums_1.EnumsV2.EmergencyState.Emergency:
            return app_enums_1.enums.EmergencyState.Emergency;
        case enums_1.EnumsV2.EmergencyState.Normal:
            return app_enums_1.enums.EmergencyState.Normal;
        default:
            throw new Error("Unknown Emergency State");
    }
}
exports.deviceEmergencyCodeToAppwebEmergencyCode = deviceEmergencyCodeToAppwebEmergencyCode;
function appwebEmergencyCodeToDeviceEmergencyCode(emergencyState) {
    switch (emergencyState) {
        case app_enums_1.enums.EmergencyState.Normal:
            return app_enums_1.enums.ServerToDeviceRPCMessageType.EmergencyEnd;
        case app_enums_1.enums.EmergencyState.Emergency:
            return app_enums_1.enums.ServerToDeviceRPCMessageType.EmergencyStart;
        default:
            throw new Error("Unknown Emergency State");
    }
}
exports.appwebEmergencyCodeToDeviceEmergencyCode = appwebEmergencyCodeToDeviceEmergencyCode;
const isPhoneNumberFromTurkey = (phoneNumber) => {
    const number = parseInt(phoneNumber).toString();
    const regex = new RegExp(/905\d{9}/);
    const regex2 = new RegExp(/^5([0-9]){9}$/);
    const check1 = regex.exec(number.replace(/\D+/g, ""));
    const check2 = regex2.exec(number.replace(/\D+/g, ""));
    return !!(check1 || check2);
};
exports.isPhoneNumberFromTurkey = isPhoneNumberFromTurkey;
function sendHttpsPostRequest(params) {
    const { body, hostname, path, headers } = params;
    return new Promise((resolve, reject) => {
        try {
            const req = https_1.default.request({
                hostname,
                path,
                method: "POST",
                headers: headers
                    ? {
                        "content-type": "application/json",
                        ...headers,
                    }
                    : {
                        "content-type": "application/json",
                    },
            }, async (res) => {
                res.setEncoding("utf8");
                let data = "";
                res.on("data", (chunk) => {
                    data += chunk;
                });
                res.on("end", async () => {
                    if (res.statusCode === 200) {
                        resolve(JSON.parse(data));
                    }
                    else {
                        app_logs_1.logger.error(`An error statusCode[${res.statusCode}] responded during https post request: ` + data);
                        reject(data);
                    }
                });
            });
            req.on("error", (error) => {
                app_logs_1.logger.error("An error occured during https post request: " + error);
                reject(error);
            });
            req.write(typeof body === "string" ? body : JSON.stringify(body));
            req.end();
        }
        catch (error) {
            reject(error);
        }
    });
}
exports.sendHttpsPostRequest = sendHttpsPostRequest;
function sendHttpsGetRequest(params) {
    const { hostname, path, headers } = params;
    return new Promise((resolve, reject) => {
        try {
            const req = https_1.default.request({
                hostname,
                path,
                method: "GET",
                headers: headers
                    ? {
                        "content-type": "application/json",
                        ...headers,
                    }
                    : {
                        "content-type": "application/json",
                    },
            }, async (res) => {
                res.setEncoding("utf8");
                let data = "";
                res.on("data", (chunk) => {
                    data += chunk;
                });
                res.on("end", async () => {
                    if (res.statusCode === 200) {
                        resolve(JSON.parse(data));
                    }
                    else {
                        app_logs_1.logger.error(`An error statusCode[${res.statusCode}] responded during https get request: ` + data);
                        reject(data);
                    }
                });
            });
            req.on("error", (error) => {
                app_logs_1.logger.error("An error occured during https get request: " + error);
                reject(error);
            });
            req.end();
        }
        catch (error) {
            reject(error);
        }
    });
}
exports.sendHttpsGetRequest = sendHttpsGetRequest;
function sleepForMs(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}
exports.sleepForMs = sleepForMs;
