"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initSwagger = void 0;
const express_1 = __importDefault(require("express"));
const fs_1 = __importDefault(require("fs"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const js_yaml_1 = __importDefault(require("js-yaml"));
const path_1 = __importDefault(require("path"));
const i18n_1 = __importDefault(require("i18n"));
const api_error_1 = require("./api/api.error");
const app_auth_1 = require("./app.auth");
const app_config_1 = require("./app.config");
const app_logs_1 = require("./app.logs");
const dal_manager_1 = require("./dal/dal.manager");
const app_constants_1 = require("./app.constants");
var swaggerToolsUserApiV1 = require("swagger-tools");
var swaggerToolsPacsApiV1 = require("swagger-tools");
var swaggerToolsPacsApiV2 = require("swagger-tools");
var swaggerToolsVisitorApiV1 = require("swagger-tools");
var swaggerToolsSocialApiV1 = require("swagger-tools");
let errorHandler = async (err, req, res, next) => {
    if (err.code && err.code === "SCHEMA_VALIDATION_FAILED") {
        err = (0, api_error_1.generateBadRequestApiError)({
            message: "Request validation error",
            validationerrors: err.results.errors,
        });
    }
    if (res.headersSent) {
        return next(err);
    }
    else {
        if (err instanceof api_error_1.ApiTranslatedErrorStructure) {
            let jwt = req.auth_token;
            const { l: locale } = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: jwt.getOrganizationId(), userId: jwt.userId });
            let message = i18n_1.default.__({ phrase: err.message, locale }, err.replacements);
            if (err.noReport) {
                res.status(err.statusCode).json({ message: message, noReport: true, showAsModal: err.showAsModal });
            }
            else {
                res.status(err.statusCode).json({ message: message, noReport: false, showAsModal: err.showAsModal });
            }
        }
        else {
            if (err instanceof Object) {
                app_logs_1.logger.error(`Swagger error handler object: ${JSON.stringify(err)}`);
                app_logs_1.logger.error(err);
            }
            else if (err instanceof Error) {
                app_logs_1.logger.error(`Swagger error handler: ${err}`);
                app_logs_1.logger.error(err);
            }
            else {
                app_logs_1.logger.error(err);
            }
            if (!err.statusCode || err.statusCode === 500) {
                app_logs_1.logger.error("Internal server error: ", err || "something blew up and the err object was undefined");
            }
            res.status(err.statusCode || 500).json(err.body || err.message || err || "something blew up and the err object was undefined");
        }
    }
};
function initSwagger(app, callbackFn) {
    let swaggerDocPacsV1 = js_yaml_1.default.safeLoad(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "pacs-api-docs", "swagger.yaml"), "utf8"));
    swaggerDocPacsV1.host = app_config_1.appConfig.httpServer.hostname + ":" + app_config_1.appConfig.httpServer.port;
    swaggerDocPacsV1.schemes = ["http", "https"];
    swaggerToolsPacsApiV1.initializeMiddleware(swaggerDocPacsV1, function (middleware) {
        app.use(middleware.swaggerMetadata());
        app.use(middleware.swaggerValidator({
            validateResponse: false,
        }));
        app.use(middleware.swaggerSecurity({
            armon_auth: function (req, def, scopes, callback) {
                let authHeader = req.header(app_constants_1.ArmonHeaders.Authorization);
                if (!authHeader) {
                    callback({ code: 2056, message: "Authorization required!" });
                }
                else if (authHeader.indexOf("Bearer ") === -1) {
                    callback({ code: 2057, message: "Invalid authorization header" });
                }
                else {
                    let bearerToken = authHeader.substr(7);
                    try {
                        let decodedToken = jsonwebtoken_1.default.verify(bearerToken, app_config_1.appConfig.jwtSecret);
                        if (decodedToken.s) {
                            for (let i = 0; i < scopes.length; i++) {
                                if (decodedToken.s.indexOf(scopes[i]) === -1) {
                                    callback({ code: 2059, message: "scope " + scopes[i] + " is missing!" });
                                    break;
                                }
                            }
                        }
                        dal_manager_1.dbManager.accessOAuth.hasRevokedToken(decodedToken.o[0].i, decodedToken.i).then((hasRevokedToken) => {
                            if (hasRevokedToken) {
                                callback({ statusCode: 401, code: 2060, message: "The token is revoked! Login again!" });
                            }
                            else {
                                req.raw_auth_token = bearerToken;
                                req.auth_token = new app_auth_1.UserJwtPayload(decodedToken);
                                callback(null);
                            }
                        });
                    }
                    catch (err) {
                        if (err && err.name === "TokenExpiredError") {
                            callback({ statusCode: 401, code: 2060, message: "The token is expired! Login again!" });
                        }
                        else {
                            callback({ code: 2058, message: err });
                        }
                    }
                }
            },
        }));
        app.use(middleware.swaggerRouter({
            swaggerUi: "swagger.json",
            controllers: path_1.default.join(__dirname, "api", "pacs", "v1", "controllers"),
            useStubs: app_config_1.appConfig.nodeEnv == "development",
        }));
        app.use(middleware.swaggerUi({
            apiDocs: "pacs-api-docs",
            apiDocsPrefix: path_1.default.join(app_config_1.appConfig.assetsDirectory, "web"),
        }));
        app.use("/pacs-api-docs", express_1.default.static(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "pacs-api-docs")));
        app.use(errorHandler);
    });
    let swaggerDocPacsV2 = js_yaml_1.default.safeLoad(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "pacs2-api-docs", "swagger.yaml"), "utf8"));
    swaggerDocPacsV2.host = app_config_1.appConfig.httpServer.hostname + ":" + app_config_1.appConfig.httpServer.port;
    swaggerDocPacsV2.schemes = ["http", "https"];
    swaggerToolsPacsApiV2.initializeMiddleware(swaggerDocPacsV2, function (middleware) {
        app.use(middleware.swaggerMetadata());
        app.use(middleware.swaggerValidator({
            validateResponse: false,
        }));
        app.use(middleware.swaggerSecurity({
            armon_auth: function (req, def, scopes, callback) {
                let authHeader = req.header(app_constants_1.ArmonHeaders.Authorization);
                if (!authHeader) {
                    callback({ code: 2056, message: "Authorization required!" });
                }
                else if (authHeader.indexOf("Bearer ") === -1) {
                    callback({ code: 2057, message: "Invalid authorization header" });
                }
                else {
                    let bearerToken = authHeader.substr(7);
                    try {
                        let decodedToken = jsonwebtoken_1.default.verify(bearerToken, app_config_1.appConfig.jwtSecret);
                        if (decodedToken.s) {
                            for (let i = 0; i < scopes.length; i++) {
                                if (decodedToken.s.indexOf(scopes[i]) === -1) {
                                    callback({ code: 2059, message: "scope " + scopes[i] + " is missing!" });
                                    break;
                                }
                            }
                        }
                        dal_manager_1.dbManager.accessOAuth.hasRevokedToken(decodedToken.o[0].i, decodedToken.i).then((hasRevokedToken) => {
                            if (hasRevokedToken) {
                                callback({ statusCode: 401, code: 2060, message: "The token is revoked! Login again!" });
                            }
                            else {
                                req.raw_auth_token = bearerToken;
                                req.auth_token = new app_auth_1.UserJwtPayload(decodedToken);
                                callback(null);
                            }
                        });
                    }
                    catch (err) {
                        if (err && err.name === "TokenExpiredError") {
                            callback({ statusCode: 401, code: 2060, message: "The token is expired! Login again!" });
                        }
                        else {
                            callback({ code: 2058, message: err });
                        }
                    }
                }
            },
        }));
        app.use(middleware.swaggerRouter({
            swaggerUi: "swagger.json",
            controllers: path_1.default.join(__dirname, "api", "pacs", "v2", "controllers"),
            useStubs: app_config_1.appConfig.nodeEnv == "development",
        }));
        app.use(middleware.swaggerUi({
            apiDocs: "pacs2-api-docs",
            apiDocsPrefix: path_1.default.join(app_config_1.appConfig.assetsDirectory, "web"),
        }));
        app.use("/pacs2-api-docs", express_1.default.static(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "pacs2-api-docs")));
        app.use(errorHandler);
    });
    let swaggerDocVisitorV1 = js_yaml_1.default.safeLoad(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "visitor-api-docs", "swagger.yaml"), "utf8"));
    swaggerDocVisitorV1.host = app_config_1.appConfig.httpServer.hostname + ":" + app_config_1.appConfig.httpServer.port;
    swaggerDocVisitorV1.schemes = ["http", "https"];
    swaggerToolsVisitorApiV1.initializeMiddleware(swaggerDocVisitorV1, function (middleware) {
        app.use(middleware.swaggerMetadata());
        app.use(middleware.swaggerValidator({
            validateResponse: false,
        }));
        app.use(middleware.swaggerSecurity({
            armon_auth: function (req, def, scopes, callback) {
                let authHeader = req.header(app_constants_1.ArmonHeaders.Authorization);
                if (!authHeader) {
                    callback({ code: 2056, message: "Authorization required!" });
                }
                else if (authHeader.indexOf("Bearer ") === -1) {
                    callback({ code: 2057, message: "Invalid authorization header" });
                }
                else {
                    let bearerToken = authHeader.substr(7);
                    try {
                        let decodedToken = jsonwebtoken_1.default.verify(bearerToken, app_config_1.appConfig.jwtSecret);
                        if (decodedToken.s) {
                            for (let i = 0; i < scopes.length; i++) {
                                if (decodedToken.s.indexOf(scopes[i]) === -1) {
                                    callback({ code: 2059, message: "scope " + scopes[i] + " is missing!" });
                                    break;
                                }
                            }
                        }
                        dal_manager_1.dbManager.accessOAuth.hasRevokedToken(decodedToken.o[0].i, decodedToken.i).then((hasRevokedToken) => {
                            if (hasRevokedToken) {
                                callback({ statusCode: 401, code: 2060, message: "The token is revoked! Login again!" });
                            }
                            else {
                                req.raw_auth_token = bearerToken;
                                req.auth_token = new app_auth_1.UserJwtPayload(decodedToken);
                                callback(null);
                            }
                        });
                    }
                    catch (err) {
                        if (err && err.name === "TokenExpiredError") {
                            callback({ statusCode: 401, code: 2060, message: "The token is expired! Login again!" });
                        }
                        else {
                            callback({ code: 2058, message: err });
                        }
                    }
                }
            },
        }));
        app.use(middleware.swaggerRouter({
            swaggerUi: "swagger.json",
            controllers: path_1.default.join(__dirname, "api", "visitor", "v1", "controllers"),
            useStubs: app_config_1.appConfig.nodeEnv == "development",
        }));
        app.use(middleware.swaggerUi({
            apiDocs: "visitor-api-docs",
            apiDocsPrefix: path_1.default.join(app_config_1.appConfig.assetsDirectory, "web"),
        }));
        app.use("/visitor-api-docs", express_1.default.static(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "visitor-api-docs")));
        app.use(errorHandler);
    });
    let swaggerDocUserV1 = js_yaml_1.default.safeLoad(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "user-api-docs", "swagger.yaml"), "utf8"));
    swaggerDocUserV1.host = app_config_1.appConfig.httpServer.hostname + ":" + app_config_1.appConfig.httpServer.port;
    swaggerDocUserV1.schemes = ["http", "https"];
    swaggerToolsUserApiV1.initializeMiddleware(swaggerDocUserV1, function (middleware) {
        app.use(middleware.swaggerMetadata());
        app.use(middleware.swaggerValidator({
            validateResponse: false,
        }));
        app.use(middleware.swaggerSecurity({
            armon_auth: function (req, def, scopes, callback) {
                let authHeader = req.header(app_constants_1.ArmonHeaders.Authorization);
                if (!authHeader) {
                    callback({ code: 2056, message: "Authorization required!" });
                }
                else if (authHeader.indexOf("Bearer ") === -1) {
                    callback({ code: 2057, message: "Invalid authorization header" });
                }
                else {
                    let bearerToken = authHeader.substr(7);
                    try {
                        let decodedToken = jsonwebtoken_1.default.verify(bearerToken, app_config_1.appConfig.jwtSecret);
                        if (decodedToken.s) {
                            for (let i = 0; i < scopes.length; i++) {
                                if (decodedToken.s.indexOf(scopes[i]) === -1) {
                                    callback({ code: 2059, message: "scope " + scopes[i] + " is missing!" });
                                    break;
                                }
                            }
                        }
                        dal_manager_1.dbManager.accessOAuth.hasRevokedToken(decodedToken.o[0].i, decodedToken.i).then((hasRevokedToken) => {
                            if (hasRevokedToken) {
                                callback({ statusCode: 401, code: 2060, message: "The token is revoked! Login again!" });
                            }
                            else {
                                req.raw_auth_token = bearerToken;
                                req.auth_token = new app_auth_1.UserJwtPayload(decodedToken);
                                callback(null);
                            }
                        });
                    }
                    catch (err) {
                        if (err && err.name === "TokenExpiredError") {
                            callback({ statusCode: 401, code: 2060, message: "The token is expired! Login again!" });
                        }
                        else {
                            callback({ code: 2058, message: err });
                        }
                    }
                }
            },
        }));
        app.use(middleware.swaggerRouter({
            swaggerUi: "swagger.json",
            controllers: path_1.default.join(__dirname, "api", "user", "v1", "controllers"),
            useStubs: app_config_1.appConfig.nodeEnv == "development",
        }));
        app.use(middleware.swaggerUi({
            apiDocs: "user-api-docs",
            apiDocsPrefix: path_1.default.join(app_config_1.appConfig.assetsDirectory, "web"),
        }));
        app.use("/user-api-docs", express_1.default.static(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "user-api-docs")));
        app.use(errorHandler);
        callbackFn(null);
    });
    let swaggerDocSocialV1 = js_yaml_1.default.safeLoad(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "social-api-docs", "swagger.yaml"), "utf8"));
    swaggerDocSocialV1.host = app_config_1.appConfig.httpServer.hostname + ":" + app_config_1.appConfig.httpServer.port;
    swaggerDocSocialV1.schemes = ["http", "https"];
    swaggerToolsSocialApiV1.initializeMiddleware(swaggerDocSocialV1, function (middleware) {
        app.use(middleware.swaggerMetadata());
        app.use(middleware.swaggerValidator({
            validateResponse: false,
        }));
        app.use(middleware.swaggerSecurity({
            armon_auth: function (req, def, scopes, callback) {
                let authHeader = req.header(app_constants_1.ArmonHeaders.Authorization);
                if (!authHeader) {
                    callback({ code: 2056, message: "Authorization required!" });
                }
                else if (authHeader.indexOf("Bearer ") === -1) {
                    callback({ code: 2057, message: "Invalid authorization header" });
                }
                else {
                    let bearerToken = authHeader.substr(7);
                    try {
                        let decodedToken = jsonwebtoken_1.default.verify(bearerToken, app_config_1.appConfig.jwtSecret);
                        if (decodedToken.s) {
                            for (let i = 0; i < scopes.length; i++) {
                                if (decodedToken.s.indexOf(scopes[i]) === -1) {
                                    callback({ code: 2059, message: "scope " + scopes[i] + " is missing!" });
                                    break;
                                }
                            }
                        }
                        dal_manager_1.dbManager.accessOAuth.hasRevokedToken(decodedToken.o[0].i, decodedToken.i).then((hasRevokedToken) => {
                            if (hasRevokedToken) {
                                callback({ statusCode: 401, code: 2060, message: "The token is revoked! Login again!" });
                            }
                            else {
                                req.raw_auth_token = bearerToken;
                                req.auth_token = new app_auth_1.UserJwtPayload(decodedToken);
                                callback(null);
                            }
                        });
                    }
                    catch (err) {
                        if (err && err.name === "TokenExpiredError") {
                            callback({ statusCode: 401, code: 2060, message: "The token is expired! Login again!" });
                        }
                        else {
                            callback({ code: 2058, message: err });
                        }
                    }
                }
            },
        }));
        app.use(middleware.swaggerRouter({
            swaggerUi: "swagger.json",
            controllers: path_1.default.join(__dirname, "api", "social", "v1", "controllers"),
            useStubs: app_config_1.appConfig.nodeEnv === "development",
        }));
        app.use(middleware.swaggerUi({
            apiDocs: "social-api-docs",
            apiDocsPrefix: path_1.default.join(app_config_1.appConfig.assetsDirectory, "web"),
        }));
        app.use("/social-api-docs", express_1.default.static(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "social-api-docs")));
        app.use(errorHandler);
    });
}
exports.initSwagger = initSwagger;
