"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pg_1 = require("pg");
const app_logs_1 = require("./app.logs");
const pcs = __importStar(require("pg-copy-streams"));
const app_config_1 = require("./app.config");
const moment_1 = __importDefault(require("moment"));
const cli_config_1 = __importDefault(require("./components/cli/cli.config"));
const app_constants_1 = require("./app.constants");
const publicSchemaTableNames = {
    AuditLogs: "audit_logs",
};
const orgBasedSchemaTableNames = {
    AccessLogs: "access_logs",
    AccessSnapshots: "access_snapshots",
    CounterSensorLogs: "counter_sensor_logs",
    EmployeeDaySegments: "employee_day_segments",
    MonthlySummaryHistory: "monthly_summary_history",
    OrganizationFeedbackUpdates: "organization_feedback_updates",
    OrganizationFeedbacks: "organization_feedbacks",
    PPermissionHistory: "ppermission_history",
    StatusSensorLogs: "status_sensor_logs",
    SystemStatusLogs: "system_status_logs",
    TamperSwitchLogs: "tamper_switch_logs",
    UploadLogHistory: "upload_log_history",
    UserActionHistory: "user_action_history",
    UserMonthlySummaryHistory: "user_monthly_summary_history",
    UserTicketTransactionHistory: "user_ticket_transaction_history",
    VisitHistory: "visit_history",
    VisitorPreregistrationHistory: "visitor_preregistration_history",
    LogHistory: "log_history",
    LogProcessHistory: "log_process_history",
};
async function migrateDataFromLogDbToMainDb() {
    app_config_1.appConfig.init(app_constants_1.ServiceNames.PGMaintenanceService);
    app_logs_1.logger.warn("ATTENTION! This migration operation will take long time to complete, please don't interrupt the process!");
    const mainDbClient = await new pg_1.Pool({
        user: cli_config_1.default.PGSUPERUSER,
        application_name: "log_db_to_main_migration",
        max: 10,
    }).connect();
    const logDbClient = await new pg_1.Pool({
        host: app_config_1.appConfig.db.log.host,
        port: app_config_1.appConfig.db.log.port,
        user: app_config_1.appConfig.db.log.username,
        password: app_config_1.appConfig.db.log.password,
        database: app_config_1.appConfig.db.log.name,
    }).connect();
    const organizationIds = (await mainDbClient.query(`
		SELECT id FROM public."organizationList";
	`)).rows.map((r) => r.id);
    mainDbClient.query("BEGIN");
    logDbClient.query("BEGIN");
    try {
        if (organizationIds && organizationIds.length > 0) {
            for (const oid of organizationIds) {
                for (const tableName of Object.values(orgBasedSchemaTableNames)) {
                    if (tableName === orgBasedSchemaTableNames.AccessSnapshots) {
                        let endDate = (0, moment_1.default)("2021-02-01");
                        let startDate = (0, moment_1.default)("2018-01-01");
                        while (startDate.isBefore(endDate)) {
                            let partitionStart = (0, moment_1.default)(endDate).add(-1, "months");
                            try {
                                const result = await new Promise((resolve, reject) => {
                                    const q = `COPY (SELECT * FROM "${oid}".${tableName} WHERE "actionUtc" < '${endDate.toISOString()}' and "actionUtc" >= '${partitionStart.toISOString()}') TO STDOUT`;
                                    var readStream = logDbClient.query(pcs.to(q));
                                    var stream = mainDbClient.query(pcs.from(`COPY "${oid}".${tableName} FROM STDIN`));
                                    readStream.on("error", (err) => {
                                        app_logs_1.logger.error(err);
                                        app_logs_1.logger.info(`${oid}.${tableName} migration failed`);
                                        resolve(false);
                                    });
                                    readStream
                                        .pipe(stream)
                                        .on("finish", () => {
                                        app_logs_1.logger.info(`${oid}.${tableName} between (${partitionStart.toISOString()} - ${endDate.toISOString()}) migration finished`);
                                        resolve(true);
                                    })
                                        .on("error", (err) => {
                                        app_logs_1.logger.error(err);
                                        app_logs_1.logger.info(`${oid}.${tableName} migration failed`);
                                        resolve(false);
                                    });
                                });
                                if (!result) {
                                    app_logs_1.logger.error(`!!!!!!!!!!!!! ${oid}.${tableName} migration for dates between (${partitionStart.toISOString()} - ${endDate.toISOString()}) failed, should be handled seperately!`);
                                }
                            }
                            catch (err) {
                                app_logs_1.logger.error(err);
                            }
                            mainDbClient.query("COMMIT");
                            mainDbClient.query("BEGIN");
                            endDate.add(-1, "months");
                        }
                    }
                    else {
                        try {
                            const result = await new Promise((resolve, reject) => {
                                var readStream = logDbClient.query(pcs.to(`COPY (SELECT * FROM "${oid}".${tableName}) TO STDOUT`));
                                var stream = mainDbClient.query(pcs.from(`COPY "${oid}".${tableName} FROM STDIN`));
                                readStream.on("error", (err) => {
                                    app_logs_1.logger.error(err);
                                    app_logs_1.logger.info(`${oid}.${tableName} migration failed`);
                                    resolve(false);
                                });
                                readStream
                                    .pipe(stream)
                                    .on("finish", () => {
                                    app_logs_1.logger.info(`${oid}.${tableName} migration finished`);
                                    resolve(true);
                                })
                                    .on("error", (err) => {
                                    app_logs_1.logger.error(err);
                                    app_logs_1.logger.info(`${oid}.${tableName} migration failed`);
                                    resolve(false);
                                });
                            });
                            if (!result) {
                                app_logs_1.logger.error(`!!!!!!!!!!!!! ${oid}.${tableName} migration failed, should be handled seperately!`);
                            }
                        }
                        catch (err) {
                            app_logs_1.logger.error(err);
                        }
                    }
                    mainDbClient.query("COMMIT");
                    mainDbClient.query("BEGIN");
                }
            }
            for (const tableName of Object.values(publicSchemaTableNames)) {
                await new Promise((resolve, reject) => {
                    var readStream = logDbClient.query(pcs.to(`COPY (SELECT * FROM public.${tableName}) TO STDOUT`));
                    var stream = mainDbClient.query(pcs.from(`COPY public.${tableName} FROM STDIN`));
                    readStream.on("error", (err) => {
                        app_logs_1.logger.error(err);
                        app_logs_1.logger.info(`public.${tableName} migration failed`);
                        reject(err);
                    });
                    readStream
                        .pipe(stream)
                        .on("finish", () => {
                        app_logs_1.logger.info(`public.${tableName} migration finished`);
                        resolve(null);
                    })
                        .on("error", (err) => {
                        app_logs_1.logger.error(err);
                        app_logs_1.logger.info(`public.${tableName} migration failed`);
                        reject(err);
                    });
                });
            }
        }
        else {
            app_logs_1.logger.error("Error while fetching organizationIds from public.organizationList");
            process.exit(1);
        }
        await mainDbClient.query("COMMIT");
        await logDbClient.query("COMMIT");
    }
    catch (err) {
        await mainDbClient.query("ROLLBACK");
        await logDbClient.query("ROLLBACK");
        app_logs_1.logger.error(err);
    }
    mainDbClient.release();
    logDbClient.release();
}
migrateDataFromLogDbToMainDb();
