"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.httpServer = void 0;
const express_body_parser_error_handler_1 = __importDefault(require("express-body-parser-error-handler"));
const cors_1 = __importDefault(require("cors"));
const express_1 = __importDefault(require("express"));
const express_fileupload_1 = __importDefault(require("express-fileupload"));
const fs_1 = __importDefault(require("fs"));
const Handlebars = __importStar(require("handlebars"));
const http_1 = __importDefault(require("http"));
const http_proxy_1 = __importDefault(require("http-proxy"));
const https_1 = __importDefault(require("https"));
const path_1 = __importDefault(require("path"));
const socket_io_1 = require("socket.io");
const api_aperio_controller_1 = require("./api/aperio/v1/api.aperio.controller");
const api_aperio_controller_2 = require("./api/aperio/v3/api.aperio.controller");
const api_validatorhelper_1 = require("./api/api.validatorhelper");
const api_armonv10_controller_1 = require("./api/armonv10/v1/api.armonv10.controller");
const api_armonv10_controller_2 = require("./api/armonv10/v3/api.armonv10.controller");
const api_controlPanel_controller_1 = require("./api/controlPanel/v2/api.controlPanel.controller");
const api_controlPanel_controller_2 = require("./api/controlPanel/v3/api.controlPanel.controller");
const api_hikvision_controller_1 = require("./api/hikVision/v3/api.hikvision.controller");
const api_licence_controller_1 = require("./api/licence/v1/api.licence.controller");
const api_mobile_client_controller_1 = require("./api/mobile/v1/api.mobile-client.controller");
const api_terminal_controller_1 = require("./api/terminal/v1/api.terminal.controller");
const api_visitor_tablet_controller_1 = require("./api/visitor-tablet/v1/api.visitor-tablet.controller");
const app_config_1 = require("./app.config");
const app_extensions_1 = require("./app.extensions");
const app_logs_1 = require("./app.logs");
const app_proxyserver_1 = require("./app.proxyserver");
const dal_manager_1 = require("./dal/dal.manager");
const ws_usernsp_1 = require("./ws/ws.usernsp");
const app_constants_1 = require("./app.constants");
const helmet_1 = __importDefault(require("helmet"));
const localIps = ["127.0.0.1", "::ffff:127.0.0.1", "::1"];
var cookieParser = require("cookie-parser");
const SSL_OP_NO_RENEGOTIATION = 0x40000000;
class HttpServer {
    constructor() { }
    init() {
        this._app = (0, express_1.default)();
        this._app.use((req, res, next) => {
            res.setHeader("Permissions-Policy", "geolocation=(),camera=(),fullscreen=(self),display-capture=(),publickey-credentials-create=(),publickey-credentials-get=()");
            next();
        });
        const helmetOptions = {
            xFrameOptions: { action: "sameorigin" },
            xContentTypeOptions: true,
            contentSecurityPolicy: false,
            referrerPolicy: { policy: "strict-origin-when-cross-origin" },
        };
        if (app_config_1.appConfig.httpServer.ssl?.certFileName &&
            app_config_1.appConfig.httpServer.ssl?.keyFileName &&
            fs_1.default.existsSync(app_config_1.appConfig.httpServer.ssl?.certFileName) &&
            fs_1.default.existsSync(app_config_1.appConfig.httpServer.ssl?.keyFileName)) {
            helmetOptions.strictTransportSecurity = {
                includeSubDomains: true,
                maxAge: 31536000,
            };
        }
        this._app.use((0, helmet_1.default)(helmetOptions));
        let _cors = null;
        if (app_config_1.appConfig.httpServer.cors) {
            try {
                _cors = (0, cors_1.default)(app_config_1.appConfig.httpServer.cors);
                this._app.use(_cors);
            }
            catch (err) {
                app_logs_1.logger.error("Error while parsing cors options file! %j", err);
                process.exit(1);
            }
        }
        else {
            this._app.use(function (req, res, next) {
                let method = req.method && req.method.toUpperCase && req.method.toUpperCase();
                let origin = req.headers.origin;
                if (origin) {
                    res.setHeader("Access-Control-Allow-Origin", origin);
                }
                else {
                    res.setHeader("Access-Control-Allow-Origin", "*");
                }
                res.header("Access-Control-Allow-Methods", "GET, POST, OPTIONS, PUT, PATCH, DELETE");
                if (req.path.match(/^\/auth\//)) {
                    res.header("Access-Control-Allow-Credentials", "true");
                    res.header("Access-Control-Allow-Headers", [
                        "Content-Type",
                        "X-Requested-With",
                        "Authorization",
                        "Accept",
                        "Origin",
                        app_constants_1.ArmonHeaders.ModelType,
                        app_constants_1.ArmonHeaders.ReqType,
                        app_constants_1.ArmonHeaders.Waiting,
                        app_constants_1.ArmonHeaders.UserAgentId,
                    ].join(","));
                    return next();
                }
                if (method == "OPTIONS") {
                    for (const header of Object.keys(req.headers)) {
                        res.setHeader(header, req.headers[header]);
                    }
                    res.header("Access-Control-Allow-Methods", "GET, POST, OPTIONS, PUT, PATCH, DELETE");
                    res.header("Access-Control-Allow-Credentials", "true");
                    res.header("Access-Control-Allow-Headers", [
                        "Content-Type",
                        "X-Requested-With",
                        "Authorization",
                        "Accept",
                        "Origin",
                        "pragma",
                        "cache-control",
                        "if-modified-since",
                        app_constants_1.ArmonHeaders.ModelType,
                        app_constants_1.ArmonHeaders.ReqType,
                        app_constants_1.ArmonHeaders.Waiting,
                        app_constants_1.ArmonHeaders.UserAgentId,
                    ].join(","));
                    return res.sendStatus(200);
                }
                return next();
            });
        }
        var session = require("express-session");
        this._app.use(session({
            secret: "armon",
            resave: true,
            saveUninitialized: false,
        }));
        this._app.use(cookieParser());
        this._app.use(express_1.default.json({ limit: "2mb" }));
        this._app.use((0, express_body_parser_error_handler_1.default)({
            errorMessage(err) {
                return `Invalid JSON value at request, please check request body`;
            },
        }));
        app_extensions_1.appExtensions.addCustomEndPoints(this._app);
        this._app.get("/unsub/:oId/:token/:locale", async (req, res) => {
            try {
                const validator = new api_validatorhelper_1.ValidatorHelper();
                validator.validateUUID("input1", false, req.params.oId);
                validator.validateString({ input: req.params.token, optional: false, minLength: 64, maxLength: 64, field: "input2" });
                validator.validateString({ input: req.params.locale, optional: false, minLength: 2, maxLength: 2, field: "input3" });
                validator.finalize();
                const organizationId = req.params.oId;
                const token = req.params.token;
                const locale = req.params.locale;
                const unsubscribeInfo = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                    const unsubscribeInfo = await dal_manager_1.dbManager.accessNotifications.getUnsubsribeUserFromToken({
                        organizationId,
                        token,
                        trx,
                    });
                    await dal_manager_1.dbManager.accessUser.setUserSettings({
                        organizationId,
                        userId: unsubscribeInfo.userId,
                        forceCloseAllEmailMediums: unsubscribeInfo.type ? false : true,
                        updateMode: true,
                        trx,
                        settings: {
                            locale: undefined,
                            notification: {
                                mediumSettings: {
                                    general: {
                                        email: unsubscribeInfo.type ? undefined : false,
                                    },
                                    custom: unsubscribeInfo.type
                                        ? {
                                            [+unsubscribeInfo.type]: {
                                                email: false,
                                            },
                                        }
                                        : undefined,
                                },
                            },
                        },
                    });
                    return unsubscribeInfo;
                });
                if (unsubscribeInfo.type) {
                    const response = Handlebars.compile(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.httpServer.staticDirectory, `unsubscribe-type.${locale}.handlebars`), "utf8"))({});
                    res.send(response);
                }
                else {
                    const response = Handlebars.compile(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.httpServer.staticDirectory, `unsubscribe-all.${locale}.handlebars`), "utf8"))({});
                    res.send(response);
                }
            }
            catch (error) {
                app_logs_1.logger.error("Error while handling unsub request: " + error.message);
                app_logs_1.logger.error(error);
                res.status(500).send("Bad Request");
            }
        });
        this._app.use("/app", express_1.default.static(__dirname + "/app"));
        new api_mobile_client_controller_1.ApiMobileClientController(this._app);
        this._app.get("/", app_config_1.appConfig.hostBaseRedirectUrl
            ? async (req, res, next) => {
                res.redirect(app_config_1.appConfig.hostBaseRedirectUrl);
            }
            : express_1.default.static(__dirname + "/web"));
        if (app_config_1.appConfig.httpServer.staticDirectory) {
            this._app.use("/static", express_1.default.static(app_config_1.appConfig.httpServer.staticDirectory, {
                extensions: ["htm", "html"],
            }));
        }
        this._cliApp = (0, express_1.default)();
        this._cliApp.use((0, express_fileupload_1.default)({
            useTempFiles: true,
            tempFileDir: app_config_1.appConfig.tmpDirectory,
        }));
        this._deviceServerApp = (0, express_1.default)();
        new api_armonv10_controller_1.ApiArmonV10Controller(this._deviceServerApp);
        new api_controlPanel_controller_1.ApiControlPanelControllerV2(this._deviceServerApp);
        new api_aperio_controller_1.ApiAperioAdapterController(this._deviceServerApp);
        new api_terminal_controller_1.ApiTerminalControllerV1(this._deviceServerApp);
        new api_controlPanel_controller_2.ApiControlPanelControllerV3(this._deviceServerApp);
        new api_armonv10_controller_2.ApiArmonV10ControllerV3(this._deviceServerApp);
        new api_aperio_controller_2.ApiAperioAdapterControllerV3(this._deviceServerApp);
        new api_hikvision_controller_1.ApiHikVisionAdapterControllerV1(this._deviceServerApp);
        new api_licence_controller_1.ApiLicenceControllverV1(this._deviceServerApp);
    }
    get app() {
        return this._app;
    }
    get server() {
        return this._server;
    }
    returnErrorResponse(res, error) {
        if (error.errorCode) {
            return res.status(error.errorCode).json(error);
        }
        else if (error.validationerrors) {
            return res.status(400).json(error);
        }
        else if (error.statusCode) {
            return res.status(error.statusCode).json(error);
        }
        else {
            return res.status(500).json(error);
        }
    }
    async startDeviceServer() {
        return new Promise((resolve, reject) => {
            this._deviceServer = https_1.default.createServer({
                key: fs_1.default.readFileSync(app_config_1.appConfig.terminalServer.ssl.keyFileName, "utf8"),
                cert: fs_1.default.readFileSync(app_config_1.appConfig.terminalServer.ssl.certFileName, "utf8"),
                ca: [fs_1.default.readFileSync(app_config_1.appConfig.terminalServer.ssl.caFileName, "utf8")],
                requestCert: true,
                rejectUnauthorized: true,
            }, this._deviceServerApp);
            this._deviceServer.addListener("error", ((err) => {
                app_logs_1.logger.error(err);
                reject(err);
            }).bind(this));
            this._deviceServer.listen(app_config_1.appConfig.terminalServer.port, () => {
                app_logs_1.logger.info("Device Server HTTPS is listening on port %d (https://localhost:%d)", app_config_1.appConfig.terminalServer.port, app_config_1.appConfig.terminalServer.port);
                resolve();
            });
        });
    }
    startApiServer() {
        return new Promise((resolve, reject) => {
            let ssl = false;
            if (app_config_1.appConfig.httpServer.ssl &&
                app_config_1.appConfig.httpServer.ssl.certFileName &&
                fs_1.default.existsSync(app_config_1.appConfig.httpServer.ssl.certFileName) &&
                app_config_1.appConfig.httpServer.ssl.keyFileName &&
                fs_1.default.existsSync(app_config_1.appConfig.httpServer.ssl.keyFileName)) {
                ssl = true;
                this._server = https_1.default.createServer({
                    key: fs_1.default.readFileSync(app_config_1.appConfig.httpServer.ssl.keyFileName, "utf8"),
                    cert: fs_1.default.readFileSync(app_config_1.appConfig.httpServer.ssl.certFileName, "utf8"),
                    secureOptions: SSL_OP_NO_RENEGOTIATION,
                }, this._app);
            }
            else {
                this._server = http_1.default.createServer(this._app);
            }
            if (app_config_1.appConfig.httpServer.enableProxyEndPoint) {
                let httpProxyOptions = {
                    xfwd: true,
                };
                let options = {
                    httpProxyOptions: httpProxyOptions,
                };
                let proxy = http_proxy_1.default.createServer(httpProxyOptions);
                let requestHandler = (0, app_proxyserver_1.getProxyHandler)(options, proxy);
                this._app.all("/proxy/*", requestHandler);
                proxy.on("error", function (err, req, res) {
                    if (res.headersSent) {
                        return;
                    }
                    res.writeHead(404, { "Access-Control-Allow-Origin": "*" });
                    res.end("Not found because of proxy error: " + err);
                });
                proxy.on("proxyRes", app_proxyserver_1.onProxyResponse);
            }
            this.startWebSocketServer();
            this._server.addListener("error", ((err) => {
                app_logs_1.logger.error(err);
                reject(err);
            }).bind(this));
            this._server.listen(app_config_1.appConfig.httpServer.port, () => {
                let sslOkNok = ssl ? "S" : "";
                app_logs_1.logger.info("HTTP%s is listening on port %d (http%s://localhost:%d)", sslOkNok, app_config_1.appConfig.httpServer.port, sslOkNok, app_config_1.appConfig.httpServer.port);
                app_logs_1.logger.info("Socket is listenning on http%s://localhost:%d/socket.io", sslOkNok, app_config_1.appConfig.httpServer.port);
                app_logs_1.logger.info("Swagger-ui is available on http%s://localhost:%d/api-docs", sslOkNok, app_config_1.appConfig.httpServer.port);
                resolve();
            });
            new api_visitor_tablet_controller_1.ApiVisitorTabletConrollerV1(this._app, this._server);
        });
    }
    startWebSocketServer() {
        this._io = new socket_io_1.Server(this._server, {
            pingTimeout: 30000,
            pingInterval: 30000,
        });
        this._userNsp = new ws_usernsp_1.UserWebSocketNsp(this._io.of(app_config_1.appConfig.httpServer.socketNspPrefix + "webclient"));
    }
    sendVisitorListChangedNotification(organizationId) {
        if (!this._userNsp) {
            return Promise.reject("Socket server is not available during sendVisitorListChangedNotification function");
        }
        this._userNsp.sendVisitorListChangedNotification(organizationId);
        return Promise.resolve(true);
    }
    async sendRegionEmergencyNotification(params) {
        if (!this._userNsp) {
            return Promise.reject("Socket server is not available during sendRegionEmergencyNotification function");
        }
        this._userNsp.sendRegionEmergencyNotification(params);
        return true;
    }
    async sendTerminalEmergencyNotification(params) {
        if (!this._userNsp) {
            return Promise.reject("Socket server is not available during sendTerminalEmergencyNotification function");
        }
        this._userNsp.sendTerminalEmergencyNotification(params);
        return true;
    }
    sendRemoteAccessGrantsChangedNotification(organizationId, userId) {
        if (!this._userNsp) {
            return Promise.reject("Socket server is not available during sendRemoteAccessGrantsChangedNotification function");
        }
        this._userNsp.sendRemoteAccessGrantsChanged(organizationId, userId);
        return Promise.resolve(true);
    }
    async sendRemoteStateChangedNotification(organizationId, data) {
        if (!this._userNsp) {
            return Promise.reject("Socket server is not available during sendRemoteStateChangedNotification function");
        }
        await this._userNsp.sendRemoteStateChanged(organizationId, data);
        return Promise.resolve(true);
    }
    sendNewNotification(organizationId, userId, notification) {
        if (!this._userNsp) {
            return Promise.reject("Socket server is not available during sendNewNotification function");
        }
        this._userNsp.sendNewNotification(organizationId, userId, notification);
        return Promise.resolve(true);
    }
}
exports.httpServer = new HttpServer();
