"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.enums = void 0;
const dal_constants_1 = require("./dal/dal.constants");
const restapi_1 = require("./lib/es/models/restapi");
var enums;
(function (enums) {
    enums.libEnumsV2 = dal_constants_1.DalConstants.libEnumsV2;
    enums.libEnumsV3 = dal_constants_1.DalConstants.libEnumsV3;
    enums.VisitorQRCodeType = dal_constants_1.DalConstants.VisitorQRCodeType;
    enums.VisitorCommunicationMediumType = dal_constants_1.DalConstants.VisitorCommunicationMediumType;
    enums.MobileAuthenticationFactor = dal_constants_1.DalConstants.MobileAuthenticationFactor;
    enums.AuthenticationFactor = dal_constants_1.DalConstants.AuthenticationFactor;
    enums.CurrentPPermissionInfoType = dal_constants_1.DalConstants.CurrentPPermissionInfoType;
    enums.BreakType = dal_constants_1.DalConstants.BreakType;
    enums.BreakMethod = dal_constants_1.DalConstants.BreakMethod;
    enums.BreakUsedDurationType = dal_constants_1.DalConstants.BreakUsedDurationType;
    enums.SortField = dal_constants_1.DalConstants.SortField;
    enums.SortType = dal_constants_1.DalConstants.SortType;
    enums.AccessDirection = dal_constants_1.DalConstants.AccessDirection;
    enums.NotificationType = dal_constants_1.DalConstants.NotificationType;
    enums.NotificationTokenType = dal_constants_1.DalConstants.NotificationTokenType;
    enums.AccessControlPointType = dal_constants_1.DalConstants.AccessControlPointType;
    enums.NotificationMedium = dal_constants_1.DalConstants.NotificationMedium;
    enums.NotificationSensorType = dal_constants_1.DalConstants.NotificationSensorType;
    enums.CounterSensorReason = dal_constants_1.DalConstants.CounterSensorReason;
    enums.UnterminatedVisitState = dal_constants_1.DalConstants.UnterminatedVisitState;
    enums.DeviceChangeItemType = dal_constants_1.DalConstants.DeviceChangeItemType;
    enums.TextFormFieldTypeTransform = dal_constants_1.DalConstants.TextFormFieldTypeTransform;
    enums.OrganizationFeedbackType = dal_constants_1.DalConstants.OrganizationFeedbackType;
    enums.OrganizationFeedbackStatus = dal_constants_1.DalConstants.OrganizationFeedbackStatus;
    enums.OrganizationFeedbackOrigin = dal_constants_1.DalConstants.OrganizationFeedbackOrigin;
    enums.OrganizationVisitorStates = dal_constants_1.DalConstants.OrganizationVisitorStates;
    enums.FingerIndex = dal_constants_1.DalConstants.FingerIndex;
    enums.WorkPlanTimeRangeType = dal_constants_1.DalConstants.WorkPlanTimeRangeType;
    enums.EmployeeTimeRangeType = dal_constants_1.DalConstants.EmployeeTimeRangeType;
    enums.AttendanceTimeRangeType = dal_constants_1.DalConstants.AttendanceTimeRangeType;
    enums.RecalculateWorkReason = dal_constants_1.DalConstants.RecalculateWorkReason;
    enums.ToleranceType = dal_constants_1.DalConstants.ToleranceType;
    enums.PPermissionType = dal_constants_1.DalConstants.PPermissionType;
    enums.SegmentConflictItemType = dal_constants_1.DalConstants.SegmentConflictItemType;
    enums.WorkSummarySortType = dal_constants_1.DalConstants.WorkSummarySortType;
    enums.EmployeeStatus = dal_constants_1.DalConstants.EmployeeStatus;
    enums.EmployeeBinaryDistributionType = dal_constants_1.DalConstants.EmployeeBinaryDistributionType;
    enums.CustomOrganizationReportFilterType = dal_constants_1.DalConstants.CustomOrganizationReportFilterType;
    enums.UserSelectionSessionAccessControlPointRightScope = dal_constants_1.DalConstants.UserSelectionSessionAccessControlPointRightScope;
    let TerminalInsertDataFormat;
    (function (TerminalInsertDataFormat) {
        TerminalInsertDataFormat[TerminalInsertDataFormat["StandartFingerPrint"] = 1] = "StandartFingerPrint";
    })(TerminalInsertDataFormat = enums.TerminalInsertDataFormat || (enums.TerminalInsertDataFormat = {}));
    enums.ReportCode = restapi_1.ReportCode;
    enums.ReportFormat = dal_constants_1.DalConstants.ReportFormat;
    enums.EmergencyState = dal_constants_1.DalConstants.EmergencyState;
    enums.SoftwareUpdateInterfaceState = dal_constants_1.DalConstants.SoftwareUpdateInterfaceState;
    enums.ServerConnectionCommand = dal_constants_1.DalConstants.ServerConnectionCommand;
    let DeviceOfAdapterConnectionState;
    (function (DeviceOfAdapterConnectionState) {
        DeviceOfAdapterConnectionState[DeviceOfAdapterConnectionState["Unknown"] = 0] = "Unknown";
        DeviceOfAdapterConnectionState[DeviceOfAdapterConnectionState["Connected"] = 1] = "Connected";
        DeviceOfAdapterConnectionState[DeviceOfAdapterConnectionState["Disconnected"] = 2] = "Disconnected";
    })(DeviceOfAdapterConnectionState = enums.DeviceOfAdapterConnectionState || (enums.DeviceOfAdapterConnectionState = {}));
    enums.DayOfWeek = dal_constants_1.DalConstants.DayOfWeek;
    enums.AccessReportFilterAccessResultType = dal_constants_1.DalConstants.AccessReportFilterAccessResultType;
    enums.DayOfWeekForWorking = dal_constants_1.DalConstants.DayOfWeekForWorking;
    let ValidationErrorCode;
    (function (ValidationErrorCode) {
        ValidationErrorCode[ValidationErrorCode["ENUM_MISMATCH"] = 0] = "ENUM_MISMATCH";
        ValidationErrorCode[ValidationErrorCode["MAXIMUM"] = 1] = "MAXIMUM";
        ValidationErrorCode[ValidationErrorCode["MAXIMUM_EXCLUSIVE"] = 2] = "MAXIMUM_EXCLUSIVE";
        ValidationErrorCode[ValidationErrorCode["MINIMUM"] = 3] = "MINIMUM";
        ValidationErrorCode[ValidationErrorCode["MINIMUM_EXCLUSIVE"] = 4] = "MINIMUM_EXCLUSIVE";
        ValidationErrorCode[ValidationErrorCode["MULTIPLE_OF"] = 5] = "MULTIPLE_OF";
        ValidationErrorCode[ValidationErrorCode["INVALID_TYPE"] = 6] = "INVALID_TYPE";
        ValidationErrorCode[ValidationErrorCode["ARRAY_LENGTH_LONG"] = 7] = "ARRAY_LENGTH_LONG";
        ValidationErrorCode[ValidationErrorCode["ARRAY_LENGTH_SHORT"] = 8] = "ARRAY_LENGTH_SHORT";
        ValidationErrorCode[ValidationErrorCode["MAX_LENGTH"] = 9] = "MAX_LENGTH";
        ValidationErrorCode[ValidationErrorCode["MIN_LENGTH"] = 10] = "MIN_LENGTH";
        ValidationErrorCode[ValidationErrorCode["MAX_PROPERTIES"] = 11] = "MAX_PROPERTIES";
        ValidationErrorCode[ValidationErrorCode["MIN_PROPERTIES"] = 12] = "MIN_PROPERTIES";
        ValidationErrorCode[ValidationErrorCode["RANGE"] = 13] = "RANGE";
        ValidationErrorCode[ValidationErrorCode["REQUIRED"] = 14] = "REQUIRED";
        ValidationErrorCode[ValidationErrorCode["NOT_FOUND"] = 15] = "NOT_FOUND";
        ValidationErrorCode[ValidationErrorCode["REGEX"] = 16] = "REGEX";
        ValidationErrorCode[ValidationErrorCode["INVALID_VALUE"] = 17] = "INVALID_VALUE";
        ValidationErrorCode[ValidationErrorCode["ARRAY_EMPTY"] = 18] = "ARRAY_EMPTY";
        ValidationErrorCode[ValidationErrorCode["CONTRADICTION"] = 19] = "CONTRADICTION";
        ValidationErrorCode[ValidationErrorCode["MUST_BE_UNIQUE"] = 20] = "MUST_BE_UNIQUE";
        ValidationErrorCode[ValidationErrorCode["NOT_SINGLE_KEY"] = 21] = "NOT_SINGLE_KEY";
    })(ValidationErrorCode = enums.ValidationErrorCode || (enums.ValidationErrorCode = {}));
    let ArmonApiErrorCode;
    (function (ArmonApiErrorCode) {
        ArmonApiErrorCode[ArmonApiErrorCode["UNHANDLED_ERROR"] = 20] = "UNHANDLED_ERROR";
        ArmonApiErrorCode[ArmonApiErrorCode["UNAUTHORIZED_INSTANT_PERMISSION_REQUEST"] = 21] = "UNAUTHORIZED_INSTANT_PERMISSION_REQUEST";
        ArmonApiErrorCode[ArmonApiErrorCode["UNAUTHORIZED_API_ACCESS"] = 22] = "UNAUTHORIZED_API_ACCESS";
        ArmonApiErrorCode[ArmonApiErrorCode["CONTROL_PANEL_NOT_CONNECTED"] = 23] = "CONTROL_PANEL_NOT_CONNECTED";
        ArmonApiErrorCode[ArmonApiErrorCode["USER_NOT_FOUND"] = 24] = "USER_NOT_FOUND";
    })(ArmonApiErrorCode = enums.ArmonApiErrorCode || (enums.ArmonApiErrorCode = {}));
    let HttpStatusCode;
    (function (HttpStatusCode) {
        HttpStatusCode[HttpStatusCode["SUCCESS"] = 200] = "SUCCESS";
        HttpStatusCode[HttpStatusCode["REDIRECT"] = 302] = "REDIRECT";
        HttpStatusCode[HttpStatusCode["BAD_REQUEST"] = 400] = "BAD_REQUEST";
        HttpStatusCode[HttpStatusCode["UNAUTHORIZED_ACCESS"] = 401] = "UNAUTHORIZED_ACCESS";
        HttpStatusCode[HttpStatusCode["PAYMENT_REQUIRED"] = 402] = "PAYMENT_REQUIRED";
        HttpStatusCode[HttpStatusCode["FORBIDDEN"] = 403] = "FORBIDDEN";
        HttpStatusCode[HttpStatusCode["NOT_FOUND"] = 404] = "NOT_FOUND";
        HttpStatusCode[HttpStatusCode["METHOD_NOT_ALLOWED"] = 405] = "METHOD_NOT_ALLOWED";
        HttpStatusCode[HttpStatusCode["TIMEOUT"] = 408] = "TIMEOUT";
        HttpStatusCode[HttpStatusCode["CONFLICT"] = 409] = "CONFLICT";
        HttpStatusCode[HttpStatusCode["GONE"] = 410] = "GONE";
        HttpStatusCode[HttpStatusCode["UNAUTHORIZED_SNAPSHOT_ACCESS"] = 411] = "UNAUTHORIZED_SNAPSHOT_ACCESS";
        HttpStatusCode[HttpStatusCode["PRECONDITION_FAILED"] = 412] = "PRECONDITION_FAILED";
        HttpStatusCode[HttpStatusCode["FAILED_DEPENDENCY"] = 424] = "FAILED_DEPENDENCY";
        HttpStatusCode[HttpStatusCode["TOO_MANY_REQUEST"] = 429] = "TOO_MANY_REQUEST";
        HttpStatusCode[HttpStatusCode["INTERNAL_ERROR"] = 500] = "INTERNAL_ERROR";
        HttpStatusCode[HttpStatusCode["TABLET_DEVICE_NOT_CONNECTED"] = 601] = "TABLET_DEVICE_NOT_CONNECTED";
        HttpStatusCode[HttpStatusCode["TABLET_DEVICE_NOT_APPROVED"] = 602] = "TABLET_DEVICE_NOT_APPROVED";
        HttpStatusCode[HttpStatusCode["VISITOR_APPROVAL_TIMEOUT"] = 603] = "VISITOR_APPROVAL_TIMEOUT";
        HttpStatusCode[HttpStatusCode["TABLET_SEQUENCE_INVALID_RESPONSE"] = 604] = "TABLET_SEQUENCE_INVALID_RESPONSE";
        HttpStatusCode[HttpStatusCode["QR_CODE_READ_TIMEOUT"] = 605] = "QR_CODE_READ_TIMEOUT";
        HttpStatusCode[HttpStatusCode["QR_CODE_READ_CANCELLED"] = 606] = "QR_CODE_READ_CANCELLED";
        HttpStatusCode[HttpStatusCode["INVALID_ACCESS_CONTROL_POINT_RIGHTS"] = 829] = "INVALID_ACCESS_CONTROL_POINT_RIGHTS";
        HttpStatusCode[HttpStatusCode["VISITOR_REGISTRATION_PARK_SLOT_IS_FULL"] = 830] = "VISITOR_REGISTRATION_PARK_SLOT_IS_FULL";
        HttpStatusCode[HttpStatusCode["VISITOR_PREREGISTRATION_PARK_SLOT_COULD_BE_FULL"] = 831] = "VISITOR_PREREGISTRATION_PARK_SLOT_COULD_BE_FULL";
        HttpStatusCode[HttpStatusCode["VISITOR_NEW_VISIT_FIELD_ERROR"] = 832] = "VISITOR_NEW_VISIT_FIELD_ERROR";
        HttpStatusCode[HttpStatusCode["VISITOR_PREREGISTER_FIELD_ERROR"] = 833] = "VISITOR_PREREGISTER_FIELD_ERROR";
        HttpStatusCode[HttpStatusCode["REGION_DELETE_DEPENDENCY"] = 834] = "REGION_DELETE_DEPENDENCY";
        HttpStatusCode[HttpStatusCode["USER_PROFILE_MISSING_EMAIL_FIELDS"] = 835] = "USER_PROFILE_MISSING_EMAIL_FIELDS";
        HttpStatusCode[HttpStatusCode["USER_PROFILE_MISSING_PHONENUMBER_FIELDS"] = 836] = "USER_PROFILE_MISSING_PHONENUMBER_FIELDS";
    })(HttpStatusCode = enums.HttpStatusCode || (enums.HttpStatusCode = {}));
    let MultiFactorHttpsStatusCodes;
    (function (MultiFactorHttpsStatusCodes) {
        MultiFactorHttpsStatusCodes[MultiFactorHttpsStatusCodes["AUTH_REQ"] = 837] = "AUTH_REQ";
        MultiFactorHttpsStatusCodes[MultiFactorHttpsStatusCodes["TOKEN_NOT_VERIFIED"] = 838] = "TOKEN_NOT_VERIFIED";
        MultiFactorHttpsStatusCodes[MultiFactorHttpsStatusCodes["BLOCKED_USER"] = 839] = "BLOCKED_USER";
        MultiFactorHttpsStatusCodes[MultiFactorHttpsStatusCodes["TOKEN_EXPIRED"] = 840] = "TOKEN_EXPIRED";
        MultiFactorHttpsStatusCodes[MultiFactorHttpsStatusCodes["OUTDATED_APP"] = 841] = "OUTDATED_APP";
    })(MultiFactorHttpsStatusCodes = enums.MultiFactorHttpsStatusCodes || (enums.MultiFactorHttpsStatusCodes = {}));
    enums.OrganizationEmailAddressType = dal_constants_1.DalConstants.OrganizationEmailAddressType;
    enums.DataFieldType = dal_constants_1.DalConstants.DataFieldType;
    enums.PPermissionHistoryActionType = dal_constants_1.DalConstants.PPermissionHistoryActionType;
    enums.ArmonApplicationModule = dal_constants_1.DalConstants.ArmonApplicationModule;
    enums.FormFieldType = dal_constants_1.DalConstants.FormFieldType;
    enums.CheckboxFormFieldType = dal_constants_1.DalConstants.CheckboxFormFieldType;
    enums.TextFormFieldType = dal_constants_1.DalConstants.TextFormFieldType;
    enums.SelectFormFieldType = dal_constants_1.DalConstants.SelectFormFieldType;
    enums.FormTypeaheadSearchFilterOptionType = dal_constants_1.DalConstants.FormTypeaheadSearchFilterOptionType;
    enums.CredentialType = dal_constants_1.DalConstants.CredentialType;
    enums.OrganizationUsernamePolicy = dal_constants_1.DalConstants.OrganizationUsernamePolicy;
    enums.OrganizationFormType = dal_constants_1.DalConstants.OrganizationFormType;
    enums.OrganizationFormFieldDataType = dal_constants_1.DalConstants.OrganizationFormFieldDataType;
    enums.OrganizationFormFieldType = dal_constants_1.DalConstants.OrganizationFormFieldType;
    enums.CardActivityTimelineItemType = dal_constants_1.DalConstants.CardActivityTimelineItemType;
    let TerminalConnectionStatusType;
    (function (TerminalConnectionStatusType) {
        TerminalConnectionStatusType[TerminalConnectionStatusType["Connected"] = 1] = "Connected";
        TerminalConnectionStatusType[TerminalConnectionStatusType["Lost"] = 2] = "Lost";
    })(TerminalConnectionStatusType = enums.TerminalConnectionStatusType || (enums.TerminalConnectionStatusType = {}));
    enums.TerminalConnectionStatus = dal_constants_1.DalConstants.TerminalConnectionStatus;
    let DashboardCardItemType;
    (function (DashboardCardItemType) {
        DashboardCardItemType[DashboardCardItemType["ActivityTimeline"] = 1] = "ActivityTimeline";
        DashboardCardItemType[DashboardCardItemType["AccessAttemptResults"] = 2] = "AccessAttemptResults";
        DashboardCardItemType[DashboardCardItemType["RemoteAccessGrantedAccessControlPoints"] = 3] = "RemoteAccessGrantedAccessControlPoints";
        DashboardCardItemType[DashboardCardItemType["ReportTemplates"] = 4] = "ReportTemplates";
    })(DashboardCardItemType = enums.DashboardCardItemType || (enums.DashboardCardItemType = {}));
    enums.AccessLogReason = dal_constants_1.DalConstants.AccessLogReason;
    enums.IdentityStatusType = dal_constants_1.DalConstants.IdentityStatusType;
    enums.StatusSensorState = dal_constants_1.DalConstants.StatusSensorState;
    enums.StatusSensorReason = dal_constants_1.DalConstants.StatusSensorReason;
    enums.CounterSensorState = dal_constants_1.DalConstants.CounterSensorState;
    enums.DryContactType = dal_constants_1.DalConstants.DryContactType;
    enums.DryContactTypeV2 = dal_constants_1.DalConstants.DryContactTypeV2;
    enums.TamperSwitchState = dal_constants_1.DalConstants.TamperSwitchState;
    enums.RegionState = dal_constants_1.DalConstants.RegionState;
    enums.WorkPlanType = dal_constants_1.DalConstants.WorkPlanType;
    enums.VacationType = dal_constants_1.DalConstants.VacationType;
    enums.PacsWorkplanPeriodRoutineTypes = dal_constants_1.DalConstants.PacsWorkplanPeriodRoutineTypes;
    enums.PPermissionFilterStatus = dal_constants_1.DalConstants.PPermissionFilterStatus;
    enums.PPermissionStatus = dal_constants_1.DalConstants.PPermissionStatus;
    enums.PPermissionMaxValueBoundaryInterval = dal_constants_1.DalConstants.PPermissionMaxValueBoundaryInterval;
    enums.UserSelectionSessionType = dal_constants_1.DalConstants.UserSelectionSessionType;
    enums.UserSelectionSessionAction = dal_constants_1.DalConstants.UserSelectionSessionAction;
    enums.UserSelectionSessionFilterType = dal_constants_1.DalConstants.UserSelectionSessionFilterType;
    enums.AddRemoveAction = dal_constants_1.DalConstants.AddRemoveAction;
    enums.PredefinedPPermissionType = dal_constants_1.DalConstants.PredefinedPPermissionType;
    enums.PPermissionValidationErrorCodes = dal_constants_1.DalConstants.PPermissionValidationErrorCodes;
    enums.DeviceBrand = dal_constants_1.DalConstants.DeviceBrand;
    let WorkPlanValidationErrorCode;
    (function (WorkPlanValidationErrorCode) {
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["None"] = 0] = "None";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["NoDefinedDays"] = 1] = "NoDefinedDays";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["MultipleSameDay"] = 2] = "MultipleSameDay";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["InvalidStartEndTime"] = 3] = "InvalidStartEndTime";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["OverlappingBreaks"] = 4] = "OverlappingBreaks";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["NegativeWorkDuration"] = 5] = "NegativeWorkDuration";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["DuplicateName"] = 6] = "DuplicateName";
        WorkPlanValidationErrorCode[WorkPlanValidationErrorCode["DifferentAccessCheckType"] = 7] = "DifferentAccessCheckType";
    })(WorkPlanValidationErrorCode = enums.WorkPlanValidationErrorCode || (enums.WorkPlanValidationErrorCode = {}));
    enums.AccessLogTimeEstimation = dal_constants_1.DalConstants.AccessLogTimeEstimation;
    enums.AntiPassbackState = dal_constants_1.DalConstants.AntiPassbackState;
    let IPCMessageCommand;
    (function (IPCMessageCommand) {
        IPCMessageCommand[IPCMessageCommand["UpsertScheduledReport"] = 0] = "UpsertScheduledReport";
        IPCMessageCommand[IPCMessageCommand["RemoveScheduledReport"] = 1] = "RemoveScheduledReport";
        IPCMessageCommand[IPCMessageCommand["Notification"] = 2] = "Notification";
        IPCMessageCommand[IPCMessageCommand["RegisterNotification"] = 3] = "RegisterNotification";
        IPCMessageCommand[IPCMessageCommand["UnregisterNotification"] = 4] = "UnregisterNotification";
        IPCMessageCommand[IPCMessageCommand["KillSignal"] = 5] = "KillSignal";
    })(IPCMessageCommand = enums.IPCMessageCommand || (enums.IPCMessageCommand = {}));
    enums.UserAgentDeviceType = dal_constants_1.DalConstants.UserAgentDeviceType;
    let CheckServerAdminAccountResultType;
    (function (CheckServerAdminAccountResultType) {
        CheckServerAdminAccountResultType[CheckServerAdminAccountResultType["Valid"] = 1] = "Valid";
        CheckServerAdminAccountResultType[CheckServerAdminAccountResultType["WrongUsernameOrPassword"] = 2] = "WrongUsernameOrPassword";
        CheckServerAdminAccountResultType[CheckServerAdminAccountResultType["Expired"] = 3] = "Expired";
    })(CheckServerAdminAccountResultType = enums.CheckServerAdminAccountResultType || (enums.CheckServerAdminAccountResultType = {}));
    enums.UserActionCategory = dal_constants_1.DalConstants.UserActionCategory;
    enums.UserVisitorActionType = dal_constants_1.DalConstants.UserVisitorActionType;
    enums.UserMainActionType = dal_constants_1.DalConstants.UserMainActionType;
    enums.ListVisitState = dal_constants_1.DalConstants.ListVisitState;
    enums.SegmentType = dal_constants_1.DalConstants.SegmentType;
    enums.AccessControlPointState = dal_constants_1.DalConstants.AccessControlPointState;
    enums.OrganizationUserDefinedListType = dal_constants_1.DalConstants.OrganizationUserDefinedListType;
    enums.EmailTemplateType = dal_constants_1.DalConstants.EmailTemplateType;
    enums.AccessRuleAcceptStatus = dal_constants_1.DalConstants.AccessRuleAcceptStatus;
    enums.AccessRuleType = dal_constants_1.DalConstants.AccessRuleType;
    enums.ArmonControlPanelIntegrationType = dal_constants_1.DalConstants.ArmonControlPanelIntegrationType;
    enums.AdapterType = dal_constants_1.DalConstants.AdapterType;
    enums.TerminalWarningLevel = dal_constants_1.DalConstants.TerminalWarningLevel;
    enums.TerminalWarningType = dal_constants_1.DalConstants.TerminalWarningType;
    enums.DevicePowerState = dal_constants_1.DalConstants.DevicePowerState;
    enums.TerminalEventType = dal_constants_1.DalConstants.TerminalEventType;
    enums.PacsNotificationType = dal_constants_1.DalConstants.PacsNotificationType;
    enums.SearchMethod = dal_constants_1.DalConstants.SearchMethod;
    enums.ServerToDeviceRPCMessageType = dal_constants_1.DalConstants.ServerToDeviceRPCMessageType;
    enums.CredentialCreateErrorReason = dal_constants_1.DalConstants.CredentialCreateErrorReason;
    enums.WorkPlanAccessCheckType = dal_constants_1.DalConstants.WorkPlanAccessCheckType;
    enums.EmployeeInfoSorting = dal_constants_1.DalConstants.EmployeeInfoSorting;
    enums.EmployeeCurrentStatusWarnings = dal_constants_1.DalConstants.EmployeeCurrentStatusWarnings;
    enums.WorkStatusFilter = dal_constants_1.DalConstants.WorkStatusFilter;
    enums.CredentialIndex = dal_constants_1.DalConstants.CredentialIndex;
    enums.TerminalAction = dal_constants_1.DalConstants.TerminalAction;
    enums.AuthMethod = dal_constants_1.DalConstants.AuthenticationMethod;
    enums.AuthGrantType = dal_constants_1.DalConstants.AuthGrantType;
    enums.ArmonProductCode = dal_constants_1.DalConstants.ArmonProductCode;
    enums.ErrorCode = restapi_1.ErrorCode;
    enums.VisitAnalysisVisitCountGenericFilterType = dal_constants_1.DalConstants.VisitAnalysisVisitCountGenericFilterType;
    let PPermissionUsageFactor;
    (function (PPermissionUsageFactor) {
        PPermissionUsageFactor[PPermissionUsageFactor["DailyPermissionUsageFactor"] = 1] = "DailyPermissionUsageFactor";
        PPermissionUsageFactor[PPermissionUsageFactor["HourlyPermissionUsageFactor"] = 60] = "HourlyPermissionUsageFactor";
    })(PPermissionUsageFactor = enums.PPermissionUsageFactor || (enums.PPermissionUsageFactor = {}));
    enums.PPermissionInsertRole = dal_constants_1.DalConstants.PPermissionInsertRole;
    enums.DeviceConnectionState = dal_constants_1.DalConstants.DeviceConnectionState;
    enums.PPermissionClaimProfile = dal_constants_1.DalConstants.PPermissionClaimProfile;
    enums.MonthlySummaryReportDateFilterGroup = dal_constants_1.DalConstants.MonthlySummaryReportDateFilterGroup;
    enums.PPermissionFilterSortType = dal_constants_1.DalConstants.PPermissionFilterSortType;
    enums.DurationInRegionSortType = dal_constants_1.DalConstants.DurationInRegionOverviewSortType;
    enums.DurationInRegionDetailSortType = dal_constants_1.DalConstants.DurationInRegionDetailSortType;
    enums.RegionReportSortType = dal_constants_1.DalConstants.RegionReportSortType;
    let DbActionType;
    (function (DbActionType) {
        DbActionType[DbActionType["Insert"] = 1] = "Insert";
        DbActionType[DbActionType["Update"] = 2] = "Update";
        DbActionType[DbActionType["Delete"] = 3] = "Delete";
    })(DbActionType = enums.DbActionType || (enums.DbActionType = {}));
    let SmsConfigType;
    (function (SmsConfigType) {
        SmsConfigType[SmsConfigType["IletiMerkezi"] = 1] = "IletiMerkezi";
        SmsConfigType[SmsConfigType["NetGsm"] = 2] = "NetGsm";
        SmsConfigType[SmsConfigType["MesajUssu"] = 3] = "MesajUssu";
        SmsConfigType[SmsConfigType["TurkTelekom"] = 4] = "TurkTelekom";
        SmsConfigType[SmsConfigType["Balaban"] = 5] = "Balaban";
        SmsConfigType[SmsConfigType["Armon"] = 6] = "Armon";
    })(SmsConfigType = enums.SmsConfigType || (enums.SmsConfigType = {}));
    let LogReceiveMethod;
    (function (LogReceiveMethod) {
        LogReceiveMethod[LogReceiveMethod["Instant"] = 1] = "Instant";
        LogReceiveMethod[LogReceiveMethod["OfflineLog"] = 2] = "OfflineLog";
        LogReceiveMethod[LogReceiveMethod["DeadLetter"] = 3] = "DeadLetter";
        LogReceiveMethod[LogReceiveMethod["Mobile"] = 4] = "Mobile";
        LogReceiveMethod[LogReceiveMethod["ManuelLog"] = 5] = "ManuelLog";
        LogReceiveMethod[LogReceiveMethod["Tablet"] = 6] = "Tablet";
        LogReceiveMethod[LogReceiveMethod["ExcelImport"] = 7] = "ExcelImport";
    })(LogReceiveMethod = enums.LogReceiveMethod || (enums.LogReceiveMethod = {}));
    let AmqpMessageCode;
    (function (AmqpMessageCode) {
        AmqpMessageCode[AmqpMessageCode["Empty"] = 1] = "Empty";
        AmqpMessageCode[AmqpMessageCode["RelcalculateFilteredPACSEmployees"] = 2] = "RelcalculateFilteredPACSEmployees";
    })(AmqpMessageCode = enums.AmqpMessageCode || (enums.AmqpMessageCode = {}));
    let HesCodeStatus;
    (function (HesCodeStatus) {
        HesCodeStatus[HesCodeStatus["Riskless"] = 1] = "Riskless";
        HesCodeStatus[HesCodeStatus["Risky"] = 2] = "Risky";
        HesCodeStatus[HesCodeStatus["NoRecord"] = 3] = "NoRecord";
        HesCodeStatus[HesCodeStatus["Error"] = 4] = "Error";
    })(HesCodeStatus = enums.HesCodeStatus || (enums.HesCodeStatus = {}));
    enums.GeoLocationType = dal_constants_1.DalConstants.GeoLocationType;
    let RemoveOrganizationUnitAction;
    (function (RemoveOrganizationUnitAction) {
        RemoveOrganizationUnitAction[RemoveOrganizationUnitAction["None"] = 1] = "None";
        RemoveOrganizationUnitAction[RemoveOrganizationUnitAction["MakeUsersPassive"] = 2] = "MakeUsersPassive";
        RemoveOrganizationUnitAction[RemoveOrganizationUnitAction["RemoveAccessRights"] = 3] = "RemoveAccessRights";
    })(RemoveOrganizationUnitAction = enums.RemoveOrganizationUnitAction || (enums.RemoveOrganizationUnitAction = {}));
    let AssaAbloyBatteryLevel;
    (function (AssaAbloyBatteryLevel) {
        AssaAbloyBatteryLevel[AssaAbloyBatteryLevel["OK"] = 100] = "OK";
        AssaAbloyBatteryLevel[AssaAbloyBatteryLevel["LOW"] = 20] = "LOW";
        AssaAbloyBatteryLevel[AssaAbloyBatteryLevel["EMPTY"] = 5] = "EMPTY";
    })(AssaAbloyBatteryLevel = enums.AssaAbloyBatteryLevel || (enums.AssaAbloyBatteryLevel = {}));
    let MKESyncOperation;
    (function (MKESyncOperation) {
        MKESyncOperation[MKESyncOperation["Added"] = 1] = "Added";
        MKESyncOperation[MKESyncOperation["Sent"] = 2] = "Sent";
        MKESyncOperation[MKESyncOperation["MarkedAsRead"] = 3] = "MarkedAsRead";
    })(MKESyncOperation = enums.MKESyncOperation || (enums.MKESyncOperation = {}));
    let AutoShiftLogFormationType;
    (function (AutoShiftLogFormationType) {
        AutoShiftLogFormationType[AutoShiftLogFormationType["VirtualAccessQR"] = 1] = "VirtualAccessQR";
        AutoShiftLogFormationType[AutoShiftLogFormationType["MobileCheckIn"] = 2] = "MobileCheckIn";
        AutoShiftLogFormationType[AutoShiftLogFormationType["RemoteAccessWithQR"] = 3] = "RemoteAccessWithQR";
    })(AutoShiftLogFormationType = enums.AutoShiftLogFormationType || (enums.AutoShiftLogFormationType = {}));
    let MultifactorAuthenticationVerificationMethod;
    (function (MultifactorAuthenticationVerificationMethod) {
        MultifactorAuthenticationVerificationMethod[MultifactorAuthenticationVerificationMethod["SMS"] = 1] = "SMS";
        MultifactorAuthenticationVerificationMethod[MultifactorAuthenticationVerificationMethod["EMAIL"] = 2] = "EMAIL";
    })(MultifactorAuthenticationVerificationMethod = enums.MultifactorAuthenticationVerificationMethod || (enums.MultifactorAuthenticationVerificationMethod = {}));
    let MultifactorAuthenticationOption;
    (function (MultifactorAuthenticationOption) {
        MultifactorAuthenticationOption[MultifactorAuthenticationOption["DISABLE"] = 1] = "DISABLE";
        MultifactorAuthenticationOption[MultifactorAuthenticationOption["OPTIONAL"] = 2] = "OPTIONAL";
        MultifactorAuthenticationOption[MultifactorAuthenticationOption["REQUIRED"] = 3] = "REQUIRED";
    })(MultifactorAuthenticationOption = enums.MultifactorAuthenticationOption || (enums.MultifactorAuthenticationOption = {}));
    let PostgresErrorCodes;
    (function (PostgresErrorCodes) {
        PostgresErrorCodes["INVALID_ACCESS_CONTROL_POINT_RIGHTS"] = "P0001";
    })(PostgresErrorCodes = enums.PostgresErrorCodes || (enums.PostgresErrorCodes = {}));
})(enums = exports.enums || (exports.enums = {}));
