"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serverRestartThresholdInSeconds = exports.ArmonHeaders = exports.ACCOUNT_PASSWORD_MAX_LENGTH = exports.ACCOUNT_PASSWORD_MIN_LENGTH = exports.retryNotificationErrorCodes = exports.safeNotificationErrorCodes = exports.armonBase64Logo = exports.ReportTemplatesWithoutPDF = exports.pushNotificationInvalidServerResponseError = exports.pushNotificationInvalidRegistrationError = exports.pushNotificationMissingRegistrationError = exports.maxRequeueAttemptCount = exports.maxAttemptCountForRequeueNotification = exports.reportExpireTime = exports.ServiceNames = exports.constFileNames = exports.armonPublicKey = void 0;
const app_enums_1 = require("./app.enums");
const dal_constants_1 = require("./dal/dal.constants");
exports.armonPublicKey = "BH88QHS2nKyCdmPhygloC42sBssw8J5abri3Uxh7KTW9Bd/4tqwOBTb+ywlM9j+GPrAkhZMt/rE3I5Nynwn9M7s=";
exports.constFileNames = {
    serverBasedHookScriptsFileName: "server-hook.js",
};
var ServiceNames;
(function (ServiceNames) {
    ServiceNames["WebApplication"] = "armonwebapp";
    ServiceNames["ReportService"] = "armonreport";
    ServiceNames["NotificationService"] = "armonnotification";
    ServiceNames["PACSService"] = "armonpacs";
    ServiceNames["PGRedisService"] = "armonpgredis";
    ServiceNames["PGRabbitService"] = "armonpgrabbit";
    ServiceNames["PGMaintenanceService"] = "armonpgmaintenance";
    ServiceNames["MonitorService"] = "armonmonitor";
    ServiceNames["Integration"] = "armonintegration";
    ServiceNames["Tablet"] = "armontablet";
    ServiceNames["Custom"] = "armoncustom";
})(ServiceNames = exports.ServiceNames || (exports.ServiceNames = {}));
exports.reportExpireTime = 7 * 24 * 60 * 60 * 1000;
exports.maxAttemptCountForRequeueNotification = 5;
exports.maxRequeueAttemptCount = 5;
exports.pushNotificationMissingRegistrationError = "MissingRegistration";
exports.pushNotificationInvalidRegistrationError = "InvalidRegistration";
exports.pushNotificationInvalidServerResponseError = "InvalidServerResponse";
exports.ReportTemplatesWithoutPDF = [
    dal_constants_1.DalConstants.ReportTemplateType.RegionState,
    dal_constants_1.DalConstants.ReportTemplateType.PACSWorkingDetailsForSingleEmployeeDateRange,
    dal_constants_1.DalConstants.ReportTemplateType.FirstAndLastAccessLogs,
    dal_constants_1.DalConstants.ReportTemplateType.FirstAndLastAccessLogsForSingleUser,
    dal_constants_1.DalConstants.ReportTemplateType.InstantAttendanceStatus,
    dal_constants_1.DalConstants.ReportTemplateType.PACSWorkingDetailsForEmployeesInDateRange,
    dal_constants_1.DalConstants.ReportTemplateType.DurationInRegionReportOverview,
    dal_constants_1.DalConstants.ReportTemplateType.EntryByUnit,
];
exports.armonBase64Logo = "";
exports.safeNotificationErrorCodes = [
    app_enums_1.enums.ErrorCode.NotReadyToAccess,
    app_enums_1.enums.ErrorCode.DataNotFound,
    app_enums_1.enums.ErrorCode.DataNotFoundInNotificationTable,
    app_enums_1.enums.ErrorCode.NoOrganizaitionSmtpSettings,
    app_enums_1.enums.ErrorCode.NoOrganizaitionSmsSettings,
    app_enums_1.enums.ErrorCode.NoFirebasePrivateKey,
    app_enums_1.enums.ErrorCode.EmailTemplateNotFound,
    app_enums_1.enums.ErrorCode.UserHasNoNotificationToken,
    app_enums_1.enums.ErrorCode.UserhasNoEmailAddress,
    app_enums_1.enums.ErrorCode.UserHasNoPhoneNumber,
    app_enums_1.enums.ErrorCode.InvalidReceiver,
    app_enums_1.enums.ErrorCode.MissingReceiver,
    app_enums_1.enums.ErrorCode.InvalidMediumToSend,
    app_enums_1.enums.ErrorCode.NoHuaweiPushSettings,
    app_enums_1.enums.ErrorCode.DelayedExchangePluginIsNotAvailable,
    app_enums_1.enums.ErrorCode.RpcCallTimeout,
    app_enums_1.enums.ErrorCode.MissingExchange,
    app_enums_1.enums.ErrorCode.InvalidPushNotificationMedium,
    app_enums_1.enums.ErrorCode.InsufficientSmsBalance,
    app_enums_1.enums.ErrorCode.InvalidReceiverOnSms,
    app_enums_1.enums.ErrorCode.MessageSizeExceeded,
    app_enums_1.enums.ErrorCode.EmptyText,
    app_enums_1.enums.ErrorCode.CustomNotificationChannelError,
];
exports.retryNotificationErrorCodes = [
    app_enums_1.enums.ErrorCode.ConnectionError,
    app_enums_1.enums.ErrorCode.ThisNotificationIsAlreadyProcessingInNotificationService,
    app_enums_1.enums.ErrorCode.NoAmqpConnectionOrChannel,
    app_enums_1.enums.ErrorCode.SmtpServerFailed,
    app_enums_1.enums.ErrorCode.PushNotificationServerFailed,
    app_enums_1.enums.ErrorCode.InCorrectMembershipInfoOrMessageContainsNonEnglishCharacterInSms,
    app_enums_1.enums.ErrorCode.SameSmsTriedToSendAgain,
    app_enums_1.enums.ErrorCode.SmsServerTemporaryInAvailable,
    app_enums_1.enums.ErrorCode.Unknown,
];
exports.ACCOUNT_PASSWORD_MIN_LENGTH = 6;
exports.ACCOUNT_PASSWORD_MAX_LENGTH = 32;
exports.ArmonHeaders = {
    Authorization: "authorization",
    MobileInstallId: "x-mobile-install-id",
    UserAgent: "user-agent",
    UserAgentId: "armon-agent-id",
    ModelType: "modeltype",
    ReqType: "reqtype",
    Waiting: "waiting",
    X_Armon_DeviceId: "x-armon-device-id",
    X_Armon_ClientId: "x-armon-client-id",
    X_Armon_Timestamp: "x-armon-timestamp",
    X_Armon_Signature: "x-armon-signature",
    X_Armon_OrganizationId: "x-armon-organization-id",
    ViperSoftwareVersion: "Viper-Software-Version",
};
exports.serverRestartThresholdInSeconds = 180;
