"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_visitor_v1_model_1 = require("../api.visitor.v1.model");
module.exports.listRegistrationPointsDetailed = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForListVisitorWriteRequest)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.accessVisitor.listRegistrationPointsDetailed(organizationId, authResult.userId);
    res.json({
        items: dbResult,
    });
});
module.exports.listRegistrationPoints = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForListVisitorWriteRequest)(req, organizationId);
    let request = new api_visitor_v1_model_1.RestVisitorApiV1.ListVisitorRegistrationPointRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessVisitor.listRegistrationPoints(organizationId, request, authResult.userId);
    res.json({
        take: request.pagination.take,
        skip: request.pagination.skip,
        total: dbResult.total,
        items: dbResult.items,
    });
});
module.exports.upsertRegistrationPoint = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForListVisitorWriteRequest)(req, organizationId);
    let request = new api_visitor_v1_model_1.RestVisitorApiV1.UpsertVisitorRegistrationPointRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessVisitor.upsertRegistrationPoint(organizationId, authResult.userId, {
        id: request.id,
        accessControlPointIds: request.accessControlPointIds,
        name: request.name,
    });
    res.json(dbResult);
});
module.exports.removeRegistrationPoint = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let visitorRegistrationPointId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.vid.value, "visitorRegistrationPointId");
    let authResult = (0, api_securityhelper_1.authorizeForListVisitorWriteRequest)(req, organizationId);
    await dal_manager_1.dbManager.accessVisitor.removeRegistrationPoint(organizationId, visitorRegistrationPointId);
    res.json();
});
module.exports.getRegistrationPoint = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let visitorRegistrationPointId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.vid.value, "visitorRegistrationPointId");
    let authResult = (0, api_securityhelper_1.authorizeForListVisitorWriteRequest)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.accessVisitor.getRegistrationPoint(organizationId, visitorRegistrationPointId);
    res.json(dbResult);
});
