"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const app_constants_1 = require("../../../../app.constants");
const app_enums_1 = require("../../../../app.enums");
const dal_access_error_1 = require("../../../../dal/access/dal.access.error");
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_error_1 = require("../../../api.error");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
module.exports.upsertUserProfile = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let jwt = req.auth_token;
    let request = req.body;
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessUser.upsertUserProfile(jwt.getOrganizationId(), jwt.userId, request, trx);
    }, jwt.userId, jwt.getOrganizationId());
    res.json();
});
module.exports.activateMfa = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const jwt = req.auth_token;
    const mfaSettings = req.body.mfaSettings;
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessUser.updateUserProfileMfaSettings(jwt.getOrganizationId(), jwt.userId, mfaSettings, trx);
    }, jwt.userId, jwt.getOrganizationId());
    res.json();
});
module.exports.getUserProfile = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let jwt = req.auth_token;
    let dbResult = await dal_manager_1.dbManager.accessUser.getUserProfile(jwt.getOrganizationId(), jwt.userId);
    res.json(dbResult);
});
module.exports.getUserProfileThumbnail = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let jwt = req.auth_token;
    let thumbnail = await dal_manager_1.dbManager.accessUser.getUserProfileThumbnail(jwt.getOrganizationId(), jwt.userId);
    res.json({
        thumbnail: thumbnail,
    });
});
module.exports.upsertUserProfileThumbnail = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let jwt = req.auth_token;
    let thumbnail = req.body.data ? req.body.data : null;
    if (thumbnail) {
        const validatorHelper = new api_validatorhelper_1.ValidatorHelper();
        (0, api_validatorhelper_1.validateThumbnail)(thumbnail, validatorHelper, true);
    }
    else {
        throw (0, api_error_1.generateBadRequestApiError)({
            message: "Thumbnail data is required",
        });
    }
    let dbResult = await dal_manager_1.dbManager.accessUser.upsertUserProfileThumbnail(jwt.getOrganizationId(), jwt.userId, thumbnail);
    if (!dbResult)
        (0, dal_access_error_1.throwDbAccessNotFoundError)("userprofile not found");
    res.json({});
});
module.exports.listUserDeviceTokens = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let jwt = req.auth_token;
    let dbResult = await dal_manager_1.dbManager.accessUser.listUserActiveDevices(jwt.getOrganizationId(), jwt.userId);
    res.json(dbResult);
});
module.exports.revokeUserDeviceToken = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let deviceTokenId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.did.value, "deviceTokenId");
    let jwt = req.auth_token;
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessUser.revokeUserDeviceToken(jwt.getOrganizationId(), deviceTokenId, trx);
    }, jwt.userId, jwt.getOrganizationId());
    res.json();
});
module.exports.uploadMobileDeviceDetails = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let jwt = req.auth_token;
    if (!req.body.publicKey) {
        res.writeHead(400, "invalid publickey");
        return res.end();
    }
    try {
        await dal_manager_1.dbManager.accessOAuth.upsertMobileClientDetails(organizationId, jwt.userId, jwt.tokenId, req.body.clientId, req.body.publicKey, req.body.notificationToken, req.body.notificationTokenType || app_enums_1.enums.NotificationTokenType.FireBase, req.header(app_constants_1.ArmonHeaders.MobileInstallId), req.header(app_constants_1.ArmonHeaders.UserAgent));
    }
    catch (error) {
        const symbolKey = Reflect.ownKeys(error).find((key) => key.toString() === "Symbol(message)");
        if (error[symbolKey].includes(app_enums_1.enums.ErrorCode.OneTimeAssignableCredential.toString())) {
            (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.IDENTITY.NONRETURNABLE_CREDENTIAL");
        }
        else if (error[symbolKey].includes(app_enums_1.enums.ErrorCode.CredentialToInsertAlreadyExists.toString())) {
            (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.IDENTITY.DUPLICATECREDENTIAL");
        }
        throw error;
    }
    res.json();
});
