"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const bluebird_1 = require("bluebird");
const uuid = __importStar(require("uuid"));
const app_enums_1 = require("../../../../app.enums");
const app_filesystem_1 = require("../../../../app.filesystem");
const business_licence_1 = require("../../../../business/business.licence");
const dal_access_error_1 = require("../../../../dal/access/dal.access.error");
const dal_manager_1 = require("../../../../dal/dal.manager");
const messageBroker_server_to_device_pub_1 = require("../../../../messageBroker/messageBroker.server-to-device.pub");
const messagebroker_models_1 = require("../../../../messageBroker/messagebroker.models");
const api_error_1 = require("../../../api.error");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_user_v1_models_1 = require("../api.user.v1.models");
const app_constants_1 = require("../../../../app.constants");
const business_log_1 = require("../../../../business/business.log");
const dal_memcache_1 = require("../../../../dal/access/dal.memcache");
const predefined_permissions_1 = require("../../../../dal/db/predefined/predefined.permissions");
const messageBroker_notification_pub_1 = require("../../../../messageBroker/messageBroker.notification.pub");
const dal_access_psql_log_1 = require("../../../../dal/access/psql/dal.access.psql.log");
const api_arvento_1 = require("../../../../business/arvento/api.arvento");
const luxon_1 = require("luxon");
module.exports.getSystemReadyCheckState = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    res.json();
});
module.exports.getOrganizationDefFile = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.accessSystem.getOrganizationDefinitionFileContentV3(organizationId);
    let licenceBusiness = new business_licence_1.BusinessOrganizationDefinitionFile(organizationId);
    let file = await licenceBusiness.createOrganizationDefinitionFile("3");
    let data = Buffer.from(JSON.stringify(file, null, 4));
    res.writeHead(200, {
        "Content-Type": "text/plain",
        "Content-disposition": "attachment;filename=organization." + file.content.id + ".lic",
        "Content-Length": data.length,
    });
    res.end(data);
});
module.exports.uploadOrganizationLicenceFile = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let organizationBasic = await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(organizationId);
    let authResult = (0, api_securityhelper_1.authorizeForSystemWrite)(req, organizationId);
    let file = req.swagger.params.upfile.value;
    try {
        let licenceBusiness = new business_licence_1.BusinessOrganizationLicence(organizationBasic.publicKey, organizationBasic.privateKey, file.buffer);
        await licenceBusiness.handleLicenceFile();
        res.json({});
    }
    catch (error) {
        if (error instanceof api_error_1.ApiTranslatedErrorStructure || error instanceof dal_access_error_1.DbAccessError) {
            throw error;
        }
        else {
            (0, dal_access_error_1.throwDbAccessBadRequestError)(error);
        }
    }
});
module.exports.getOrganizationSummary = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
        return await dal_manager_1.dbManager.accessOrganization.getOrganizationSummary(organizationId, trx);
    });
    res.json(dbResult);
});
module.exports.addOrganizationFeedback = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const jwt = req.auth_token;
    const request = new api_user_v1_models_1.RestUserApiV1.InsertFeedbackRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const { instanceData, notificationEventId, feedbackId } = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        const feedbackId = await dal_manager_1.dbManager.accessSystem.addOrganizationFeedback(organizationId, request, jwt.userId);
        const systemAdminIds = await dal_manager_1.dbManager.accessUser.listUsersWithPermission(organizationId, predefined_permissions_1.Permissions.system.getFeedbackWrite());
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.NewFeedback, trx);
        const instanceData = {
            f: feedbackId,
            receiverUserIds: systemAdminIds,
        };
        const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            trx,
            instanceData,
        });
        return { notificationEventId, instanceData, feedbackId };
    }, jwt.userId, organizationId);
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        v: "1",
        n: 1,
        a: 0,
        i: notificationEventId,
        o: organizationId,
        d: instanceData,
    });
    res.json(feedbackId);
});
module.exports.updateOrganizationFeedback = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const feedbackId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.fid.value, "feedbackId");
    const authResult = (0, api_securityhelper_1.authorizeForSystemFeedbackWrite)(req, organizationId);
    const request = new api_user_v1_models_1.RestUserApiV1.FeedbackUpdateRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const { notificationEventId, instanceData } = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessSystem.updateOrganizationFeedback(organizationId, feedbackId, request, authResult.userId);
        const feedback = await dal_manager_1.dbManager.accessSystem.getOrganizationFeedback(organizationId, feedbackId);
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.FeedbackUpdate, trx);
        const instanceData = {
            f: feedbackId,
            receiverUserIds: [feedback.requestUserId],
        };
        const notificationEventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            trx,
            instanceData,
        });
        return { notificationEventId, instanceData };
    });
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        v: "1",
        n: 1,
        a: 0,
        i: notificationEventId,
        o: organizationId,
        d: instanceData,
    });
    res.json();
});
module.exports.getOrganizationFeedback = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let feedbackId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.fid.value, "feedbackId");
    let authResult = (0, api_securityhelper_1.authorizeForSystemFeedbackRead)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.accessSystem.getOrganizationFeedback(organizationId, feedbackId);
    res.json(dbResult);
});
module.exports.listSelfOrganizationFeedback = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let jwt = req.auth_token;
    let request = new api_user_v1_models_1.RestUserApiV1.ListFeedbackRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    request.requestUserId = jwt.userId;
    let dbResult = await dal_manager_1.dbManager.accessSystem.listOrganizationFeedback(organizationId, request);
    res.json(dbResult);
});
module.exports.listOrganizationFeedback = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.ListFeedbackRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessSystem.listOrganizationFeedback(organizationId, request);
    res.json(dbResult);
});
module.exports.listFloorPlan = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.FloorPlanListFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessSystem.getOrganizationFloorPlanList(organizationId, request);
    res.json(dbResult);
});
module.exports.getFloorPlanById = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let floorPlanId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "floorPlanId");
    (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let authResult = (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.accessSystem.getOrganizationFloorPlanById(organizationId, floorPlanId);
    res.json(dbResult);
});
module.exports.postRemoteControlCommand = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const remoteControlCommand = new api_user_v1_models_1.RestUserApiV1.RemoteControlCommand(req.body, new api_validatorhelper_1.ValidatorHelper());
    const jwt = req.auth_token;
    const userId = remoteControlCommand.userId ?? jwt.userId;
    const accessPointQRCodeMapping = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessControlPoint.getQRCodeForAccessPoint({
            id: remoteControlCommand.accessControlPointId,
            organizationId,
            trx,
        });
    }, userId, organizationId);
    if (accessPointQRCodeMapping) {
        remoteControlCommand.accessControlPointId = accessPointQRCodeMapping.accessPointId;
        remoteControlCommand.direction = accessPointQRCodeMapping.config.direction;
    }
    const remoteAccessCommandStructure = await dal_manager_1.dbManager.accessSystem.getRemoteAccessCommandStructure(organizationId, userId, remoteControlCommand.accessControlPointId, remoteControlCommand.qr);
    if (!remoteAccessCommandStructure) {
        (0, dal_access_error_1.throwDbAccessNotFoundErrorTr)("ERRORS.IDENTITY.NO_ACCESS_RIGHT_FOR_GIVEN_ACCESS_POINT", null, true);
    }
    if (remoteAccessCommandStructure.deviceId) {
        const result = new Promise((resolve, reject) => {
            messageBroker_server_to_device_pub_1.amqpServerToDevicePub.sendToRpcQueue(remoteAccessCommandStructure.deviceId, {
                e: messagebroker_models_1.ServerToDeviceRPCMessageType.RemoteAccess,
                p: {
                    a: remoteControlCommand.accessControlPointId,
                    d: remoteControlCommand.direction,
                    o: userId,
                    iq: remoteControlCommand.qr ? true : false,
                },
            }, 30000, (err, success) => {
                if (err) {
                    res.status(404);
                    res.json((0, api_error_1.generateTimeoutApiError)(new bluebird_1.TimeoutError(err.message)));
                }
                else {
                    res.json({ result: "success" });
                    resolve(success);
                }
            });
        });
        await result.then(async (value) => {
            if (remoteControlCommand.qr) {
                await (0, dal_access_psql_log_1.assignAutoShift)(req.organizationId, {
                    credentialOwnerUserId: value.o,
                    generationTime: value.u,
                    redisCache: dal_manager_1.dbManager.accessRedisCache,
                    logId: value.id,
                });
            }
        });
    }
    else {
        if (await (0, business_log_1.insertVirtualACPAccessLog)(organizationId, {
            remoteAccessCommandStructure,
            direction: remoteControlCommand.direction ? remoteControlCommand.direction : app_enums_1.enums.libEnumsV2.AccessDirection.All,
            userId: userId,
            qr: remoteControlCommand.qr,
        })) {
            res.json({ result: "success" });
        }
        else {
            res.status(app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR);
            res.json((0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR, "Access Point Could Not Be Opened", null, true));
        }
    }
});
module.exports.markRemoteAccessGrantedAccessControlPointAsFavorited = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    new api_validatorhelper_1.ValidatorHelper().validateUUID("organizationId", false, req.swagger.params.oid.value).validateUUID("accessControlPointId", false, req.swagger.params.id.value).finalize();
    let organizationId = req.swagger.params.oid.value;
    let accessControlPointId = req.swagger.params.id.value;
    let option = req.swagger.params.option.value === true;
    res.json(await dal_manager_1.dbManager.accessAccessControlPoint.markRemoteAccessGrantedAccessControlPointAsFavorited(organizationId, (0, api_securityhelper_1.getUserIdFromToken)(req), accessControlPointId, option));
});
module.exports.setEmergencyState = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    new api_validatorhelper_1.ValidatorHelper().validateEnum("state", false, app_enums_1.enums.EmergencyState, req.body.state).finalize();
    let state = req.body.state;
    let jwt = (0, api_securityhelper_1.authorizeForSetEmergencyState)(req, organizationId);
    res.json({});
});
module.exports.sendMessage = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const { userId } = (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    const userSelectionSessionId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.sid.value, "userSelectionSessionId");
    const request = new api_user_v1_models_1.RestUserApiV1.SendMessageRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const { eventId, instanceData } = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        const userIds = await dal_manager_1.dbManager.accessUser.listAddedUsersOfSelectionSession(organizationId, userSelectionSessionId);
        const notificationId = await (0, dal_memcache_1.getCacheUniqueNotificationIdOfOrganization)(organizationId, app_enums_1.enums.NotificationType.Announcement, trx);
        const instanceData = {
            s: request.subject,
            b: request.body,
            a: request.attachmentIds,
            receiverUserIds: userIds,
        };
        const eventId = await dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
            createdT: new Date(),
            notificationId,
            organizationId,
            trx,
            instanceData,
        });
        return { eventId, instanceData };
    }, userId, organizationId);
    (0, messageBroker_notification_pub_1.publishToNotificationService)({
        a: 0,
        i: eventId,
        n: app_enums_1.enums.AmqpMessageCode.Empty,
        o: organizationId,
        v: "1",
        d: instanceData,
    });
    res.json();
});
module.exports.uploadAttachment = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let fileData = req.swagger.params.upfile.value;
    let fileName = req.swagger.params.fileName.value;
    let dbResult = await dal_manager_1.dbManager.accessNotifications.uploadAttachment(organizationId, fileName);
    if (!dbResult) {
        next((0, api_error_1.generateNotFoundApiError)({ message: "Could not add attachment" }));
    }
    app_filesystem_1.fileSystem.addFile(organizationId, dbResult, fileData);
    res.json(dbResult);
});
module.exports.getMessageAttachment = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let attachmentId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "attachmentId");
    let fileName = await dal_manager_1.dbManager.accessNotifications.getAttachment(organizationId, attachmentId);
    if (fileName) {
        res.writeHead(200, {
            "Content-Type": "application/octet-stream",
            "Content-Disposition": "attachment; filename=" + fileName,
        });
        let stream = await app_filesystem_1.fileSystem.getReadStream(organizationId, attachmentId);
        if (stream) {
            stream.pipe(res);
        }
        else {
            (0, dal_access_error_1.throwDbAccessNotFoundError)(`Related file not found at file system!`);
        }
    }
    else {
        res.json();
    }
});
module.exports.removeMessageAttachment = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let attachmentId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "attachmentId");
    let dbResult = await dal_manager_1.dbManager.accessNotifications.removeAttachment(organizationId, attachmentId);
    if (!dbResult) {
        next((0, api_error_1.generateNotFoundApiError)({ message: "Could not remove attachment of ppermission" }));
    }
    await app_filesystem_1.fileSystem.deleteFile(organizationId, attachmentId);
    res.json();
});
module.exports.obtainUserSelectionSessionForSystemMessage = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let force = req.swagger.params.force.value;
    let authResult = (0, api_securityhelper_1.authorizeForObtainUserSelectionSessionForGeneric)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessUser.obtainUserSelectionSession(organizationId, {
            requestUserId: authResult.jwt.userId,
            type: app_enums_1.enums.UserSelectionSessionType.SystemMessage,
            relatedItemId: uuid.v4(),
            forceToCreate: force,
            isAuthorizedForAllUsers: authResult.hasOrganizationWideReadBasic && authResult.hasOrganizationWideWritePPermission,
            authorizedOrganizationUnitIds: authResult.readBasicOrganizationUnitIds,
        }, trx);
    }, authResult.jwt.userId, organizationId);
    if (!dbResult.upserted) {
        throw (0, api_error_1.generateConflictError)({
            message: "There is already a session for that work plan. Please see detailes.",
            details: dbResult.overwritten,
        });
    }
    let result = {
        sessionId: dbResult.sessionId,
        expirationUtc: dbResult.expirationUtc,
        justRefreshed: dbResult.justRefreshed,
        overwritten: dbResult.overwritten
            ? {
                ownerUserId: dbResult.overwritten.ownerUserId,
                sessionId: dbResult.overwritten.sessionId,
                expirationUtc: dbResult.overwritten.expirationUtc,
                captionLines: dbResult.overwritten.captionLines,
            }
            : undefined,
    };
    res.json(result);
});
module.exports.getScheduledJob = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const scheduledJobId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "scheduledJobId");
    const authResult = (0, api_securityhelper_1.authorizeForScheduledJobsRead)(req, organizationId);
    const scheduledJob = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessSystem.getScheduledJobListItem({
            organizationId,
            id: scheduledJobId,
            trx,
        });
    }, authResult.jwt.userId, organizationId);
    res.json(scheduledJob);
});
module.exports.addScheduledJob = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const auth = (0, api_securityhelper_1.authorizeForScheduledJobsWrite)(req, organizationId);
    const request = req.body;
    request.firstExecutionDate = request.firstExecutionDate ? luxon_1.DateTime.fromISO(request.firstExecutionDate).toSQL({ includeOffset: false }) : undefined;
    const result = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        if (request.settings?.format === app_enums_1.enums.ReportFormat.Pdf) {
            const reportTemplate = await dal_manager_1.dbManager.accessReport.getReportTemplate(organizationId, request.settings.templateId, trx);
            if (app_constants_1.ReportTemplatesWithoutPDF.includes(reportTemplate.type)) {
                (0, dal_access_error_1.throwDbAccessBadRequestError)("Unsupported Report Format For This Report Type");
            }
        }
        return dal_manager_1.dbManager.accessSystem.addScheduledJob({ ...request, organizationId, userId: auth.jwt.userId, trx });
    }, auth.jwt.userId, organizationId);
    res.json(result);
});
module.exports.updateScheduledJob = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const scheduledJobId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "scheduledJobId");
    const authResult = (0, api_securityhelper_1.authorizeForScheduledJobsWrite)(req, organizationId);
    const request = req.body;
    request.firstExecutionDate = request.firstExecutionDate ? luxon_1.DateTime.fromISO(request.firstExecutionDate).toSQL({ includeOffset: false }) : undefined;
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessSystem.updateScheduledJob({ ...request, organizationId, trx, id: scheduledJobId });
    }, authResult.jwt.userId, organizationId);
    res.json({});
});
module.exports.deleteScheduledJob = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const scheduledJobId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "scheduledJobId");
    const authResult = (0, api_securityhelper_1.authorizeForScheduledJobsWrite)(req, organizationId);
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessSystem.deleteScheduledJob({
            id: scheduledJobId,
            trx,
        });
    }, authResult.jwt.userId, organizationId);
    res.json({});
});
module.exports.driverQrScan = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const jwt = req.auth_token;
    const userId = jwt.userId;
    const request = new api_user_v1_models_1.RestUserApiV1.DriverQrScanRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        try {
            const responseData = await (0, api_arvento_1.driverQrScanRequest)(organizationId, userId, request, trx);
            res.json(responseData);
        }
        catch (err) {
            throw err;
        }
    });
});
