"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const app_enums_1 = require("../../../../app.enums");
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_user_v1_models_1 = require("../api.user.v1.models");
const dal_access_cache_1 = require("../../../../dal/access/access-interfaces/dal.access.cache");
const business_roles_1 = require("../../../../business/business.roles");
const predefined_roles_1 = require("../../../../dal/db/predefined/predefined.roles");
async function isDeviceConnected(deviceId) {
    return dal_manager_1.dbManager.accessRedisCache.getValue(dal_access_cache_1.CacheConstantKeys.TerminalConnection + deviceId).then((connected) => {
        if (parseInt(connected) > 0)
            return Promise.resolve(true);
        return Promise.resolve(false);
    });
}
module.exports.getInitialClientAppData = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let initialDataRequest = new api_user_v1_models_1.RestUserApiV1.InitialDataRequest(req.body);
    let result = {};
    let userId = req.auth_token.userId;
    if (initialDataRequest.cards) {
        if (initialDataRequest.cards.indexOf(app_enums_1.enums.DashboardCardItemType.ActivityTimeline) >= 0) {
            result.cardActivityTimelineItems = await dal_manager_1.dbManager.accessLog.getLatestAccessLogs(organizationId, 10);
        }
        if (initialDataRequest.cards.indexOf(app_enums_1.enums.DashboardCardItemType.RemoteAccessGrantedAccessControlPoints) >= 0) {
            result.cardRemoteAccessGrantedAccessControlPoints = await dal_manager_1.dbManager.accessAccessControlPoint.searchRemoteAccessGrantedAccessControlPoints(organizationId, userId, initialDataRequest.remoteAccessGrantedAccessControlPointFilter);
        }
    }
    if (initialDataRequest.organizationRoles) {
        const { r: requesterUserRoleId } = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId });
        let organizationRoles = await dal_manager_1.dbManager.accessUser.listRolesOfOrganization(organizationId);
        organizationRoles = organizationRoles.filter((or) => or.typeId !== predefined_roles_1.PredefinedRoles.OrganizationVisitor.id && or.typeId !== predefined_roles_1.PredefinedRoles.OrganizationUnitVisitor.id);
        for (const or of organizationRoles) {
            try {
                if (or.isOrganizationWide) {
                    or.coveredByUserRole = await (0, business_roles_1.canUserChangeRole)(organizationId, requesterUserRoleId, or.id);
                }
                else {
                    or.coveredByUserRole = true;
                }
            }
            catch (err) {
                or.coveredByUserRole = false;
            }
        }
        result.organizationRoles = organizationRoles;
    }
    res.json(result);
});
