"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiTerminalControllerV1 = exports.libModels = void 0;
const express_1 = __importDefault(require("express"));
const fs_1 = __importDefault(require("fs"));
const libAccessModels = __importStar(require("../../../lib/access-model"));
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const business_device_1 = require("../../../business/business.device");
const dal_constants_1 = require("../../../dal/dal.constants");
const dal_manager_1 = require("../../../dal/dal.manager");
const messagebroker_models_1 = require("../../../messageBroker/messagebroker.models");
const messageBroker_server_to_device_pub_1 = require("../../../messageBroker/messageBroker.server-to-device.pub");
const api_auth_1 = require("../../api.auth");
const api_error_1 = require("../../api.error");
const api_models_common_1 = require("../../api.models.common");
const api_util_1 = require("../../api.util");
const api_validatorhelper_1 = require("../../api.validatorhelper");
const api_terminal_model_1 = require("./api.terminal.model");
exports.libModels = libAccessModels.V1.Models;
const sharp = require("sharp");
class ApiTerminalControllerV1 {
    constructor(app) {
        this.askUsersWithPagination = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_models_common_1.ApiModelsCommon.AskUsersWithPaginationRequest(req.body, validator);
            validator.finalize();
            let userIds = JSON.parse(await dal_manager_1.dbManager.accessRedisCache.getValue(request.sessionId));
            let targetUserIds = userIds.slice(request.skip, request.take + request.skip);
            let users = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                return dal_manager_1.dbManager.accessDevice.getUsersOfTerminalPg(req.deviceId, targetUserIds, req.organizationId, trx);
            });
            (0, api_auth_1.sendZippedJsonResponse)({ users: users }, res);
        };
        this.askUsersWithPaginationStart = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            validator.validateUUID("sessionId", false, req.body.sessionId);
            validator.finalize();
            let sessionId = req.body.sessionId;
            let userIds = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                const userIdsOfTerminal = await dal_manager_1.dbManager.accessDevice.getUserIdsOfTerminal(req.organizationId, req.deviceId, trx);
                await dal_manager_1.dbManager.accessDevice.removeAllChangesForTerminal(req.organizationId, req.deviceId, trx);
                return userIdsOfTerminal;
            });
            await dal_manager_1.dbManager.accessRedisCache.setExpireValue(sessionId, JSON.stringify(userIds), 60 * 60);
            res.json({
                totalUserCount: userIds.length,
            });
        };
        this.askUsersWithPaginationEnd = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            validator.validateUUID("sessionId", false, req.body.sessionId);
            validator.finalize();
            let sessionId = req.body.sessionId;
            await dal_manager_1.dbManager.accessRedisCache.delValue(sessionId);
            res.json();
        };
        this.startAskChangeSession = async (req, res) => {
            let sessionId = (0, api_validatorhelper_1.validateUUID)(req.params.sid, "sessionId");
            res.json({
                itemCount: await dal_manager_1.dbManager.accessDevice.startGetChangesSession(req.deviceId, sessionId, req.organizationId),
                systemDateISO: new Date().toISOString(),
            });
        };
        this.askChangesWhole = async (req, res) => {
            let sessionId = (0, api_validatorhelper_1.validateUUID)(req.params.sid, "sessionId");
            let items = await dal_manager_1.dbManager.accessDevice.getWholeChanges(req.deviceId, sessionId, req.organizationId);
            (0, api_auth_1.sendZippedJsonResponse)(items, res);
        };
        this.askChangesWithPagination = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            validator.validateUUID("sessionId", false, req.params.sid);
            let request = new api_models_common_1.ApiModelsCommon.PaginationRequest(req.body, 1000, validator);
            validator.finalize();
            let sessionId = req.params.sid;
            let dbResult = await dal_manager_1.dbManager.accessDevice.getChanges(req.deviceId, sessionId, req.organizationId, request);
            let result = {
                items: dbResult.items,
                pagination: dbResult.pagination,
            };
            (0, api_auth_1.sendZippedJsonResponse)(result, res);
        };
        this.askChangeSessionCompleted = async (req, res) => {
            let sessionId = (0, api_validatorhelper_1.validateUUID)(req.params.sid, "sessionId");
            let remainingItemsCount = await dal_manager_1.dbManager.accessDevice.completeGetChangesSession(req.deviceId, sessionId, req.organizationId);
            res.json({
                remainingItemsCount: remainingItemsCount,
                systemDateISO: new Date().toISOString(),
            });
        };
        this.uploadOfflineLogs = async (req, res) => {
            let request = req.body;
            app_logs_1.logger.info("[ADAPTER] offline logs for deviceId:" + req.deviceId);
            let d1 = new Date();
            try {
                await dal_manager_1.dbManager.accessLog.checkUploadLogIdExits(req.organizationId, request.uploadId);
            }
            catch (error) {
                throw (0, api_error_1.generateConflictError)({ message: "Upload Id already exists", details: request.uploadId });
            }
            let count = 0;
            let organizationId = req.organizationId;
            if (request.accessLogs && request.accessLogs.length > 0) {
                await dal_manager_1.dbManager.accessDevice.uploadDeviceAccessLogs(organizationId, request.accessLogs);
                count += request.accessLogs.length;
                for (const logItem of request.accessLogs) {
                    dal_manager_1.dbManager.accessPacs2.onAccessLogsChanged({
                        reason: app_enums_1.enums.RecalculateWorkReason.OfflineLogReceived,
                        acpId: logItem.a,
                        timestamp: new Date(logItem.u),
                        userId: logItem.o,
                        direction: logItem.d,
                        organizationId: organizationId,
                    });
                }
            }
            if (request.statusSensorLogs && request.statusSensorLogs.length > 0) {
                await dal_manager_1.dbManager.accessLog.uploadStatusSensorLogs(organizationId, request.statusSensorLogs);
                count += request.statusSensorLogs.length;
            }
            if (request.tamperSwitchLogs && request.tamperSwitchLogs.length > 0) {
                await dal_manager_1.dbManager.accessLog.uploadTamperSwitchLogs(organizationId, request.tamperSwitchLogs);
                count += request.tamperSwitchLogs.length;
            }
            if (request.counterLogs && request.counterLogs.length > 0) {
                await dal_manager_1.dbManager.accessLog.uploadCounterLogs({ organizationId, logs: request.counterLogs });
                count += request.counterLogs.length;
            }
            if (request.systemStatusLogs && request.systemStatusLogs.length > 0) {
                let deviceHealth = await (0, business_device_1.uploadDeviceSystemStatusLogs)(organizationId, req.deviceId, request.systemStatusLogs);
                if (!deviceHealth) {
                    throw (0, api_error_1.generateBadRequestApiError)({ message: "System status health update" });
                }
                count += request.systemStatusLogs.length;
            }
            if (request.fingerPrintRegisteryLogs && request.fingerPrintRegisteryLogs.length > 0) {
                await dal_manager_1.dbManager.accessUser.upsertFingerPrintCredentialsFromDevice(organizationId, req.deviceId, request.fingerPrintRegisteryLogs.map((r) => {
                    return {
                        finger: r.f,
                        type: r.t,
                        credentialId: r.cid,
                        specialData: r.s,
                        specialDataSecondary: r.ss,
                        userId: r.uid,
                    };
                }));
            }
            if (request.fingerPrintRemoveLogs && request.fingerPrintRemoveLogs.length > 0) {
                await dal_manager_1.dbManager.accessUser.removeFingerPrintCredentialsFromDevice(organizationId, req.deviceId, request.fingerPrintRegisteryLogs.map((r) => {
                    return {
                        finger: r.f,
                        type: r.t,
                        userId: r.uid,
                    };
                }));
            }
            if (request.faceRecogniseAddLogs && request.faceRecogniseAddLogs.length > 0) {
                await dal_manager_1.dbManager.accessUser.upsertFaceRecogniseCredentialsFromDevice(organizationId, req.deviceId, request.faceRecogniseAddLogs.map((r) => {
                    return {
                        type: r.t,
                        credentialId: r.cid,
                        specialData: r.s,
                        specialDataSecondary: r.ss,
                        userId: r.uid,
                    };
                }));
            }
            if (request.faceRecogniseRemoveLogs && request.faceRecogniseRemoveLogs.length > 0) {
                await dal_manager_1.dbManager.accessUser.removeFaceRecogniseCredentialsFromDevice(organizationId, req.deviceId, request.faceRecogniseRemoveLogs.map((r) => {
                    return {
                        type: r.t,
                        userId: r.uid,
                    };
                }));
            }
            await dal_manager_1.dbManager.accessLog.addUploadLogId(organizationId, req.deviceId, request.uploadId, count);
            res.json({
                uploadId: request.uploadId,
            });
            let deviceIds = await dal_manager_1.dbManager.accessRegion.getOrganizationRegionRelatedDeviceIds(organizationId);
            for (let deviceId of deviceIds) {
                messageBroker_server_to_device_pub_1.amqpServerToDevicePub.sendToExchange(deviceId, {
                    e: messagebroker_models_1.ServerToDeviceMessageType.GetChangesRequired,
                });
            }
            let d2 = new Date();
            app_logs_1.logger.info("[ADAPTER] offline logs for:" + req.deviceId + ":" + (d2.getTime() - d1.getTime()));
        };
        this.failSnapshot = async (req, res) => {
            let snapshotId = (0, api_validatorhelper_1.validateUUID)(req.params.sid, "snapshotId");
            try {
                let dbResult = await dal_manager_1.dbManager.accessLog.uploadSnapshot(req.organizationId, req.deviceId, snapshotId, false, null);
                if (!dbResult)
                    throw (0, api_error_1.generateNotFoundApiError)({ message: "Unable to fail snapshot" });
            }
            catch (error) {
                throw (0, api_error_1.generateConflictError)({ message: "Snapshot Id already exists", details: snapshotId });
            }
            res.json();
        };
        this.uploadSnapshot = async (req, res) => {
            let snapshotId = (0, api_validatorhelper_1.validateUUID)(req.params.sid, "snapshotId");
            let snapshot = null;
            const snapshotSettings = await dal_manager_1.dbManager.accessRedisCache.getOrganizationSnapshotSettingsCache({ organizationId: req.organizationId });
            if (!snapshotSettings.discardSnapshot) {
                if (req.body.type === "raw") {
                    snapshot = Buffer.from(req.body.snapshot);
                    try {
                        const compression = sharp(snapshot, { failOnError: false }).webp({
                            quality: snapshotSettings?.quality ?? 60,
                            reductionEffort: 1,
                        });
                        if (snapshotSettings?.width) {
                            compression.resize(null, snapshotSettings?.width ?? 180);
                        }
                        snapshot = await compression.toBuffer();
                    }
                    catch (err) {
                        app_logs_1.logger.error(`[api.terminal.controller.ts] Error while compressing snaphsot coming from device!`);
                        app_logs_1.logger.error(err);
                    }
                }
                else {
                    snapshot = req.body.snapshot.data;
                }
                let actionUtc = req.body.actionUtc;
                try {
                    let dbResult = await dal_manager_1.dbManager.accessLog.uploadSnapshot(req.organizationId, req.deviceId, snapshotId, true, actionUtc, snapshot);
                    if (!dbResult)
                        throw (0, api_error_1.generateNotFoundApiError)({ message: "Unable to upload snapshot" });
                }
                catch (error) {
                    throw (0, api_error_1.generateConflictError)({ message: "Snapshot Id already exists", details: snapshotId });
                }
            }
            res.json();
        };
        this.listAccessNotifications = async (req, res) => {
            let paginationRequest = req.body;
            let dbResult = await dal_manager_1.dbManager.accessNotifications.getAccessNotificationEventsWithPagination(req.organizationId, req.deviceId, paginationRequest);
            res.json(dbResult);
        };
        this.listUserGroups = async (req, res) => {
            let dbResult = await dal_manager_1.dbManager.accessUserGroup.listUserGroupsForControlPanel(req.organizationId);
            res.json(dbResult);
        };
        this.listAccessRuleHistory = async (req, res) => {
            let dbResult = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                return dal_manager_1.dbManager.accessLog.listAccessRuleHistory(req.organizationId, trx);
            });
            res.json(dbResult);
        };
        this.listUserRegionTicketUnitsInfo = async (req, res) => {
            let dbResult = await dal_manager_1.dbManager.accessSocial.listUserRegionTicketsForControlPanel(req.organizationId);
            res.json(dbResult);
        };
        this.getServerDetailes = (req, res) => {
            res.json({
                version: "2.0.0",
                message: "control panel api is working!",
            });
        };
        this.downloadUpdateFile = async (req, res) => {
            let deviceBasic = await dal_manager_1.dbManager.accessDevice.getDeviceBasic(req.organizationId, req.deviceId);
            let updateFile = await dal_manager_1.dbManager.accessDevice.getUpdateFile(req.organizationId, deviceBasic.brand, deviceBasic.model);
            if (updateFile) {
                if (fs_1.default.existsSync(updateFile.updateFilePath)) {
                    res.download(updateFile.updateFilePath);
                }
                else {
                    res.status(400).send("File does not exists in the specified location");
                }
            }
            else {
                res.status(404).send();
            }
        };
        this.upsertFingerPrintCredential = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_terminal_model_1.TerminalModelsV1.FingerPrintRegistryItem(req.body, validator);
            validator.finalize();
            await dal_manager_1.dbManager.accessUser.upsertFingerPrintCredentialFromDevice(req.organizationId, req.deviceId, request);
            res.json();
        };
        this.removeFingerPrintCredential = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_terminal_model_1.TerminalModelsV1.RemoveFingerPrint(req.body, validator);
            validator.finalize();
            await dal_manager_1.dbManager.accessUser.removeFingerPrintCredentialFromDevice(req.organizationId, req.deviceId, request);
            res.json();
        };
        this.insertNewCredential = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_terminal_model_1.TerminalModelsV1.InsertNewCredentialRequest(req.body, validator);
            validator.finalize();
            await dal_manager_1.dbManager.accessUser.insertNewCredential(req.organizationId, req.deviceId, request);
            res.json();
        };
        this.upsertFaceRecogniseCredential = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_terminal_model_1.TerminalModelsV1.AddNewFaceRecogniseCredentialRequest(req.body, validator);
            validator.finalize();
            await dal_manager_1.dbManager.accessUser.upsertFaceRecogniseCredentialFromDevice(req.organizationId, req.deviceId, request);
            res.json();
        };
        this.removeFaceRecogniseCredential = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_terminal_model_1.TerminalModelsV1.RemoveFaceRecogniseCredentialRequest(req.body, validator);
            validator.finalize();
            await dal_manager_1.dbManager.accessUser.removeFaceRecogniseCredentialFromDevice(req.organizationId, req.deviceId, request);
            res.json();
        };
        this.upsertActionSnapshot = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_terminal_model_1.TerminalModelsV1.ActionSnapshotRequest(req.body, validator);
            await dal_manager_1.dbManager.accessRedisCache.setExpireValue(request.sid, request.image, 60 * 5);
            res.json();
        };
        this.requestCertificates = async (req, res) => {
            let terminalId = (0, api_validatorhelper_1.validateUUID)(req.params.tid, "terminalId");
            let date = new Date(parseInt(req.params.date.substr(0, 4)), parseInt(req.params.date.substr(4, 2)));
            let certFiles = await dal_manager_1.dbManager.accessDevice.getTerminalCertFiles(req.organizationId, terminalId, date);
            (0, api_auth_1.sendZippedJsonResponse)(certFiles, res);
        };
        this.driveRelay = async (req, res) => {
            const relayId = req.params.rid;
            let remoteRelayDriveCommandStructure = await dal_manager_1.dbManager.accessDevice.getRemoteRelayDriveCommandStructure(req.organizationId, relayId);
            if (!remoteRelayDriveCommandStructure) {
                res.json({
                    result: dal_constants_1.DalConstants.libEnumsV2.RemoteRelayStatus.Fail,
                    error: "Remote Relay Id is not mapped with any aperio devices!",
                });
            }
            messageBroker_server_to_device_pub_1.amqpServerToDevicePub.sendToRpcQueue(remoteRelayDriveCommandStructure.deviceId, {
                e: messagebroker_models_1.ServerToDeviceRPCMessageType.RemoteRelay,
                p: {
                    r: remoteRelayDriveCommandStructure.relayId,
                },
            }, 30000, (err, success) => {
                if (err) {
                    res.json({
                        result: dal_constants_1.DalConstants.libEnumsV2.RemoteRelayStatus.Timeout,
                    });
                }
                else {
                    switch (success.s) {
                        case app_enums_1.enums.libEnumsV2.RemoteRelayStatus.OnProgress:
                        case app_enums_1.enums.libEnumsV2.RemoteRelayStatus.Success:
                            res.json({
                                result: dal_constants_1.DalConstants.libEnumsV2.RemoteRelayStatus.Success,
                            });
                            break;
                        default:
                            res.json({
                                result: dal_constants_1.DalConstants.libEnumsV2.RemoteRelayStatus.Fail,
                            });
                            break;
                    }
                }
            });
        };
        this.checkHesStatus = async (req, res) => {
            const organizationId = (0, api_validatorhelper_1.validateUUID)(req.organizationId, "organizationId");
            const userId = (0, api_validatorhelper_1.validateUUID)(req.body.userId, "userId");
            const userProfile = await dal_manager_1.dbManager.accessUser.getBasicUserOrganizationProfileInfo(organizationId, userId);
            let result = {};
            result.status = app_enums_1.enums.HesCodeStatus.Riskless;
            res.json(result);
            return;
        };
        this._router = express_1.default.Router();
        this._router.get("/", this.getServerDetailes);
        this._router.get("/certs/:tid/:yyyymm", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.requestCertificates));
        this._router.post("/askuserswithpagination", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.askUsersWithPagination));
        this._router.post("/askuserswithpaginationstart", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.askUsersWithPaginationStart));
        this._router.post("/askuserswithpaginationend", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.askUsersWithPaginationEnd));
        this._router.get("/askchanges/:sid", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.askChangesWhole));
        this._router.post("/askchanges/:sid", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.askChangesWithPagination));
        this._router.get("/askchanges/:sid/new", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.startAskChangeSession));
        this._router.get("/askchanges/:sid/completed", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.askChangeSessionCompleted));
        this._router.post("/uploadofflinelogs", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.uploadOfflineLogs));
        this._router.post("/snapshot/:sid", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.uploadSnapshot));
        this._router.get("/snapshot/:sid/fail", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.failSnapshot));
        this._router.get("/usergroups", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.listUserGroups));
        this._router.get("/accessrulehistory", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.listAccessRuleHistory));
        this._router.post("/accessnotifications", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.listAccessNotifications));
        this._router.get("/userregionticketunits", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.listUserRegionTicketUnitsInfo));
        this._router.get("/updatefile", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.downloadUpdateFile));
        this._router.post("/user/addfingerprintcredential", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.upsertFingerPrintCredential));
        this._router.post("/user/removefingerprintcredential", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.removeFingerPrintCredential));
        this._router.post("/user/addfacerecognisecredential", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.upsertFaceRecogniseCredential));
        this._router.post("/user/insertnewcredential", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.insertNewCredential));
        this._router.post("/user/removefacerecognisecredential", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.removeFaceRecogniseCredential));
        this._router.post("/user/action/snapshot", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.upsertActionSnapshot));
        this._router.post("/gethescodestatus", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.checkHesStatus));
        this._router.get("/relay/:rid/drive", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.driveRelay));
        app.use("/t/v1", express_1.default.json({ limit: "100mb" }), this._router);
    }
}
exports.ApiTerminalControllerV1 = ApiTerminalControllerV1;
