"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestSocialApiV1 = void 0;
var RestSocialApiV1;
(function (RestSocialApiV1) {
    class RegionTicketUpsertRequest {
        constructor(raw, validator) {
            validator.validateUUID("id", true, raw.id);
            validator.validateUUID("regionId", false, raw.regionId);
            validator.validateFloat("requiredUnits", false, raw.requiredUnits, 0.01, 999.99);
            validator.finalize();
            this.id = raw.id;
            this.regionId = raw.regionId;
            this.requiredUnits = raw.requiredUnits;
            this.name = raw.name;
        }
    }
    RestSocialApiV1.RegionTicketUpsertRequest = RegionTicketUpsertRequest;
    class ListRegionTicketRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("regionTicketIds", true, raw.regionTicketIds);
            validator.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.regionTicketIds = raw.regionTicketIds;
        }
    }
    RestSocialApiV1.ListRegionTicketRequest = ListRegionTicketRequest;
    class RegionTicketListDetailRequestFilter {
        constructor(raw, validator) {
            validator.validateUUIDArray("regionIds", true, raw.regionIds);
            validator.validateUUIDArray("regionTicketIds", true, raw.regionTicketIds);
            validator.finalize();
            this.regionIds = raw.regionIds;
            this.regionTicketIds = raw.regionTicketIds;
            this.pagination = raw.pagination;
        }
    }
    RestSocialApiV1.RegionTicketListDetailRequestFilter = RegionTicketListDetailRequestFilter;
    class ListRegionTicketUserUnitsRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("userIds", true, raw.userIds);
            validator.finalize();
            this.userIds = raw.userIds;
            this.userGroupIds = raw.userGroupIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.pagination = raw.pagination;
        }
    }
    RestSocialApiV1.ListRegionTicketUserUnitsRequest = ListRegionTicketUserUnitsRequest;
    class ListRegionTicketUsageReportFilter {
        constructor(raw, validator) {
            validator.validateUUIDArray("userIds", true, raw.userIds);
            validator.validateUUIDArray("userGroupIds", true, raw.userGroupIds);
            validator.validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds);
            validator.finalize();
            this.userIds = raw.userIds;
            this.userGroupIds = raw.userGroupIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.regionTicketIds = raw.regionTicketIds;
            this.dateRange = raw.dateRange;
            this.pagination = raw.pagination;
        }
    }
    RestSocialApiV1.ListRegionTicketUsageReportFilter = ListRegionTicketUsageReportFilter;
    class AssignUserRegionTicketUnitRequest {
        constructor(raw, validator) {
            validator.validateFloat("amount", false, raw.amount, -9999.99, 9999.99);
            validator.finalize();
            this.amount = raw.amount;
            this.note = raw.note;
        }
    }
    RestSocialApiV1.AssignUserRegionTicketUnitRequest = AssignUserRegionTicketUnitRequest;
    class ListRegionTicketTransactionFilter {
        constructor(raw, validator) {
            validator.validateUUID("actionUserId", true, raw.actionUserId);
            validator.validateUUID("targetUserId", true, raw.targetUserId);
            validator.finalize();
            this.actionUserId = raw.actionUserId;
            this.targetUserId = raw.targetUserId;
            this.pagination = raw.pagination;
            this.dateRange = raw.dateRange;
        }
    }
    RestSocialApiV1.ListRegionTicketTransactionFilter = ListRegionTicketTransactionFilter;
    class ListRegionTicketTransactionFilterExcel {
        constructor(raw, validator) {
            validator.validateUUID("actionUserId", true, raw.actionUserId);
            validator.validateUUID("targetUserId", true, raw.targetUserId);
            validator.finalize();
            this.actionUserId = raw.actionUserId;
            this.targetUserId = raw.targetUserId;
            this.dateRange = raw.dateRange;
        }
    }
    RestSocialApiV1.ListRegionTicketTransactionFilterExcel = ListRegionTicketTransactionFilterExcel;
    class ListRegionTicketTransactionDetailFilter {
        constructor(raw, validator) {
            validator.validateUUID("targetUserId", true, raw.targetUserId);
            validator.finalize();
            this.targetUserId = raw.targetUserId;
            this.pagination = raw.pagination;
        }
    }
    RestSocialApiV1.ListRegionTicketTransactionDetailFilter = ListRegionTicketTransactionDetailFilter;
})(RestSocialApiV1 = exports.RestSocialApiV1 || (exports.RestSocialApiV1 = {}));
