"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_error_1 = require("../../../api.error");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_pacs_v1_models_1 = require("../api.pacs.v1.models");
module.exports.upsertVacation = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendancePlanWrite)(req, organizationId);
    let request = new api_pacs_v1_models_1.RestPacsApiV1.AddVacationRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessPacs.upsertVacation(organizationId, {
        startDateTime: request.startDateTime,
        endDateTime: request.endDateTime,
        title: request.title,
        type: request.type,
        vacationId: request.id,
    });
    res.json(dbResult);
});
module.exports.listVacations = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendancePlanRead)(req, organizationId);
    let year = req.swagger.params.year.value;
    let dbResult = await dal_manager_1.dbManager.accessPacs.listVacations(organizationId, year);
    res.json(dbResult);
});
module.exports.removeVacation = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendancePlanWrite)(req, organizationId);
    let vacationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "vacationId");
    let dbResult = await dal_manager_1.dbManager.accessPacs.removeVacation(organizationId, vacationId);
    if (!dbResult) {
        next((0, api_error_1.generateNotFoundApiError)({ message: "There is no vacation" }));
        return;
    }
    res.json();
});
