"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobileClientApiModelsV1 = void 0;
const app_enums_1 = require("../../../app.enums");
const api_models_common_1 = require("../../api.models.common");
var MobileClientApiModelsV1;
(function (MobileClientApiModelsV1) {
    class AskMobileAccessRightsWithPagination {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.validateEnumArray("filterAuthenticationFactors", true, raw.filterAuthenticationFactors);
            this.filterAuthenticationFactors = raw.filterAuthenticationFactors;
            validator.finalize();
        }
    }
    MobileClientApiModelsV1.AskMobileAccessRightsWithPagination = AskMobileAccessRightsWithPagination;
    class RemoteAccessCommand {
        constructor(raw, validator) {
            validator.validateUUID("accessControlPointId", false, raw.accessControlPointId);
            validator.validateEnum("direction", true, app_enums_1.enums.AccessDirection, raw.direction);
            validator.validateIsBoolean("qr", true, raw.qr);
            validator.finalize();
            this.accessControlPointId = raw.accessControlPointId;
            this.direction = raw.direction || app_enums_1.enums.AccessDirection.All;
            this.qr = raw.qr || false;
        }
    }
    MobileClientApiModelsV1.RemoteAccessCommand = RemoteAccessCommand;
})(MobileClientApiModelsV1 = exports.MobileClientApiModelsV1 || (exports.MobileClientApiModelsV1 = {}));
