"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiArmonV10ControllerV3 = void 0;
const express_1 = __importDefault(require("express"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const api_auth_1 = require("../../api.auth");
const api_util_1 = require("../../api.util");
const dal_manager_1 = require("../../../dal/dal.manager");
const app_config_1 = require("../../../app.config");
const app_logs_1 = require("../../../app.logs");
class ApiArmonV10ControllerV3 {
    constructor(app) {
        this.askDeviceData = async (req, res) => {
            let request = req.body;
            let dbResult = await dal_manager_1.dbManager.accessDevice.getDataWithUsersForArmonOneSeriesV2(req.organizationId, req.deviceId, request.configurationAndSettings);
            if (request.openVpnConfig) {
                const openVpnClientConfigPath = path_1.default.resolve(app_config_1.appConfig.configDirectory, "openvpn-client.conf");
                if (fs_1.default.existsSync(openVpnClientConfigPath)) {
                    dbResult.openVpnConfig = fs_1.default.readFileSync(openVpnClientConfigPath, { encoding: "utf8" });
                }
                else {
                    app_logs_1.logger.error(`Error while looking for OpenVPN Client configuration file for device ${req.deviceId}. Client config file not found.`);
                    dbResult.openVpnConfig = null;
                }
            }
            (0, api_auth_1.sendZippedJsonResponse)(dbResult, res);
        };
        this.updateControlPanelSettingsAndConfiguration = async (req, res) => {
            let request = req.body;
            try {
                let dbResult = await dal_manager_1.dbManager.accessDevice.updateArmonOneDeviceConfigurationAndSettingsV2(req.deviceId, req.organizationId, request);
                res.json(dbResult);
            }
            catch (error) {
                res.status(400).json({ error: error });
            }
        };
        this._router = express_1.default.Router();
        this._router.post("/askdevicedata", api_auth_1.armonV10Authorize, (0, api_util_1.globalRouteHandler)(this.askDeviceData));
        this._router.post("/settingsandconfigurations", api_auth_1.armonV10Authorize, (0, api_util_1.globalRouteHandler)(this.updateControlPanelSettingsAndConfiguration));
        app.use("/av10/v3", express_1.default.json({ limit: "100mb" }), this._router);
    }
}
exports.ApiArmonV10ControllerV3 = ApiArmonV10ControllerV3;
