"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArmonV10ApiModelsV1 = void 0;
const app_enums_1 = require("../../../app.enums");
var ArmonV10ApiModelsV1;
(function (ArmonV10ApiModelsV1) {
    class FingerPrintRegistryItem {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateUUID("credentialId", false, raw.credentialId);
            validator.validateEnum("finger", false, app_enums_1.enums.FingerIndex, raw.finger);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.finger = raw.finger;
            this.type = raw.type;
            this.specialData = raw.specialData;
            this.credentialId = raw.credentialId;
            this.specialDataSecondary = raw.specialDataSecondary;
        }
    }
    ArmonV10ApiModelsV1.FingerPrintRegistryItem = FingerPrintRegistryItem;
    class RemoveFingerPrint {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateEnum("finger", false, app_enums_1.enums.FingerIndex, raw.finger);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.finger = raw.finger;
            this.type = raw.type;
        }
    }
    ArmonV10ApiModelsV1.RemoveFingerPrint = RemoveFingerPrint;
})(ArmonV10ApiModelsV1 = exports.ArmonV10ApiModelsV1 || (exports.ArmonV10ApiModelsV1 = {}));
