"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateTranslatedError = exports.generateUnauthroizedSnapshotAccessError = exports.generateResourceRemovedError = exports.generateFailedDependencyError = exports.generateUnauthorizedError = exports.generateMethodNotAllowed = exports.generateConflictError = exports.generateTimeoutApiError = exports.generateNotFoundApiError = exports.generateForbiddenError = exports.generateTableDeviceNotApproved = exports.generateTableDeviceNotConnected = exports.generateBadRequestApiError = exports.generateApiError = exports.generateApiErrorWithCode = exports.ApiTranslatedErrorStructure = void 0;
const app_enums_1 = require("../app.enums");
class ApiTranslatedErrorStructure extends Error {
    constructor(statusCode, message, replacements, noReport, showAsModal) {
        super();
        this.statusCode = statusCode;
        this.message = message;
        this.replacements = replacements;
        this.noReport = noReport;
        this.showAsModal = showAsModal;
    }
}
exports.ApiTranslatedErrorStructure = ApiTranslatedErrorStructure;
function generateApiErrorWithCode(code, message, url) {
    code = code || app_enums_1.enums.ArmonApiErrorCode.UNHANDLED_ERROR;
    let body = {
        code: code,
        message: message,
        url: url,
    };
    switch (code) {
        case app_enums_1.enums.ArmonApiErrorCode.USER_NOT_FOUND:
        case app_enums_1.enums.ArmonApiErrorCode.CONTROL_PANEL_NOT_CONNECTED:
            return {
                name: "API Not Found Error",
                message: "",
                statusCode: app_enums_1.enums.HttpStatusCode.NOT_FOUND,
                body: body,
            };
        case app_enums_1.enums.ArmonApiErrorCode.UNAUTHORIZED_API_ACCESS:
        case app_enums_1.enums.ArmonApiErrorCode.UNAUTHORIZED_INSTANT_PERMISSION_REQUEST:
            return {
                name: "API Forbidden Operation Error",
                message: "",
                statusCode: app_enums_1.enums.HttpStatusCode.FORBIDDEN,
                body: body,
            };
        case app_enums_1.enums.ArmonApiErrorCode.UNHANDLED_ERROR:
        default:
            return {
                name: "Internal API Error",
                message: message,
                statusCode: app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR,
                body: null,
            };
    }
}
exports.generateApiErrorWithCode = generateApiErrorWithCode;
function generateApiError(error, statusCode) {
    return {
        name: "API Error",
        message: "",
        statusCode: statusCode || app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR,
        body: error,
    };
}
exports.generateApiError = generateApiError;
function generateBadRequestApiError(error, message) {
    return {
        name: "API Bad Request Error",
        message: message,
        statusCode: app_enums_1.enums.HttpStatusCode.BAD_REQUEST,
        body: error,
    };
}
exports.generateBadRequestApiError = generateBadRequestApiError;
function generateTableDeviceNotConnected(error, message) {
    return {
        name: "Tablet Device Not Connected",
        message: message,
        statusCode: app_enums_1.enums.HttpStatusCode.TABLET_DEVICE_NOT_CONNECTED,
        body: error,
    };
}
exports.generateTableDeviceNotConnected = generateTableDeviceNotConnected;
function generateTableDeviceNotApproved(error, message) {
    return {
        name: "Tablet Device Not Approved",
        message: message,
        statusCode: app_enums_1.enums.HttpStatusCode.TABLET_DEVICE_NOT_APPROVED,
        body: error,
    };
}
exports.generateTableDeviceNotApproved = generateTableDeviceNotApproved;
function generateForbiddenError(error) {
    return {
        name: "API Forbidden Operation Error",
        message: "",
        statusCode: app_enums_1.enums.HttpStatusCode.FORBIDDEN,
        body: error,
    };
}
exports.generateForbiddenError = generateForbiddenError;
function generateNotFoundApiError(error) {
    return {
        name: "API Not Found Error",
        message: "",
        statusCode: app_enums_1.enums.HttpStatusCode.NOT_FOUND,
        body: error,
    };
}
exports.generateNotFoundApiError = generateNotFoundApiError;
function generateTimeoutApiError(error) {
    return {
        name: "API Timeout Error",
        message: "",
        statusCode: app_enums_1.enums.HttpStatusCode.TIMEOUT,
        body: error,
    };
}
exports.generateTimeoutApiError = generateTimeoutApiError;
function generateConflictError(error) {
    return {
        name: "API Conflict Error",
        message: error.message || "",
        statusCode: app_enums_1.enums.HttpStatusCode.CONFLICT,
        body: error,
    };
}
exports.generateConflictError = generateConflictError;
function generateMethodNotAllowed(error) {
    return {
        name: "API Method not allowed",
        message: error.message || "",
        statusCode: app_enums_1.enums.HttpStatusCode.METHOD_NOT_ALLOWED,
        body: error,
    };
}
exports.generateMethodNotAllowed = generateMethodNotAllowed;
function generateUnauthorizedError(error) {
    return {
        name: "API Unauthorized Access Error",
        message: "",
        statusCode: app_enums_1.enums.HttpStatusCode.UNAUTHORIZED_ACCESS,
        body: error,
    };
}
exports.generateUnauthorizedError = generateUnauthorizedError;
function generateFailedDependencyError(error) {
    return {
        name: "Failed dependency error",
        message: "",
        statusCode: app_enums_1.enums.HttpStatusCode.FAILED_DEPENDENCY,
        body: error,
    };
}
exports.generateFailedDependencyError = generateFailedDependencyError;
function generateResourceRemovedError(error) {
    return {
        name: "Resource Removed  Error",
        message: "resource moved permanently",
        statusCode: app_enums_1.enums.HttpStatusCode.GONE,
        body: error,
    };
}
exports.generateResourceRemovedError = generateResourceRemovedError;
function generateUnauthroizedSnapshotAccessError(error) {
    return {
        name: "Unauthorized Snapshot Access Error",
        message: "",
        statusCode: app_enums_1.enums.HttpStatusCode.UNAUTHORIZED_SNAPSHOT_ACCESS,
        body: error,
    };
}
exports.generateUnauthroizedSnapshotAccessError = generateUnauthroizedSnapshotAccessError;
function generateTranslatedError(statusCode, message, replacements, noReport, showAsModal) {
    return new ApiTranslatedErrorStructure(statusCode, message, replacements, noReport, showAsModal);
}
exports.generateTranslatedError = generateTranslatedError;
