"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceAdapterApiModelsV1 = void 0;
var DeviceAdapterApiModelsV1;
(function (DeviceAdapterApiModelsV1) {
    class AskDeviceDataRequest {
        constructor(raw, validator) {
            validator.validateIsBoolean("configurationAndSettings", true, raw.configurationAndSettings);
            this.configurationAndSettings = raw.configurationAndSettings === true;
        }
    }
    DeviceAdapterApiModelsV1.AskDeviceDataRequest = AskDeviceDataRequest;
    class AskDeviceDataZip extends AskDeviceDataRequest {
        constructor(raw, validator) {
            super(raw, validator);
            validator.validateIsBoolean("users", true, raw.users);
            this.users = raw.users === true;
        }
    }
    DeviceAdapterApiModelsV1.AskDeviceDataZip = AskDeviceDataZip;
    class AskDeviceDataNoZip extends AskDeviceDataRequest {
        constructor(raw, validator) {
            super(raw, validator);
            validator.validateIsBoolean("users", true, raw.users);
            this.users = raw.users === true;
        }
    }
    DeviceAdapterApiModelsV1.AskDeviceDataNoZip = AskDeviceDataNoZip;
    class AddCredentialRequest {
        constructor(reqBody) {
            this.id = reqBody.id;
            this.userId = reqBody.userId;
            this.data = reqBody.data;
            this.type = reqBody.type;
            this.createdAt = new Date(reqBody.createdAt);
        }
    }
    DeviceAdapterApiModelsV1.AddCredentialRequest = AddCredentialRequest;
})(DeviceAdapterApiModelsV1 = exports.DeviceAdapterApiModelsV1 || (exports.DeviceAdapterApiModelsV1 = {}));
