"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskQueue = exports.SendEmailTask = void 0;
const app_logs_1 = require("../app.logs");
const nodemailer_1 = __importDefault(require("nodemailer"));
class SendEmailTask {
    constructor(smtpSettings, email) {
        this._smtpSettings = smtpSettings;
        this._email = email;
    }
    async perform() {
        app_logs_1.logger.info("Email is being sent to: " + this._email.to + "\n" + this._email.text);
        const transporter = nodemailer_1.default.createTransport(this._smtpSettings.config);
        await transporter.sendMail(this._email);
        transporter.close();
    }
}
exports.SendEmailTask = SendEmailTask;
class TaskQueue {
    constructor(interval, identifier) {
        this._queue = [];
        this._timer = null;
        this._interval = interval;
        this._taskIdentifier = identifier;
    }
    push(t) {
        this._queue.push(t);
        if (!this._timer) {
            this._timer = setTimeout(this.processQueue.bind(this), this._interval);
        }
    }
    async processQueue() {
        try {
            const task = this._queue.shift();
            if (task) {
                await task.perform();
            }
        }
        catch (error) {
            app_logs_1.logger.error("Error while processing queued task:");
            app_logs_1.logger.error(error);
        }
        if (this._queue.length === 0) {
            app_logs_1.logger.info(`Task queue [${this._taskIdentifier}] is drained, waiting for new tasks`);
            clearTimeout(this._timer);
            this._timer = null;
        }
        else {
            app_logs_1.logger.info(`Task queue [${this._taskIdentifier}] has ${this._queue.length} tasks, continues processing`);
            this._timer = setTimeout(this.processQueue.bind(this), this._interval);
        }
    }
}
exports.TaskQueue = TaskQueue;
