/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the CustomerProfilesChannelEndpointAssignmentList
 *
 * @param version - Version of the resource
 * @param customerProfileSid - The unique string that identifies the CustomerProfile resource.
 */
declare function CustomerProfilesChannelEndpointAssignmentList(version: V1, customerProfileSid: string): CustomerProfilesChannelEndpointAssignmentListInstance;

interface CustomerProfilesChannelEndpointAssignmentListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CustomerProfilesChannelEndpointAssignmentContext;
  /**
   * create a CustomerProfilesChannelEndpointAssignmentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CustomerProfilesChannelEndpointAssignmentListInstanceCreateOptions, callback?: (error: Error | null, item: CustomerProfilesChannelEndpointAssignmentInstance) => any): Promise<CustomerProfilesChannelEndpointAssignmentInstance>;
  /**
   * Streams CustomerProfilesChannelEndpointAssignmentInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: CustomerProfilesChannelEndpointAssignmentInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams CustomerProfilesChannelEndpointAssignmentInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: CustomerProfilesChannelEndpointAssignmentListInstanceEachOptions, callback?: (item: CustomerProfilesChannelEndpointAssignmentInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a customer_profiles_channel_endpoint_assignment
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): CustomerProfilesChannelEndpointAssignmentContext;
  /**
   * Retrieve a single target page of
   * CustomerProfilesChannelEndpointAssignmentInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentPage) => any): Promise<CustomerProfilesChannelEndpointAssignmentPage>;
  /**
   * Retrieve a single target page of
   * CustomerProfilesChannelEndpointAssignmentInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentPage) => any): Promise<CustomerProfilesChannelEndpointAssignmentPage>;
  /**
   * Lists CustomerProfilesChannelEndpointAssignmentInstance records from the API as
   * a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentInstance[]) => any): Promise<CustomerProfilesChannelEndpointAssignmentInstance[]>;
  /**
   * Lists CustomerProfilesChannelEndpointAssignmentInstance records from the API as
   * a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: CustomerProfilesChannelEndpointAssignmentListInstanceOptions, callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentInstance[]) => any): Promise<CustomerProfilesChannelEndpointAssignmentInstance[]>;
  /**
   * Retrieve a single page of CustomerProfilesChannelEndpointAssignmentInstance
   * records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentPage) => any): Promise<CustomerProfilesChannelEndpointAssignmentPage>;
  /**
   * Retrieve a single page of CustomerProfilesChannelEndpointAssignmentInstance
   * records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: CustomerProfilesChannelEndpointAssignmentListInstancePageOptions, callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentPage) => any): Promise<CustomerProfilesChannelEndpointAssignmentPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointType - The type of channel endpoint
 */
interface CustomerProfilesChannelEndpointAssignmentListInstanceCreateOptions {
  channelEndpointSid: string;
  channelEndpointType: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointSids - comma separated list of channel endpoint sids
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface CustomerProfilesChannelEndpointAssignmentListInstanceEachOptions {
  callback?: (item: CustomerProfilesChannelEndpointAssignmentInstance, done: (err?: Error) => void) => void;
  channelEndpointSid?: string;
  channelEndpointSids?: string;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointSids - comma separated list of channel endpoint sids
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface CustomerProfilesChannelEndpointAssignmentListInstanceOptions {
  channelEndpointSid?: string;
  channelEndpointSids?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointSids - comma separated list of channel endpoint sids
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface CustomerProfilesChannelEndpointAssignmentListInstancePageOptions {
  channelEndpointSid?: string;
  channelEndpointSids?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface CustomerProfilesChannelEndpointAssignmentPayload extends CustomerProfilesChannelEndpointAssignmentResource, Page.TwilioResponsePayload {
}

interface CustomerProfilesChannelEndpointAssignmentResource {
  account_sid: string;
  channel_endpoint_sid: string;
  channel_endpoint_type: string;
  customer_profile_sid: string;
  date_created: Date;
  sid: string;
  url: string;
}

interface CustomerProfilesChannelEndpointAssignmentSolution {
  customerProfileSid?: string;
}


declare class CustomerProfilesChannelEndpointAssignmentContext {
  /**
   * Initialize the CustomerProfilesChannelEndpointAssignmentContext
   *
   * @param version - Version of the resource
   * @param customerProfileSid - The unique string that identifies the resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, customerProfileSid: string, sid: string);

  /**
   * fetch a CustomerProfilesChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentInstance) => any): Promise<CustomerProfilesChannelEndpointAssignmentInstance>;
  /**
   * remove a CustomerProfilesChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class CustomerProfilesChannelEndpointAssignmentInstance extends SerializableClass {
  /**
   * Initialize the CustomerProfilesChannelEndpointAssignmentContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param customerProfileSid - The unique string that identifies the CustomerProfile resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: CustomerProfilesChannelEndpointAssignmentPayload, customerProfileSid: string, sid: string);

  private _proxy: CustomerProfilesChannelEndpointAssignmentContext;
  accountSid: string;
  channelEndpointSid: string;
  channelEndpointType: string;
  customerProfileSid: string;
  dateCreated: Date;
  /**
   * fetch a CustomerProfilesChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentInstance) => any): Promise<CustomerProfilesChannelEndpointAssignmentInstance>;
  /**
   * remove a CustomerProfilesChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CustomerProfilesChannelEndpointAssignmentInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class CustomerProfilesChannelEndpointAssignmentPage extends Page<V1, CustomerProfilesChannelEndpointAssignmentPayload, CustomerProfilesChannelEndpointAssignmentResource, CustomerProfilesChannelEndpointAssignmentInstance> {
  /**
   * Initialize the CustomerProfilesChannelEndpointAssignmentPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: CustomerProfilesChannelEndpointAssignmentSolution);

  /**
   * Build an instance of CustomerProfilesChannelEndpointAssignmentInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CustomerProfilesChannelEndpointAssignmentPayload): CustomerProfilesChannelEndpointAssignmentInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CustomerProfilesChannelEndpointAssignmentContext, CustomerProfilesChannelEndpointAssignmentInstance, CustomerProfilesChannelEndpointAssignmentList, CustomerProfilesChannelEndpointAssignmentListInstance, CustomerProfilesChannelEndpointAssignmentListInstanceCreateOptions, CustomerProfilesChannelEndpointAssignmentListInstanceEachOptions, CustomerProfilesChannelEndpointAssignmentListInstanceOptions, CustomerProfilesChannelEndpointAssignmentListInstancePageOptions, CustomerProfilesChannelEndpointAssignmentPage, CustomerProfilesChannelEndpointAssignmentPayload, CustomerProfilesChannelEndpointAssignmentResource, CustomerProfilesChannelEndpointAssignmentSolution }
