/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the TrunkList
 *
 * @param version - Version of the resource
 */
declare function TrunkList(version: V2): TrunkListInstance;

/**
 * Options to pass to update
 *
 * @property friendlyName - A human readable description of this resource.
 * @property voiceRegion - The Inbound Processing Region used for this SIP Trunk for voice
 */
interface TrunkInstanceUpdateOptions {
  friendlyName?: string;
  voiceRegion?: string;
}

interface TrunkListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TrunkContext;
  /**
   * Constructs a trunk
   *
   * @param sipTrunkDomain - The SIP Trunk
   */
  get(sipTrunkDomain: string): TrunkContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface TrunkPayload extends TrunkResource, Page.TwilioResponsePayload {
}

interface TrunkResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  sid: string;
  sip_trunk_domain: string;
  url: string;
  voice_region: string;
}

interface TrunkSolution {
}


declare class TrunkContext {
  /**
   * Initialize the TrunkContext
   *
   * @param version - Version of the resource
   * @param sipTrunkDomain - The SIP Trunk
   */
  constructor(version: V2, sipTrunkDomain: string);

  /**
   * fetch a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * update a TrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TrunkInstanceUpdateOptions, callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
}


declare class TrunkInstance extends SerializableClass {
  /**
   * Initialize the TrunkContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sipTrunkDomain - The SIP Trunk
   */
  constructor(version: V2, payload: TrunkPayload, sipTrunkDomain: string);

  private _proxy: TrunkContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  friendlyName: string;
  sid: string;
  sipTrunkDomain: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a TrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  /**
   * update a TrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TrunkInstanceUpdateOptions, callback?: (error: Error | null, items: TrunkInstance) => any): Promise<TrunkInstance>;
  url: string;
  voiceRegion: string;
}


declare class TrunkPage extends Page<V2, TrunkPayload, TrunkResource, TrunkInstance> {
  /**
   * Initialize the TrunkPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: TrunkSolution);

  /**
   * Build an instance of TrunkInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TrunkPayload): TrunkInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TrunkContext, TrunkInstance, TrunkInstanceUpdateOptions, TrunkList, TrunkListInstance, TrunkPage, TrunkPayload, TrunkResource, TrunkSolution }
