/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the TokenList
 *
 * @param version - Version of the resource
 */
declare function TokenList(version: V1): TokenListInstance;

interface TokenListInstance {
  /**
   * create a TokenInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TokenListInstanceCreateOptions, callback?: (error: Error | null, item: TokenInstance) => any): Promise<TokenInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property clientSecret - The credential for confidential OAuth App
 * @property clientSid - A string that uniquely identifies this oauth app
 * @property code - Jwt token
 * @property codeVerifier - The cryptographically generated code
 * @property deviceCode - Jwt token
 * @property deviceId - An Id of device
 * @property grantType - A way of representing resource owner's to obtain access token
 * @property refreshToken - Jwt token
 */
interface TokenListInstanceCreateOptions {
  clientSecret?: string;
  clientSid: string;
  code?: string;
  codeVerifier?: string;
  deviceCode?: string;
  deviceId?: string;
  grantType: string;
  refreshToken?: string;
}

interface TokenPayload extends TokenResource, Page.TwilioResponsePayload {
}

interface TokenResource {
  access_token: string;
  access_token_expires_at: Date;
  id_token: string;
  refresh_token: string;
  refresh_token_expires_at: Date;
}

interface TokenSolution {
}


declare class TokenInstance extends SerializableClass {
  /**
   * Initialize the TokenContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: TokenPayload);

  accessToken: string;
  accessTokenExpiresAt: Date;
  idToken: string;
  refreshToken: string;
  refreshTokenExpiresAt: Date;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class TokenPage extends Page<V1, TokenPayload, TokenResource, TokenInstance> {
  /**
   * Initialize the TokenPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TokenSolution);

  /**
   * Build an instance of TokenInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TokenPayload): TokenInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TokenInstance, TokenList, TokenListInstance, TokenListInstanceCreateOptions, TokenPage, TokenPayload, TokenResource, TokenSolution }
