'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V1 = require('./microvisor/V1');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize microvisor domain
 *
 * @constructor Twilio.Microvisor
 *
 * @property {Twilio.Microvisor.V1} v1 - v1 version
 * @property {Twilio.Microvisor.V1.AppList} apps - apps resource
 * @property {Twilio.Microvisor.V1.DeviceList} devices - devices resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Microvisor(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://microvisor.twilio.com');

  // Versions
  this._v1 = undefined;
}

_.extend(Microvisor.prototype, Domain.prototype);
Microvisor.prototype.constructor = Microvisor;

Object.defineProperty(Microvisor.prototype,
  'v1', {
    get: function() {
      this._v1 = this._v1 || new V1(this);
      return this._v1;
    }
});

Object.defineProperty(Microvisor.prototype,
  'apps', {
    get: function() {
      return this.v1.apps;
    }
});

Object.defineProperty(Microvisor.prototype,
  'devices', {
    get: function() {
      return this.v1.devices;
    }
});

module.exports = Microvisor;
