"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.amqpServerToServerSub = exports.AmqpServerToServerSub = exports.amqpAppToAppEventNames = void 0;
const app_logs_1 = require("../app.logs");
const business_scheduledjobmanager_1 = require("../business/scheduled/business.scheduledjobmanager");
const messageBroker_manager_1 = require("./messageBroker.manager");
const messagebroker_models_1 = require("./messagebroker.models");
exports.amqpAppToAppEventNames = {
    registerNotification: "registerNotification",
    unregisterNotification: "unregisterNotification",
};
class AmqpServerToServerSub {
    constructor() { }
    async init() {
        return new Promise((resolve, reject) => {
            this._connection = messageBroker_manager_1.messageBrokerManager.connection;
            this._channel = this._connection.createChannel({
                json: true,
                name: "server-to-server.sub",
                setup: async (channel) => {
                    app_logs_1.logger.debug("[server-to-server.sub] channel is establishing...");
                    await Promise.all([
                        channel.prefetch(1),
                        channel.assertExchange(messagebroker_models_1.MessageBrokerNames.deadLetter.exchange, "direct", { durable: true }),
                        channel.assertQueue(messagebroker_models_1.MessageBrokerNames.deadLetter.emailQueue, { durable: true }),
                        channel.assertExchange(messagebroker_models_1.MessageBrokerNames.serverToServer.delayedExchangeName, "x-delayed-message", {
                            durable: true,
                            arguments: { "x-delayed-type": "direct" },
                        }),
                        channel.assertQueue(messagebroker_models_1.MessageBrokerNames.serverToServer.scheduledQueue, {
                            durable: true,
                            deadLetterExchange: messagebroker_models_1.MessageBrokerNames.deadLetter.exchange,
                            deadLetterRoutingKey: messagebroker_models_1.MessageBrokerNames.deadLetter.emailBindingKey,
                        }),
                    ]);
                    await channel.bindQueue(messagebroker_models_1.MessageBrokerNames.deadLetter.emailQueue, messagebroker_models_1.MessageBrokerNames.deadLetter.exchange, messagebroker_models_1.MessageBrokerNames.deadLetter.emailBindingKey);
                    await channel.bindQueue(messagebroker_models_1.MessageBrokerNames.serverToServer.scheduledQueue, messagebroker_models_1.MessageBrokerNames.serverToServer.delayedExchangeName, messagebroker_models_1.MessageBrokerNames.serverToServer.scheduledBindingKey);
                    await channel.consume(messagebroker_models_1.MessageBrokerNames.serverToServer.scheduledQueue, business_scheduledjobmanager_1.onScheduledJob, { noAck: false });
                },
            });
            this._channel.on("error", (err) => app_logs_1.logger.error("[server-to-server.sub] error while creating channel: ", err));
            this._channel.on("connect", () => app_logs_1.logger.info("[server-to-server.sub] channel created"));
            this._channel.on("close", () => app_logs_1.logger.info("[server-to-server.sub] channel closed"));
            this._channel.once("connect", () => resolve());
        });
    }
    ack(msg) {
        this._channel.ack(msg);
    }
    nack(msg) {
        if (msg.fields.redelivered) {
            this._channel.nack(msg, false, false);
        }
        else {
            this._channel.nack(msg, false, true);
        }
    }
}
exports.AmqpServerToServerSub = AmqpServerToServerSub;
exports.amqpServerToServerSub = new AmqpServerToServerSub();
