"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.amqpServerToServerPub = void 0;
const app_logs_1 = require("../app.logs");
const messageBroker_manager_1 = require("./messageBroker.manager");
const messagebroker_models_1 = require("./messagebroker.models");
class AmqpServerToServerPub {
    constructor() {
        this._connection = null;
        this._channel = null;
    }
    async init() {
        return new Promise((resolve, reject) => {
            this._connection = messageBroker_manager_1.messageBrokerManager.connection;
            this._channel = this._connection.createChannel({
                json: true,
                name: "server-to-server.pub",
                setup: async (channel) => {
                    app_logs_1.logger.info("[server-to-server.pub] channel is creating...");
                    await Promise.all([
                        channel.prefetch(1),
                        channel.assertExchange(messagebroker_models_1.MessageBrokerNames.deadLetter.exchange, "direct", { durable: true }),
                        channel.assertQueue(messagebroker_models_1.MessageBrokerNames.deadLetter.emailQueue, { durable: true }),
                        channel.assertQueue(messagebroker_models_1.MessageBrokerNames.serverToServer.scheduledQueue, {
                            durable: true,
                            deadLetterExchange: messagebroker_models_1.MessageBrokerNames.deadLetter.exchange,
                            deadLetterRoutingKey: messagebroker_models_1.MessageBrokerNames.deadLetter.emailBindingKey,
                        }),
                    ]);
                    await channel.bindQueue(messagebroker_models_1.MessageBrokerNames.deadLetter.emailQueue, messagebroker_models_1.MessageBrokerNames.deadLetter.exchange, messagebroker_models_1.MessageBrokerNames.deadLetter.emailBindingKey);
                },
            });
            this._channel.on("error", (err) => app_logs_1.logger.error("[server-to-server.pub] error while creating channel: ", err));
            this._channel.on("connect", () => app_logs_1.logger.info("[server-to-server.pub] channel has been created"));
            this._channel.on("close", () => app_logs_1.logger.info("[server-to-server.pub] channel closed"));
            this._channel.once("connect", () => resolve());
        });
    }
    async sendToScheduledJobQueue(scheduledJob) {
        try {
            await this._channel.sendToQueue(messagebroker_models_1.MessageBrokerNames.serverToServer.scheduledQueue, scheduledJob, {
                persistent: true,
                contentType: "application/json",
            });
        }
        catch (error) {
            app_logs_1.logger.error("[server-to-report.pub] Error while trying to publish to DelayedExchange: " + error);
        }
    }
}
exports.amqpServerToServerPub = new AmqpServerToServerPub();
