"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.amqpServerToPgMaintenancePub = void 0;
const app_logs_1 = require("../app.logs");
const messageBroker_manager_1 = require("./messageBroker.manager");
const messagebroker_models_1 = require("./messagebroker.models");
const uuid = __importStar(require("uuid"));
class AmqpServerToPgMaintenancePub {
    constructor() {
        this._responseMap = new Map();
    }
    async init() {
        return new Promise((resolve, reject) => {
            this._connection = messageBroker_manager_1.messageBrokerManager.connection;
            this._channel = this._connection.createChannel({
                json: true,
                name: "server-to-pgmaintenance.pub",
                setup: async (channel) => {
                    app_logs_1.logger.debug("[server-to-pgmaintenance.pub] channel is establishing...");
                    await Promise.all([
                        channel.assertExchange(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.exchange, "topic", {
                            durable: true,
                        }),
                        channel.assertQueue(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.queue, {
                            durable: true,
                        }),
                    ]);
                    await channel.bindQueue(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.queue, messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.exchange, messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.bindingKey);
                    const { queue } = await channel.assertQueue("", { exclusive: true });
                    this._replyQueue = queue;
                    channel.consume(queue, (msg) => {
                        if (msg && msg.properties.correlationId) {
                            const correlationId = msg.properties.correlationId;
                            const response = JSON.parse(msg.content.toString());
                            if (this._responseMap.has(correlationId)) {
                                this._responseMap.get(correlationId)(response);
                                this._responseMap.delete(correlationId);
                            }
                        }
                    }, { noAck: true });
                },
            });
            this._channel.on("error", (err) => app_logs_1.logger.error("[server-to-pgmaintenance.pub] error while creating channel: ", err));
            this._channel.on("connect", () => app_logs_1.logger.info("[server-to-pgmaintenance.pub] channel created"));
            this._channel.on("close", () => app_logs_1.logger.info("[server-to-pgmaintenance.pub] channel closed"));
            this._channel.once("connect", () => resolve());
        });
    }
    async sendBackwardsPartitionRequest(months, orgId) {
        return new Promise((resolve, reject) => {
            const correlationId = uuid.v4();
            this._responseMap.set(correlationId, resolve);
            this._channel.publish(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.exchange, messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.bindingKey, { e: "backwardPartitioning", d: { months, orgId } }, {
                persistent: true,
                contentType: "application/json",
                correlationId,
                replyTo: this._replyQueue,
            }, (err) => {
                if (err) {
                    app_logs_1.logger.error("[server-to-pgmaintenance.pub] Broker rejected message error: ", err);
                    reject(err);
                }
            });
        });
    }
}
exports.amqpServerToPgMaintenancePub = new AmqpServerToPgMaintenancePub();
