"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.replyPacsMessage = exports.initServerToPacsSubChannel = void 0;
const app_logs_1 = require("../app.logs");
const messageBroker_manager_1 = require("./messageBroker.manager");
const messagebroker_models_1 = require("./messagebroker.models");
const _rpcCallbackRegistry = {};
let connection;
let channel;
let rpcCallbackQueue;
const appTag = "[service-to-pacs.sub.ts]";
async function initServerToPacsSubChannel(callback) {
    return new Promise((resolve, reject) => {
        connection = messageBroker_manager_1.messageBrokerManager.connection;
        channel = connection.createChannel({
            json: true,
            name: "service-to-pacs.sub",
            setup: async (channel) => {
                [rpcCallbackQueue] = await Promise.all([
                    channel.assertQueue(undefined, { autoDelete: true, durable: false, exclusive: true }),
                    channel.assertExchange(messagebroker_models_1.MessageBrokerNames.serverToPacs.exchange, "topic", { durable: true }),
                ]);
                await channel.bindQueue(rpcCallbackQueue.queue, messagebroker_models_1.MessageBrokerNames.serverToPacs.exchange, messagebroker_models_1.MessageBrokerNames.serverToPacs.bindingKey);
                await channel.consume(rpcCallbackQueue.queue, (msg) => {
                    const msgContent = JSON.parse(msg.content.toString());
                    callback(msgContent, msg.properties.replyTo, msg.properties.correlationId);
                }, {
                    exclusive: true,
                    consumerTag: rpcCallbackQueue.queue,
                    noAck: true,
                });
            },
        });
        channel.on("error", (err) => app_logs_1.logger.error("error while creating channel: ", err));
        channel.on("connect", () => app_logs_1.logger.info("%schannel has been created", appTag));
        channel.on("close", () => app_logs_1.logger.info("%schannel closed", appTag));
        channel.once("connect", () => resolve());
    });
}
exports.initServerToPacsSubChannel = initServerToPacsSubChannel;
async function replyPacsMessage(queue, payload, correlationId) {
    await channel.sendToQueue(queue, payload, { correlationId });
}
exports.replyPacsMessage = replyPacsMessage;
