"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.publishToNotificationService = exports.initServerToNotificationPubChannel = void 0;
const app_logs_1 = require("../app.logs");
const messageBroker_manager_1 = require("./messageBroker.manager");
const messagebroker_models_1 = require("./messagebroker.models");
let connection;
let channel;
const appTag = "[notification.pub.ts]";
async function initServerToNotificationPubChannel() {
    return new Promise((resolve, reject) => {
        connection = messageBroker_manager_1.messageBrokerManager.connection;
        channel = connection.createChannel({
            json: true,
            name: "notification.pub",
            setup: async (channel) => {
                app_logs_1.logger.info("%schannel is creating...", appTag);
                await Promise.all([
                    channel.assertExchange(messagebroker_models_1.MessageBrokerNames.serviceToNotification.exchange, "direct", { durable: true }),
                    channel.assertExchange(messagebroker_models_1.MessageBrokerNames.deadLetter.exchange, "direct", { durable: true }),
                    channel.assertExchange(messagebroker_models_1.MessageBrokerNames.notificationReAttempt.exchange, "x-delayed-message", {
                        durable: true,
                        arguments: {
                            "x-delayed-type": "direct",
                        },
                    }),
                    channel.assertQueue(messagebroker_models_1.MessageBrokerNames.serviceToNotification.queue, {
                        arguments: {
                            "x-dead-letter-exchange": messagebroker_models_1.MessageBrokerNames.deadLetter.exchange,
                            "x-dead-letter-routing-key": messagebroker_models_1.MessageBrokerNames.deadLetter.notificationBindingKey,
                        },
                        maxPriority: 10,
                        durable: true,
                    }),
                    channel.assertQueue(messagebroker_models_1.MessageBrokerNames.notificationReAttempt.queue, { durable: true, maxPriority: 10 }),
                    channel.assertQueue(messagebroker_models_1.MessageBrokerNames.deadLetter.notificationQueue, { durable: true }),
                    channel.prefetch(1),
                ]);
                await Promise.all([
                    channel.bindQueue(messagebroker_models_1.MessageBrokerNames.deadLetter.notificationQueue, messagebroker_models_1.MessageBrokerNames.deadLetter.exchange, messagebroker_models_1.MessageBrokerNames.deadLetter.notificationBindingKey),
                    channel.bindQueue(messagebroker_models_1.MessageBrokerNames.serviceToNotification.queue, messagebroker_models_1.MessageBrokerNames.serviceToNotification.exchange, messagebroker_models_1.MessageBrokerNames.serviceToNotification.bindingKey),
                    channel.bindQueue(messagebroker_models_1.MessageBrokerNames.notificationReAttempt.queue, messagebroker_models_1.MessageBrokerNames.notificationReAttempt.exchange, messagebroker_models_1.MessageBrokerNames.notificationReAttempt.bindingKey),
                ]);
            },
        });
        channel.on("error", (err) => app_logs_1.logger.error("error while creating channel: ", err));
        channel.on("connect", () => app_logs_1.logger.info("%schannel has been created", appTag));
        channel.on("close", () => app_logs_1.logger.info("%schannel closed", appTag));
        channel.once("connect", () => resolve());
    });
}
exports.initServerToNotificationPubChannel = initServerToNotificationPubChannel;
async function publishToNotificationService(notification, priority) {
    return new Promise((resolve, reject) => {
        channel.publish(messagebroker_models_1.MessageBrokerNames.serviceToNotification.exchange, messagebroker_models_1.MessageBrokerNames.serviceToNotification.bindingKey, notification, {
            persistent: true,
            priority: priority ?? undefined,
        }, (err) => {
            if (err) {
                app_logs_1.logger.error("%sBroker rejected message error: " + err, appTag);
                reject();
            }
            else {
                resolve();
            }
        });
    });
}
exports.publishToNotificationService = publishToNotificationService;
