"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path_1 = __importDefault(require("path"));
const app_config_1 = require("../../app.config");
const app_logs_1 = require("../../app.logs");
const dal_db_armon_schema_1 = require("../../dal/db/armon/dal.db.armon.schema");
const moment = require("moment");
const app_constants_1 = require("../../app.constants");
var mainDbBackupFilePrefix = "MAIN";
var logDbBackupFilePrefix = "LOG";
var backupDirectory = "/backups";
async function run() {
    console.info("Db maintainence job is starting...");
    try {
        app_config_1.appConfig.init(app_constants_1.ServiceNames.PGMaintenanceService);
        app_logs_1.appLogger.init(app_config_1.appConfig.appLogDirectory);
        mainDbBackupFilePrefix += app_config_1.appConfig.db.main.name;
        logDbBackupFilePrefix += app_config_1.appConfig.db.log.name;
    }
    catch (error) {
        console.error(error);
        process.exit(1);
    }
    app_logs_1.logger.info("Db maintainance is initialized!");
    try {
        app_logs_1.logger.info("Start backup ops.");
        dbBackup();
        app_logs_1.logger.info("Backed up successfully");
    }
    catch (error) {
        app_logs_1.logger.error(error);
        process.exit(1);
    }
    app_logs_1.logger.info("Db is maintained successfully :)");
}
function dbBackup() {
    if (Math.floor(moment().hours() / 6) === 0) {
    }
    app_logs_1.logger.info("Db backed up successfully!");
}
function mainDbBackup() {
    let outFile = path_1.default.join(backupDirectory, mainDbBackupFilePrefix + Math.floor(moment().hours() / 6) + ".sql.gz");
    (0, child_process_1.execSync)(`pg_dump -w -c | gzip --best > "${outFile}"`, {
        env: {
            PGDATABASE: app_config_1.appConfig.db.main.name,
            PGHOST: app_config_1.appConfig.db.main.host,
            PGUSER: app_config_1.appConfig.db.main.username,
            PGPASSWORD: app_config_1.appConfig.db.main.password,
        },
    });
    app_logs_1.logger.info("Main db backup up as " + outFile);
    (0, child_process_1.execSync)(`/bin/chown armon:armon ${outFile}`);
}
function logDbBackup() {
    let tableNames = Object.values(dal_db_armon_schema_1.ArmonSchema.tableNames);
    let currentYYYYMM = moment().format("YYYYMM");
    let previousYYYYMM = moment().add(-1, "month").format("YYYYMM");
    for (const tableName of tableNames) {
        try {
            logDbTableBackup(tableName, currentYYYYMM);
            if (moment().date() === 1) {
                logDbTableBackup(tableName, previousYYYYMM);
            }
        }
        catch (error) {
            app_logs_1.logger.error(error);
        }
    }
}
function logDbTableBackup(tableName, YYYYMM) {
    let outFilePartition = path_1.default.join(backupDirectory, logDbBackupFilePrefix + "_" + tableName + "_" + YYYYMM + ".sql");
    let outFileDefaultPartition = path_1.default.join(backupDirectory, logDbBackupFilePrefix + "_" + tableName + "_default.sql");
    let outFileRoot = path_1.default.join(backupDirectory, logDbBackupFilePrefix + "_" + tableName + "_T.sql");
    let isSnapshotTable = tableName === dal_db_armon_schema_1.ArmonSchema.tableNames.AccessSnapshots;
    if (!isSnapshotTable) {
        outFilePartition += ".gz";
        outFileDefaultPartition += ".gz";
    }
    (0, child_process_1.execSync)(`pg_dump --schema-only -w -c -t "public.${tableName}" > "${outFileRoot}"`, {
        env: {
            PGDATABASE: app_config_1.appConfig.db.log.name,
            PGHOST: app_config_1.appConfig.db.log.host,
            PGUSER: app_config_1.appConfig.db.log.username,
            PGPASSWORD: app_config_1.appConfig.db.log.password,
        },
    });
    (0, child_process_1.execSync)(`pg_dump -w -c -t "public.${tableName}_p${YYYYMM}" ${isSnapshotTable ? "" : "| gzip --best "}> "${outFilePartition}"`, {
        env: {
            PGDATABASE: app_config_1.appConfig.db.log.name,
            PGHOST: app_config_1.appConfig.db.log.host,
            PGUSER: app_config_1.appConfig.db.log.username,
            PGPASSWORD: app_config_1.appConfig.db.log.password,
        },
    });
    (0, child_process_1.execSync)(`pg_dump -w -c -t "public.${tableName}_default" ${isSnapshotTable ? "" : "| gzip --best "}> "${outFileDefaultPartition}"`, {
        env: {
            PGDATABASE: app_config_1.appConfig.db.log.name,
            PGHOST: app_config_1.appConfig.db.log.host,
            PGUSER: app_config_1.appConfig.db.log.username,
            PGPASSWORD: app_config_1.appConfig.db.log.password,
        },
    });
    app_logs_1.logger.info("Log db table backup up as " + outFilePartition + "," + outFileRoot + " and " + outFileDefaultPartition);
    (0, child_process_1.execSync)(`/bin/chown armon:armon ${outFileRoot}`);
    (0, child_process_1.execSync)(`/bin/chown armon:armon ${outFilePartition}`);
    (0, child_process_1.execSync)(`/bin/chown armon:armon ${outFileDefaultPartition}`);
}
run();
