"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabletApprovementStatus = exports.ServerConnectionCommand = exports.SoftwareUpdateInterfaceState = exports.TerminalAction = exports.AntiPassbackState = exports.SuggestionType = exports.SocketOrigin = exports.GeoLocationType = exports.ArmonApplicationModule = exports.IdentityUpdateResponse = exports.DeviceChangeItemType = exports.UserSelectionSessionAccessControlPointRightScope = exports.UserExpression = exports.QrCodeTrigger = exports.AuthenticationFactor = exports.AuthenticatorType = exports.AccessControlPointType = exports.VisitorQRCodeType = exports.NotificationSensorType = exports.VisitorCommunicationMediumType = exports.DayOfWeekForWorking = exports.DayOfWeek = exports.ReportServiceResult = exports.CounterSensorReason = exports.StatusSensorReason = exports.ArventoAccessLogType = exports.IntegrationType = exports.AccessLogReason = exports.AccessDirection = exports.NotificationTokenType = exports.SmsConfigType = exports.MultifactorAuthenticationOption = exports.MultifactorAuthenticationVerificationMethod = exports.IdentityStatusType = exports.UserFilterUsageType = exports.UserFilterCombinator = exports.ReportCode = exports.ReportFormat = exports.OrganizationVisitorStates = exports.NotificationMedium = exports.NotificationType = exports.joiTerminalListResultModel = exports.ErrorCode = void 0;
const joi_1 = __importDefault(require("joi"));
var ErrorCode;
(function (ErrorCode) {
    ErrorCode[ErrorCode["ConnectionError"] = 10000] = "ConnectionError";
    ErrorCode[ErrorCode["ResetDbCannotBeTrueInNonDevelopmentEnvironment"] = 10001] = "ResetDbCannotBeTrueInNonDevelopmentEnvironment";
    ErrorCode[ErrorCode["MigrationFileIsNotFound"] = 10002] = "MigrationFileIsNotFound";
    ErrorCode[ErrorCode["DropSchemaError"] = 10003] = "DropSchemaError";
    ErrorCode[ErrorCode["ScaffoldDbError"] = 10004] = "ScaffoldDbError";
    ErrorCode[ErrorCode["SeedCanBeAppliedOnlyNewScaffoldedDb"] = 10005] = "SeedCanBeAppliedOnlyNewScaffoldedDb";
    ErrorCode[ErrorCode["UnknownSeedType"] = 10006] = "UnknownSeedType";
    ErrorCode[ErrorCode["NotReadyToAccess"] = 10007] = "NotReadyToAccess";
    ErrorCode[ErrorCode["DataNotFound"] = 10008] = "DataNotFound";
    ErrorCode[ErrorCode["DataNotFoundInNotificationTable"] = 10009] = "DataNotFoundInNotificationTable";
    ErrorCode[ErrorCode["NoOrganizaitionSmtpSettings"] = 10010] = "NoOrganizaitionSmtpSettings";
    ErrorCode[ErrorCode["NoOrganizaitionSmsSettings"] = 10011] = "NoOrganizaitionSmsSettings";
    ErrorCode[ErrorCode["NoFirebasePrivateKey"] = 10012] = "NoFirebasePrivateKey";
    ErrorCode[ErrorCode["EmailTemplateNotFound"] = 10013] = "EmailTemplateNotFound";
    ErrorCode[ErrorCode["UserHasNoNotificationToken"] = 10014] = "UserHasNoNotificationToken";
    ErrorCode[ErrorCode["UserhasNoEmailAddress"] = 10015] = "UserhasNoEmailAddress";
    ErrorCode[ErrorCode["UserHasNoPhoneNumber"] = 10016] = "UserHasNoPhoneNumber";
    ErrorCode[ErrorCode["InvalidReceiver"] = 10017] = "InvalidReceiver";
    ErrorCode[ErrorCode["MissingReceiver"] = 10018] = "MissingReceiver";
    ErrorCode[ErrorCode["InvalidMediumToSend"] = 10019] = "InvalidMediumToSend";
    ErrorCode[ErrorCode["ThisNotificationIsAlreadyProcessingInNotificationService"] = 10020] = "ThisNotificationIsAlreadyProcessingInNotificationService";
    ErrorCode[ErrorCode["NoHuaweiPushSettings"] = 10021] = "NoHuaweiPushSettings";
    ErrorCode[ErrorCode["DelayedExchangePluginIsNotAvailable"] = 10021] = "DelayedExchangePluginIsNotAvailable";
    ErrorCode[ErrorCode["RpcCallTimeout"] = 10022] = "RpcCallTimeout";
    ErrorCode[ErrorCode["MissingExchange"] = 10023] = "MissingExchange";
    ErrorCode[ErrorCode["NoAmqpConnectionOrChannel"] = 10024] = "NoAmqpConnectionOrChannel";
    ErrorCode[ErrorCode["SmtpServerFailed"] = 10025] = "SmtpServerFailed";
    ErrorCode[ErrorCode["PushNotificationServerFailed"] = 10026] = "PushNotificationServerFailed";
    ErrorCode[ErrorCode["InvalidPushNotificationMedium"] = 10027] = "InvalidPushNotificationMedium";
    ErrorCode[ErrorCode["CustomNotificationChannelError"] = 1028] = "CustomNotificationChannelError";
    ErrorCode[ErrorCode["InCorrectMembershipInfoOrMessageContainsNonEnglishCharacterInSms"] = 10401] = "InCorrectMembershipInfoOrMessageContainsNonEnglishCharacterInSms";
    ErrorCode[ErrorCode["InsufficientSmsBalance"] = 10402] = "InsufficientSmsBalance";
    ErrorCode[ErrorCode["SameSmsTriedToSendAgain"] = 10451] = "SameSmsTriedToSendAgain";
    ErrorCode[ErrorCode["InvalidReceiverOnSms"] = 10452] = "InvalidReceiverOnSms";
    ErrorCode[ErrorCode["MessageSizeExceeded"] = 10453] = "MessageSizeExceeded";
    ErrorCode[ErrorCode["EmptyText"] = 10454] = "EmptyText";
    ErrorCode[ErrorCode["SmsServerTemporaryInAvailable"] = 10503] = "SmsServerTemporaryInAvailable";
    ErrorCode[ErrorCode["OneTimeAssignableCredential"] = 20000] = "OneTimeAssignableCredential";
    ErrorCode[ErrorCode["CredentialToInsertAlreadyExists"] = 20002] = "CredentialToInsertAlreadyExists";
    ErrorCode[ErrorCode["Unknown"] = 99999] = "Unknown";
})(ErrorCode = exports.ErrorCode || (exports.ErrorCode = {}));
function getPaginatedResultModel(joiItem) {
    return joi_1.default.object({
        items: joi_1.default.array().items(joiItem),
    });
}
const joiTerminalListResultItemModel = joi_1.default.object({
    id: joi_1.default.string().uuid({ version: "uuidv4" }),
    name: joi_1.default.string().max(255),
    host: joi_1.default.string().max(511),
    waitingSyncItemCount: joi_1.default.number().greater(-1).default(0),
});
exports.joiTerminalListResultModel = getPaginatedResultModel(joiTerminalListResultItemModel);
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["IdentityAccess"] = 1] = "IdentityAccess";
    NotificationType[NotificationType["StatusSensor"] = 2] = "StatusSensor";
    NotificationType[NotificationType["CounterSensor"] = 3] = "CounterSensor";
    NotificationType[NotificationType["VisitorCame"] = 4] = "VisitorCame";
    NotificationType[NotificationType["PPermissionApprovementToOwner"] = 6] = "PPermissionApprovementToOwner";
    NotificationType[NotificationType["PPermissionWaitForSignatureReminder"] = 8] = "PPermissionWaitForSignatureReminder";
    NotificationType[NotificationType["NewFeedback"] = 10] = "NewFeedback";
    NotificationType[NotificationType["FeedbackUpdate"] = 11] = "FeedbackUpdate";
    NotificationType[NotificationType["Announcement"] = 15] = "Announcement";
    NotificationType[NotificationType["HugeReport"] = 18] = "HugeReport";
    NotificationType[NotificationType["ScheduledReport"] = 19] = "ScheduledReport";
    NotificationType[NotificationType["EmploymentEnd"] = 24] = "EmploymentEnd";
    NotificationType[NotificationType["VisitorInvitation"] = 25] = "VisitorInvitation";
    NotificationType[NotificationType["PPermissionWaitForApprovementToApprover"] = 27] = "PPermissionWaitForApprovementToApprover";
    NotificationType[NotificationType["PPermissionWaitForSignature"] = 28] = "PPermissionWaitForSignature";
    NotificationType[NotificationType["PACSSelfAbsentEmployee"] = 31] = "PACSSelfAbsentEmployee";
    NotificationType[NotificationType["PACSSelfMissingWork"] = 32] = "PACSSelfMissingWork";
    NotificationType[NotificationType["VisitorExcelImportResultNotification"] = 33] = "VisitorExcelImportResultNotification";
    NotificationType[NotificationType["TerminalEmergencyStarted"] = 34] = "TerminalEmergencyStarted";
    NotificationType[NotificationType["TerminalEmergencyStopped"] = 35] = "TerminalEmergencyStopped";
    NotificationType[NotificationType["RegionEmergencyStart"] = 36] = "RegionEmergencyStart";
    NotificationType[NotificationType["RegionEmergencyStopped"] = 37] = "RegionEmergencyStopped";
    NotificationType[NotificationType["TerminalConnected"] = 38] = "TerminalConnected";
    NotificationType[NotificationType["TerminalDisconnected"] = 39] = "TerminalDisconnected";
    NotificationType[NotificationType["DoorOpenedByForce"] = 40] = "DoorOpenedByForce";
    NotificationType[NotificationType["ReportServiceError"] = 41] = "ReportServiceError";
    NotificationType[NotificationType["AccessPointQrCodeUpdatedToUser"] = 42] = "AccessPointQrCodeUpdatedToUser";
    NotificationType[NotificationType["DeviceWasNotInformed"] = 43] = "DeviceWasNotInformed";
    NotificationType[NotificationType["LicenseLimitReached"] = 44] = "LicenseLimitReached";
    NotificationType[NotificationType["SelfIdentityAccess"] = 45] = "SelfIdentityAccess";
    NotificationType[NotificationType["AccountCreated"] = 46] = "AccountCreated";
    NotificationType[NotificationType["AssaAbloyDeviceBatteryStatusChanged"] = 47] = "AssaAbloyDeviceBatteryStatusChanged";
    NotificationType[NotificationType["PPermissionApprovementStatesCompleted"] = 48] = "PPermissionApprovementStatesCompleted";
    NotificationType[NotificationType["PACSSelfOverworkedEmployee"] = 49] = "PACSSelfOverworkedEmployee";
    NotificationType[NotificationType["SMSBalance"] = 50] = "SMSBalance";
    NotificationType[NotificationType["SendingVerificationToken"] = 51] = "SendingVerificationToken";
    NotificationType[NotificationType["AccessLogExcelImportResultNotification"] = 52] = "AccessLogExcelImportResultNotification";
    NotificationType[NotificationType["WorkPlanExcelImportResultNotification"] = 53] = "WorkPlanExcelImportResultNotification";
    NotificationType[NotificationType["Custom"] = 999] = "Custom";
})(NotificationType = exports.NotificationType || (exports.NotificationType = {}));
var NotificationMedium;
(function (NotificationMedium) {
    NotificationMedium[NotificationMedium["Web"] = 1] = "Web";
    NotificationMedium[NotificationMedium["Email"] = 2] = "Email";
    NotificationMedium[NotificationMedium["SMS"] = 3] = "SMS";
    NotificationMedium[NotificationMedium["PushNotification"] = 4] = "PushNotification";
})(NotificationMedium = exports.NotificationMedium || (exports.NotificationMedium = {}));
var OrganizationVisitorStates;
(function (OrganizationVisitorStates) {
    OrganizationVisitorStates[OrganizationVisitorStates["Expected"] = 3] = "Expected";
    OrganizationVisitorStates[OrganizationVisitorStates["Active"] = 2] = "Active";
    OrganizationVisitorStates[OrganizationVisitorStates["Forbidden"] = 5] = "Forbidden";
    OrganizationVisitorStates[OrganizationVisitorStates["TemporaryPermit"] = 4] = "TemporaryPermit";
    OrganizationVisitorStates[OrganizationVisitorStates["None"] = 1] = "None";
})(OrganizationVisitorStates = exports.OrganizationVisitorStates || (exports.OrganizationVisitorStates = {}));
var ReportFormat;
(function (ReportFormat) {
    ReportFormat[ReportFormat["Excel"] = 1] = "Excel";
    ReportFormat[ReportFormat["Pdf"] = 2] = "Pdf";
})(ReportFormat = exports.ReportFormat || (exports.ReportFormat = {}));
var ReportCode;
(function (ReportCode) {
    ReportCode[ReportCode["AccessLogs"] = 1] = "AccessLogs";
    ReportCode[ReportCode["PacsFirstInLastOut"] = 2] = "PacsFirstInLastOut";
    ReportCode[ReportCode["RegionState"] = 3] = "RegionState";
    ReportCode[ReportCode["SensorEvents"] = 4] = "SensorEvents";
    ReportCode[ReportCode["Identity"] = 5] = "Identity";
    ReportCode[ReportCode["Credential"] = 6] = "Credential";
    ReportCode[ReportCode["PacsDailyWorkingHours"] = 8] = "PacsDailyWorkingHours";
    ReportCode[ReportCode["PermissionManagement"] = 9] = "PermissionManagement";
    ReportCode[ReportCode["VisitorReport"] = 11] = "VisitorReport";
    ReportCode[ReportCode["TerminatedVisits"] = 12] = "TerminatedVisits";
    ReportCode[ReportCode["RegionTicketUserUnits"] = 16] = "RegionTicketUserUnits";
    ReportCode[ReportCode["RegionTicketTransactions"] = 17] = "RegionTicketTransactions";
    ReportCode[ReportCode["UserTicketUsage"] = 18] = "UserTicketUsage";
    ReportCode[ReportCode["EmployeePermissionUsage"] = 19] = "EmployeePermissionUsage";
    ReportCode[ReportCode["FirstAndLastAccessLogs"] = 20] = "FirstAndLastAccessLogs";
    ReportCode[ReportCode["FirstAndLastAccessLogsForSingleUser"] = 21] = "FirstAndLastAccessLogsForSingleUser";
    ReportCode[ReportCode["ForbiddenUsers"] = 22] = "ForbiddenUsers";
    ReportCode[ReportCode["PacsMonthlyWorkingHoursSummary"] = 23] = "PacsMonthlyWorkingHoursSummary";
    ReportCode[ReportCode["PacsEmployeeWorkingHoursSummary"] = 24] = "PacsEmployeeWorkingHoursSummary";
    ReportCode[ReportCode["TerminalList"] = 25] = "TerminalList";
    ReportCode[ReportCode["VisitorCountReport"] = 26] = "VisitorCountReport";
    ReportCode[ReportCode["InstantAttendanceStatus"] = 27] = "InstantAttendanceStatus";
    ReportCode[ReportCode["PacsFirstInLastOutSummaryMultipleUsers"] = 30] = "PacsFirstInLastOutSummaryMultipleUsers";
    ReportCode[ReportCode["AuditLogsIdentity"] = 31] = "AuditLogsIdentity";
    ReportCode[ReportCode["AuditLogsAccessControlPoint"] = 32] = "AuditLogsAccessControlPoint";
    ReportCode[ReportCode["AuditLogsTerminal"] = 33] = "AuditLogsTerminal";
    ReportCode[ReportCode["AccessControlPointUsers"] = 34] = "AccessControlPointUsers";
    ReportCode[ReportCode["SystemFeedback"] = 35] = "SystemFeedback";
    ReportCode[ReportCode["PacsMonthlyWorkingHoursSummaryExtraWork"] = 36] = "PacsMonthlyWorkingHoursSummaryExtraWork";
    ReportCode[ReportCode["PacsPlanningCalendar"] = 37] = "PacsPlanningCalendar";
    ReportCode[ReportCode["AccessControlPoints"] = 38] = "AccessControlPoints";
    ReportCode[ReportCode["PermissionClaimUsagesForEmployees"] = 39] = "PermissionClaimUsagesForEmployees";
    ReportCode[ReportCode["DurationInRegionReportOverview"] = 40] = "DurationInRegionReportOverview";
    ReportCode[ReportCode["EntryByUnit"] = 41] = "EntryByUnit";
    ReportCode[ReportCode["AnalysisVisitorsReport"] = 42] = "AnalysisVisitorsReport";
    ReportCode[ReportCode["ArventoAccessLogsReport"] = 43] = "ArventoAccessLogsReport";
    ReportCode[ReportCode["CustomReport"] = 99] = "CustomReport";
})(ReportCode = exports.ReportCode || (exports.ReportCode = {}));
var UserFilterCombinator;
(function (UserFilterCombinator) {
    UserFilterCombinator[UserFilterCombinator["AND"] = 1] = "AND";
    UserFilterCombinator[UserFilterCombinator["OR"] = 2] = "OR";
})(UserFilterCombinator = exports.UserFilterCombinator || (exports.UserFilterCombinator = {}));
var UserFilterUsageType;
(function (UserFilterUsageType) {
    UserFilterUsageType[UserFilterUsageType["RESERVED"] = 0] = "RESERVED";
    UserFilterUsageType[UserFilterUsageType["PERMISSIONS"] = 1] = "PERMISSIONS";
    UserFilterUsageType[UserFilterUsageType["NOTIFICATION"] = 2] = "NOTIFICATION";
    UserFilterUsageType[UserFilterUsageType["USER_ACCESS_RIGHTS"] = 3] = "USER_ACCESS_RIGHTS";
    UserFilterUsageType[UserFilterUsageType["WORK_PLAN_TEMPLATE"] = 4] = "WORK_PLAN_TEMPLATE";
})(UserFilterUsageType = exports.UserFilterUsageType || (exports.UserFilterUsageType = {}));
var IdentityStatusType;
(function (IdentityStatusType) {
    IdentityStatusType[IdentityStatusType["All"] = 1] = "All";
    IdentityStatusType[IdentityStatusType["Enabled"] = 2] = "Enabled";
    IdentityStatusType[IdentityStatusType["Disabled"] = 3] = "Disabled";
})(IdentityStatusType = exports.IdentityStatusType || (exports.IdentityStatusType = {}));
var MultifactorAuthenticationVerificationMethod;
(function (MultifactorAuthenticationVerificationMethod) {
    MultifactorAuthenticationVerificationMethod[MultifactorAuthenticationVerificationMethod["SMS"] = 1] = "SMS";
    MultifactorAuthenticationVerificationMethod[MultifactorAuthenticationVerificationMethod["EMAIL"] = 2] = "EMAIL";
})(MultifactorAuthenticationVerificationMethod = exports.MultifactorAuthenticationVerificationMethod || (exports.MultifactorAuthenticationVerificationMethod = {}));
var MultifactorAuthenticationOption;
(function (MultifactorAuthenticationOption) {
    MultifactorAuthenticationOption[MultifactorAuthenticationOption["DISABLE"] = 1] = "DISABLE";
    MultifactorAuthenticationOption[MultifactorAuthenticationOption["OPTIONAL"] = 2] = "OPTIONAL";
    MultifactorAuthenticationOption[MultifactorAuthenticationOption["REQUIRED"] = 3] = "REQUIRED";
})(MultifactorAuthenticationOption = exports.MultifactorAuthenticationOption || (exports.MultifactorAuthenticationOption = {}));
var SmsConfigType;
(function (SmsConfigType) {
    SmsConfigType[SmsConfigType["IletiMerkezi"] = 1] = "IletiMerkezi";
    SmsConfigType[SmsConfigType["NetGsm"] = 2] = "NetGsm";
    SmsConfigType[SmsConfigType["MesajUssu"] = 3] = "MesajUssu";
    SmsConfigType[SmsConfigType["TurkTelekom"] = 4] = "TurkTelekom";
    SmsConfigType[SmsConfigType["Balaban"] = 5] = "Balaban";
    SmsConfigType[SmsConfigType["Armon"] = 6] = "Armon";
})(SmsConfigType = exports.SmsConfigType || (exports.SmsConfigType = {}));
var NotificationTokenType;
(function (NotificationTokenType) {
    NotificationTokenType[NotificationTokenType["Expo"] = 1] = "Expo";
    NotificationTokenType[NotificationTokenType["FireBase"] = 2] = "FireBase";
    NotificationTokenType[NotificationTokenType["HuaweiPush"] = 3] = "HuaweiPush";
})(NotificationTokenType = exports.NotificationTokenType || (exports.NotificationTokenType = {}));
var AccessDirection;
(function (AccessDirection) {
    AccessDirection[AccessDirection["All"] = 0] = "All";
    AccessDirection[AccessDirection["Entrance"] = 1] = "Entrance";
    AccessDirection[AccessDirection["Exit"] = 2] = "Exit";
})(AccessDirection = exports.AccessDirection || (exports.AccessDirection = {}));
var AccessLogReason;
(function (AccessLogReason) {
    AccessLogReason[AccessLogReason["Success"] = 0] = "Success";
    AccessLogReason[AccessLogReason["HasNotRight"] = 1] = "HasNotRight";
    AccessLogReason[AccessLogReason["UnknownCredentialOwner"] = 2] = "UnknownCredentialOwner";
    AccessLogReason[AccessLogReason["UnknownAccessPoint"] = 3] = "UnknownAccessPoint";
    AccessLogReason[AccessLogReason["UnhandledFailure"] = 4] = "UnhandledFailure";
    AccessLogReason[AccessLogReason["AntiPassbackReject"] = 5] = "AntiPassbackReject";
    AccessLogReason[AccessLogReason["AntiPassbackTimeOutReject"] = 6] = "AntiPassbackTimeOutReject";
    AccessLogReason[AccessLogReason["CredentialExpired"] = 8] = "CredentialExpired";
    AccessLogReason[AccessLogReason["InsufficientFund"] = 9] = "InsufficientFund";
    AccessLogReason[AccessLogReason["RuleReject"] = 10] = "RuleReject";
    AccessLogReason[AccessLogReason["Manual"] = 11] = "Manual";
    AccessLogReason[AccessLogReason["StateOpened"] = 12] = "StateOpened";
    AccessLogReason[AccessLogReason["StateDisabled"] = 13] = "StateDisabled";
    AccessLogReason[AccessLogReason["IncompleteMultiFactor"] = 14] = "IncompleteMultiFactor";
    AccessLogReason[AccessLogReason["Forbidden"] = 15] = "Forbidden";
    AccessLogReason[AccessLogReason["UserDisabled"] = 16] = "UserDisabled";
    AccessLogReason[AccessLogReason["RelayNotAvailable"] = 17] = "RelayNotAvailable";
    AccessLogReason[AccessLogReason["ChallengeFail"] = 18] = "ChallengeFail";
    AccessLogReason[AccessLogReason["InvalidChallenge"] = 19] = "InvalidChallenge";
    AccessLogReason[AccessLogReason["MifareFingerPrintNotMatch"] = 20] = "MifareFingerPrintNotMatch";
    AccessLogReason[AccessLogReason["MifareFingerPrintTimeout"] = 21] = "MifareFingerPrintTimeout";
    AccessLogReason[AccessLogReason["RegionCapacityFull"] = 22] = "RegionCapacityFull";
    AccessLogReason[AccessLogReason["CapacityBasedRuleReject"] = 23] = "CapacityBasedRuleReject";
    AccessLogReason[AccessLogReason["HesCodeNoRecord"] = 24] = "HesCodeNoRecord";
    AccessLogReason[AccessLogReason["HesCodeRiskly"] = 25] = "HesCodeRiskly";
    AccessLogReason[AccessLogReason["HesCodeError"] = 26] = "HesCodeError";
    AccessLogReason[AccessLogReason["Reserved"] = 99] = "Reserved";
})(AccessLogReason = exports.AccessLogReason || (exports.AccessLogReason = {}));
var IntegrationType;
(function (IntegrationType) {
    IntegrationType[IntegrationType["Arvento"] = 1] = "Arvento";
    IntegrationType[IntegrationType["ArventoRegion"] = 2] = "ArventoRegion";
})(IntegrationType = exports.IntegrationType || (exports.IntegrationType = {}));
var ArventoAccessLogType;
(function (ArventoAccessLogType) {
    ArventoAccessLogType[ArventoAccessLogType["ArventoQr"] = 1] = "ArventoQr";
    ArventoAccessLogType[ArventoAccessLogType["ArventoRegion"] = 2] = "ArventoRegion";
})(ArventoAccessLogType = exports.ArventoAccessLogType || (exports.ArventoAccessLogType = {}));
var StatusSensorReason;
(function (StatusSensorReason) {
    StatusSensorReason[StatusSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
    StatusSensorReason[StatusSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
    StatusSensorReason[StatusSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
    StatusSensorReason[StatusSensorReason["UnknownReasonOpenAlthoughRelayIsMapped"] = 4] = "UnknownReasonOpenAlthoughRelayIsMapped";
    StatusSensorReason[StatusSensorReason["UnknownReasonOpenRelayIsNotMapped"] = 5] = "UnknownReasonOpenRelayIsNotMapped";
    StatusSensorReason[StatusSensorReason["LeavedOpenned"] = 6] = "LeavedOpenned";
    StatusSensorReason[StatusSensorReason["Closed"] = 7] = "Closed";
    StatusSensorReason[StatusSensorReason["ClosedAfterLeavedOpennedTimeout"] = 8] = "ClosedAfterLeavedOpennedTimeout";
})(StatusSensorReason = exports.StatusSensorReason || (exports.StatusSensorReason = {}));
var CounterSensorReason;
(function (CounterSensorReason) {
    CounterSensorReason[CounterSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
    CounterSensorReason[CounterSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
    CounterSensorReason[CounterSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
    CounterSensorReason[CounterSensorReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
    CounterSensorReason[CounterSensorReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
    CounterSensorReason[CounterSensorReason["MoreAccessThanGranted"] = 6] = "MoreAccessThanGranted";
    CounterSensorReason[CounterSensorReason["LessAccessThanGranted"] = 7] = "LessAccessThanGranted";
})(CounterSensorReason = exports.CounterSensorReason || (exports.CounterSensorReason = {}));
var ReportServiceResult;
(function (ReportServiceResult) {
    ReportServiceResult[ReportServiceResult["Success"] = 1] = "Success";
    ReportServiceResult[ReportServiceResult["NotGeneratedBecauseOfEmptyReport"] = 2] = "NotGeneratedBecauseOfEmptyReport";
    ReportServiceResult[ReportServiceResult["UnhandledException"] = 3] = "UnhandledException";
})(ReportServiceResult = exports.ReportServiceResult || (exports.ReportServiceResult = {}));
var DayOfWeek;
(function (DayOfWeek) {
    DayOfWeek[DayOfWeek["Monday"] = 1] = "Monday";
    DayOfWeek[DayOfWeek["Tuesday"] = 2] = "Tuesday";
    DayOfWeek[DayOfWeek["Wednesday"] = 3] = "Wednesday";
    DayOfWeek[DayOfWeek["Thursday"] = 4] = "Thursday";
    DayOfWeek[DayOfWeek["Friday"] = 5] = "Friday";
    DayOfWeek[DayOfWeek["Saturday"] = 6] = "Saturday";
    DayOfWeek[DayOfWeek["Sunday"] = 7] = "Sunday";
})(DayOfWeek = exports.DayOfWeek || (exports.DayOfWeek = {}));
var DayOfWeekForWorking;
(function (DayOfWeekForWorking) {
    DayOfWeekForWorking[DayOfWeekForWorking["Monday"] = 1] = "Monday";
    DayOfWeekForWorking[DayOfWeekForWorking["Tuesday"] = 2] = "Tuesday";
    DayOfWeekForWorking[DayOfWeekForWorking["Wednesday"] = 3] = "Wednesday";
    DayOfWeekForWorking[DayOfWeekForWorking["Thursday"] = 4] = "Thursday";
    DayOfWeekForWorking[DayOfWeekForWorking["Friday"] = 5] = "Friday";
    DayOfWeekForWorking[DayOfWeekForWorking["Saturday"] = 6] = "Saturday";
    DayOfWeekForWorking[DayOfWeekForWorking["Sunday"] = 7] = "Sunday";
})(DayOfWeekForWorking = exports.DayOfWeekForWorking || (exports.DayOfWeekForWorking = {}));
var VisitorCommunicationMediumType;
(function (VisitorCommunicationMediumType) {
    VisitorCommunicationMediumType[VisitorCommunicationMediumType["Email"] = 1] = "Email";
    VisitorCommunicationMediumType[VisitorCommunicationMediumType["PhoneNumber"] = 2] = "PhoneNumber";
})(VisitorCommunicationMediumType = exports.VisitorCommunicationMediumType || (exports.VisitorCommunicationMediumType = {}));
var NotificationSensorType;
(function (NotificationSensorType) {
    NotificationSensorType[NotificationSensorType["Status"] = 1] = "Status";
    NotificationSensorType[NotificationSensorType["Counter"] = 2] = "Counter";
})(NotificationSensorType = exports.NotificationSensorType || (exports.NotificationSensorType = {}));
var VisitorQRCodeType;
(function (VisitorQRCodeType) {
    VisitorQRCodeType[VisitorQRCodeType["Id"] = 1] = "Id";
    VisitorQRCodeType[VisitorQRCodeType["Trust"] = 2] = "Trust";
})(VisitorQRCodeType = exports.VisitorQRCodeType || (exports.VisitorQRCodeType = {}));
var AccessControlPointType;
(function (AccessControlPointType) {
    AccessControlPointType[AccessControlPointType["Door"] = 0] = "Door";
    AccessControlPointType[AccessControlPointType["DropArmTripotTurnstile"] = 1] = "DropArmTripotTurnstile";
    AccessControlPointType[AccessControlPointType["ParkingGate"] = 2] = "ParkingGate";
    AccessControlPointType[AccessControlPointType["Barrier"] = 3] = "Barrier";
    AccessControlPointType[AccessControlPointType["Elevator"] = 4] = "Elevator";
    AccessControlPointType[AccessControlPointType["SecurityGate"] = 5] = "SecurityGate";
    AccessControlPointType[AccessControlPointType["TurnstileGate"] = 6] = "TurnstileGate";
    AccessControlPointType[AccessControlPointType["TripotTurnstile"] = 7] = "TripotTurnstile";
    AccessControlPointType[AccessControlPointType["AttendanceControl"] = 8] = "AttendanceControl";
    AccessControlPointType[AccessControlPointType["TicketControl"] = 9] = "TicketControl";
    AccessControlPointType[AccessControlPointType["VirtualMobileCheckin"] = 10] = "VirtualMobileCheckin";
})(AccessControlPointType = exports.AccessControlPointType || (exports.AccessControlPointType = {}));
var AuthenticatorType;
(function (AuthenticatorType) {
    AuthenticatorType[AuthenticatorType["User"] = 1] = "User";
    AuthenticatorType[AuthenticatorType["Visitor"] = 2] = "Visitor";
})(AuthenticatorType = exports.AuthenticatorType || (exports.AuthenticatorType = {}));
var AuthenticationFactor;
(function (AuthenticationFactor) {
    AuthenticationFactor[AuthenticationFactor["ProximityCard"] = 0] = "ProximityCard";
    AuthenticationFactor[AuthenticationFactor["Bluetooth"] = 2] = "Bluetooth";
    AuthenticationFactor[AuthenticationFactor["MiFare"] = 3] = "MiFare";
    AuthenticationFactor[AuthenticationFactor["AccessToken"] = 4] = "AccessToken";
    AuthenticationFactor[AuthenticationFactor["UHFRfid"] = 5] = "UHFRfid";
    AuthenticationFactor[AuthenticationFactor["VehiclePlate"] = 6] = "VehiclePlate";
    AuthenticationFactor[AuthenticationFactor["NFC"] = 8] = "NFC";
    AuthenticationFactor[AuthenticationFactor["FingerPrint"] = 9] = "FingerPrint";
    AuthenticationFactor[AuthenticationFactor["QR_BarCode"] = 14] = "QR_BarCode";
    AuthenticationFactor[AuthenticationFactor["MRZ"] = 16] = "MRZ";
})(AuthenticationFactor = exports.AuthenticationFactor || (exports.AuthenticationFactor = {}));
var QrCodeTrigger;
(function (QrCodeTrigger) {
    QrCodeTrigger[QrCodeTrigger["Bluetooth"] = 1] = "Bluetooth";
    QrCodeTrigger[QrCodeTrigger["Remote"] = 2] = "Remote";
    QrCodeTrigger[QrCodeTrigger["BluetoothThenRemote"] = 3] = "BluetoothThenRemote";
    QrCodeTrigger[QrCodeTrigger["RemoteThenBluetooth"] = 4] = "RemoteThenBluetooth";
})(QrCodeTrigger = exports.QrCodeTrigger || (exports.QrCodeTrigger = {}));
var UserExpression;
(function (UserExpression) {
    UserExpression[UserExpression["Users"] = 1] = "Users";
    UserExpression[UserExpression["Personnel"] = 2] = "Personnel";
    UserExpression[UserExpression["Employees"] = 3] = "Employees";
    UserExpression[UserExpression["Members"] = 4] = "Members";
})(UserExpression = exports.UserExpression || (exports.UserExpression = {}));
var UserSelectionSessionAccessControlPointRightScope;
(function (UserSelectionSessionAccessControlPointRightScope) {
    UserSelectionSessionAccessControlPointRightScope[UserSelectionSessionAccessControlPointRightScope["InsertNewExpandCurrent"] = 1] = "InsertNewExpandCurrent";
    UserSelectionSessionAccessControlPointRightScope[UserSelectionSessionAccessControlPointRightScope["InsertNewIgnoreCurrent"] = 2] = "InsertNewIgnoreCurrent";
    UserSelectionSessionAccessControlPointRightScope[UserSelectionSessionAccessControlPointRightScope["InsertNewOverrideCurrent"] = 3] = "InsertNewOverrideCurrent";
})(UserSelectionSessionAccessControlPointRightScope = exports.UserSelectionSessionAccessControlPointRightScope || (exports.UserSelectionSessionAccessControlPointRightScope = {}));
var DeviceChangeItemType;
(function (DeviceChangeItemType) {
    DeviceChangeItemType[DeviceChangeItemType["AddCredential"] = 1] = "AddCredential";
    DeviceChangeItemType[DeviceChangeItemType["RemoveCredential"] = 2] = "RemoveCredential";
    DeviceChangeItemType[DeviceChangeItemType["ConfigChanged"] = 3] = "ConfigChanged";
    DeviceChangeItemType[DeviceChangeItemType["SettingChanged"] = 4] = "SettingChanged";
    DeviceChangeItemType[DeviceChangeItemType["AddUser"] = 5] = "AddUser";
    DeviceChangeItemType[DeviceChangeItemType["RemoveUser"] = 6] = "RemoveUser";
    DeviceChangeItemType[DeviceChangeItemType["AddAccessRight"] = 7] = "AddAccessRight";
    DeviceChangeItemType[DeviceChangeItemType["RemoveAccessRight"] = 8] = "RemoveAccessRight";
    DeviceChangeItemType[DeviceChangeItemType["UserInfo"] = 9] = "UserInfo";
    DeviceChangeItemType[DeviceChangeItemType["RegionState"] = 10] = "RegionState";
    DeviceChangeItemType[DeviceChangeItemType["UserGroupUsers"] = 11] = "UserGroupUsers";
    DeviceChangeItemType[DeviceChangeItemType["RegionTicketBalance"] = 12] = "RegionTicketBalance";
    DeviceChangeItemType[DeviceChangeItemType["RegionTicketUsed"] = 13] = "RegionTicketUsed";
    DeviceChangeItemType[DeviceChangeItemType["RegionMaxEntranceCountRuleState"] = 14] = "RegionMaxEntranceCountRuleState";
    DeviceChangeItemType[DeviceChangeItemType["EmergencyState"] = 15] = "EmergencyState";
    DeviceChangeItemType[DeviceChangeItemType["SyncError"] = 16] = "SyncError";
    DeviceChangeItemType[DeviceChangeItemType["UserForbiddenAdd"] = 17] = "UserForbiddenAdd";
    DeviceChangeItemType[DeviceChangeItemType["UserForbiddenRemoved"] = 18] = "UserForbiddenRemoved";
    DeviceChangeItemType[DeviceChangeItemType["UpdateRequired"] = 19] = "UpdateRequired";
    DeviceChangeItemType[DeviceChangeItemType["UpsertAccessNotification"] = 20] = "UpsertAccessNotification";
    DeviceChangeItemType[DeviceChangeItemType["RemoveAccessNotification"] = 21] = "RemoveAccessNotification";
    DeviceChangeItemType[DeviceChangeItemType["UpdateCredential"] = 22] = "UpdateCredential";
    DeviceChangeItemType[DeviceChangeItemType["AccessCapacityBasedRuleApplied"] = 23] = "AccessCapacityBasedRuleApplied";
})(DeviceChangeItemType = exports.DeviceChangeItemType || (exports.DeviceChangeItemType = {}));
class IdentityUpdateResponse {
}
exports.IdentityUpdateResponse = IdentityUpdateResponse;
var ArmonApplicationModule;
(function (ArmonApplicationModule) {
    ArmonApplicationModule[ArmonApplicationModule["Visitor"] = 1] = "Visitor";
    ArmonApplicationModule[ArmonApplicationModule["SocialArea"] = 2] = "SocialArea";
    ArmonApplicationModule[ArmonApplicationModule["PACS"] = 3] = "PACS";
    ArmonApplicationModule[ArmonApplicationModule["Base"] = 0] = "Base";
})(ArmonApplicationModule = exports.ArmonApplicationModule || (exports.ArmonApplicationModule = {}));
var GeoLocationType;
(function (GeoLocationType) {
    GeoLocationType[GeoLocationType["Circle"] = 1] = "Circle";
    GeoLocationType[GeoLocationType["Polygon"] = 2] = "Polygon";
})(GeoLocationType = exports.GeoLocationType || (exports.GeoLocationType = {}));
var SocketOrigin;
(function (SocketOrigin) {
    SocketOrigin["Web"] = "1";
    SocketOrigin["Mobile"] = "2";
})(SocketOrigin = exports.SocketOrigin || (exports.SocketOrigin = {}));
var SuggestionType;
(function (SuggestionType) {
    SuggestionType[SuggestionType["Internal"] = 1] = "Internal";
    SuggestionType[SuggestionType["MERNIS"] = 2] = "MERNIS";
})(SuggestionType = exports.SuggestionType || (exports.SuggestionType = {}));
var AntiPassbackState;
(function (AntiPassbackState) {
    AntiPassbackState[AntiPassbackState["Unknown"] = 0] = "Unknown";
    AntiPassbackState[AntiPassbackState["In"] = 1] = "In";
    AntiPassbackState[AntiPassbackState["Out"] = 2] = "Out";
})(AntiPassbackState = exports.AntiPassbackState || (exports.AntiPassbackState = {}));
var TerminalAction;
(function (TerminalAction) {
    TerminalAction[TerminalAction["FingerPrintCapture"] = 2] = "FingerPrintCapture";
    TerminalAction[TerminalAction["Restart"] = 3] = "Restart";
    TerminalAction[TerminalAction["Emergency"] = 5] = "Emergency";
    TerminalAction[TerminalAction["SoftwareUpdateInterface"] = 6] = "SoftwareUpdateInterface";
    TerminalAction[TerminalAction["ServerConnection"] = 7] = "ServerConnection";
})(TerminalAction = exports.TerminalAction || (exports.TerminalAction = {}));
var SoftwareUpdateInterfaceState;
(function (SoftwareUpdateInterfaceState) {
    SoftwareUpdateInterfaceState[SoftwareUpdateInterfaceState["Enable"] = 1] = "Enable";
    SoftwareUpdateInterfaceState[SoftwareUpdateInterfaceState["Disable"] = 2] = "Disable";
    SoftwareUpdateInterfaceState[SoftwareUpdateInterfaceState["NotSupported"] = 3] = "NotSupported";
})(SoftwareUpdateInterfaceState = exports.SoftwareUpdateInterfaceState || (exports.SoftwareUpdateInterfaceState = {}));
var ServerConnectionCommand;
(function (ServerConnectionCommand) {
    ServerConnectionCommand[ServerConnectionCommand["Connect"] = 1] = "Connect";
    ServerConnectionCommand[ServerConnectionCommand["Disconnect"] = 2] = "Disconnect";
})(ServerConnectionCommand = exports.ServerConnectionCommand || (exports.ServerConnectionCommand = {}));
var TabletApprovementStatus;
(function (TabletApprovementStatus) {
    TabletApprovementStatus[TabletApprovementStatus["Approved"] = 1] = "Approved";
    TabletApprovementStatus[TabletApprovementStatus["NotApproved"] = 2] = "NotApproved";
    TabletApprovementStatus[TabletApprovementStatus["All"] = 3] = "All";
})(TabletApprovementStatus = exports.TabletApprovementStatus || (exports.TabletApprovementStatus = {}));
